/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.discovery;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredTextDocument;
import net.jxta.exception.DiscardQueryException;
import net.jxta.exception.NoResponseException;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ResendQueryException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.discovery.DiscoveryServiceInterface;
import net.jxta.impl.protocol.DiscoveryQuery;
import net.jxta.impl.protocol.DiscoveryResponse;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class DiscoveryServiceImpl
implements DiscoveryService,
QueryHandler {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$discovery$DiscoveryServiceImpl == null ? (class$net$jxta$impl$discovery$DiscoveryServiceImpl = DiscoveryServiceImpl.class$("net.jxta.impl.discovery.DiscoveryServiceImpl")) : class$net$jxta$impl$discovery$DiscoveryServiceImpl).getName());
    private static int qid = 0;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    protected Cm cm;
    protected String[] dirname = new String[]{"Peers", "Groups", "Adv"};
    private ResolverService resolver;
    private PeerGroup group = null;
    private String localPeerId = null;
    private long seed = System.currentTimeMillis();
    private Vector listeners = new Vector();
    private Hashtable listenerTable = new Hashtable();
    private ModuleImplAdvertisement implAdvertisement = null;
    private String localPeerAdvStr = null;
    private String handlerName = null;
    private boolean lastIsRdv = false;
    static /* synthetic */ Class class$net$jxta$impl$discovery$DiscoveryServiceImpl;

    private void updatePeerAdvStr() {
        boolean bl = this.group.isRendezvous();
        if (this.lastIsRdv != bl) {
            this.localPeerAdvStr = this.advToString(this.group.getPeerAdvertisement());
            this.lastIsRdv = bl;
        }
    }

    public Service getInterface() {
        return new DiscoveryServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public int getRemoteAdvertisements(String string, int n, String string2, String string3, int n2) {
        if (this.resolver == null) {
            return this.nextQid();
        }
        this.updatePeerAdvStr();
        DiscoveryQuery discoveryQuery = new DiscoveryQuery(n, this.localPeerAdvStr, string2, string3, n2);
        if (string2 != null && string3 != null) {
            discoveryQuery.setAttr(string2);
            discoveryQuery.setValue(string3);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("sending query: " + string2 + " = " + string3));
            }
        }
        int n3 = this.nextQid();
        ResolverQuery resolverQuery = new ResolverQuery(this.handlerName, "JXTACRED", this.localPeerId, discoveryQuery.toString(), n3);
        this.resolver.sendQuery(string, resolverQuery);
        return n3;
    }

    public void getRemoteAdvertisements(String string, int n, String string2, String string3, int n2, DiscoveryListener discoveryListener) {
        if (this.resolver == null) {
            return;
        }
        this.updatePeerAdvStr();
        DiscoveryQuery discoveryQuery = new DiscoveryQuery(n, this.localPeerAdvStr, string2, string3, n2);
        if (string2 != null && string3 != null) {
            discoveryQuery.setAttr(string2);
            discoveryQuery.setValue(string3);
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("sending query: " + string2 + " = " + string3));
            }
        }
        int n3 = this.nextQid();
        if (discoveryListener != null) {
            this.listenerTable.put(new Integer(n3), discoveryListener);
        }
        ResolverQuery resolverQuery = new ResolverQuery(this.handlerName, "JXTACRED", this.localPeerId, discoveryQuery.toString(), n3);
        this.resolver.sendQuery(string, resolverQuery);
    }

    public Enumeration getLocalAdvertisements(int n, String string, String string2) throws IOException {
        if (n > 2 || n < 0) {
            throw new IllegalArgumentException("Unknown Advertisement type");
        }
        return this.search(n, string, string2, Integer.MAX_VALUE, false, null).elements();
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public int startApp(String[] stringArray) {
        this.resolver = this.group.getResolverService();
        this.resolver.registerHandler(this.handlerName, this);
        return 0;
    }

    public void stopApp() {
        if (this.resolver != null && this.resolver.unregisterHandler(this.handlerName) == null && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"failed to unregister discovery from resolver.");
        }
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        block6: {
            block5: {
                this.implAdvertisement = (ModuleImplAdvertisement)advertisement;
                this.group = peerGroup;
                this.handlerName = iD.toString();
                this.localPeerId = this.group.getPeerID().toString();
                this.localPeerAdvStr = this.advToString(this.group.getPeerAdvertisement());
                this.lastIsRdv = this.group.isRendezvous();
                try {
                    String string = this.group.getPeerGroupID().getUniqueValue().toString();
                    this.cm = new Cm(string, new Cm.ExpirationListener(){

                        public void expired(String string, String string2, long l) {
                            block8: {
                                int n = -1;
                                if (string.equals(DiscoveryServiceImpl.this.dirname[1])) {
                                    n = 1;
                                } else if (string.equals(DiscoveryServiceImpl.this.dirname[0])) {
                                    n = 0;
                                } else if (string.equals(DiscoveryServiceImpl.this.dirname[2])) {
                                    n = 2;
                                }
                                if (n != -1) {
                                    try {
                                        String string3 = new String(DiscoveryServiceImpl.this.cm.restoreBytes(string, string2));
                                        DiscoveryServiceImpl.this.remotePublish(string3, n, l);
                                    }
                                    catch (IOException iOException) {
                                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block8;
                                        LOG.debug((Object)("Cannot restore " + string + "/" + string2), (Throwable)iOException);
                                    }
                                }
                            }
                        }
                    }, true);
                    String[] stringArray = new String[]{"Name", "PID"};
                    String[] stringArray2 = new String[]{"Name", "GID", "Desc"};
                    String[] stringArray3 = new String[]{"Name", "Id", "MSID", "RdvGroupId"};
                    this.cm.createFolder(this.dirname[0], stringArray);
                    this.cm.createFolder(this.dirname[1], stringArray2);
                    this.cm.createFolder(this.dirname[2], stringArray3);
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block5;
                    LOG.debug((Object)"Error during creation of local store", (Throwable)exception);
                }
            }
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"publishing local advertisement");
                }
                this.publish(this.group.getPeerAdvertisement(), 0, 1471228928L, 0x6DDD00L);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block6;
                LOG.debug((Object)"Error when publishing local peer advertisement: ", (Throwable)exception);
            }
        }
    }

    public void flushAdvertisements(String string, int n) throws IOException {
        if (n <= 2 && string != null) {
            ID iD = IDFactory.fromURL(new URL(string));
            String string2 = iD.getUniqueValue().toString();
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("flushing adv " + string2 + " of type " + this.dirname[n]));
            }
            this.cm.remove(this.dirname[n], string2);
        } else {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("flushing advertisements of type " + this.dirname[n]));
            }
            String[] stringArray = this.cm.getFileNames(this.dirname[n]);
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.cm.remove(this.dirname[n], stringArray[n2]);
                ++n2;
            }
        }
    }

    public void publish(Advertisement advertisement, int n) throws IOException {
        this.publish(advertisement, n, 1471228928L, 0x6DDD00L);
    }

    public void publish(Advertisement advertisement, int n, long l, long l2) throws IOException {
        StructuredDocument structuredDocument;
        ID iD = null;
        String string = null;
        iD = advertisement.getID();
        if (iD != null && iD.equals(ID.nullID)) {
            iD = null;
        }
        try {
            structuredDocument = (StructuredDocument)advertisement.getDocument(new MimeMediaType("text/xml"));
        }
        catch (Exception exception) {
            throw new IOException("Advertisement couldnt be saved because of :" + exception.toString());
        }
        string = iD == null ? Cm.createTmpName(structuredDocument) : iD.getUniqueValue().toString();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("publishing " + string + " in " + this.dirname[n]));
        }
        this.cm.save(this.dirname[n], string, structuredDocument, l, l2);
    }

    public void remotePublish(Advertisement advertisement, int n) {
        this.remotePublish(advertisement, n, 0x6DDD00L);
    }

    public void remotePublish(Advertisement advertisement, int n, long l) {
        this.remotePublish(this.advToString(advertisement), n, l);
    }

    public void processResponse(ResolverResponseMsg resolverResponseMsg) {
        Object object;
        Object object2;
        DiscoveryResponse discoveryResponse;
        try {
            discoveryResponse = new DiscoveryResponse(new ByteArrayInputStream(resolverResponseMsg.getResponse().getBytes()));
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)exception);
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Got a " + this.dirname[discoveryResponse.getDiscoveryType()] + " response : " + discoveryResponse.getQueryAttr() + " = " + discoveryResponse.getQueryValue()));
        }
        try {
            object2 = discoveryResponse.getPeerAdv();
            object = new ByteArrayInputStream(((String)object2).getBytes());
            PeerAdvertisement peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), (InputStream)object);
            if (peerAdvertisement != null) {
                this.publish(peerAdvertisement, 0, 0x6DDD00L, 0x6DDD00L);
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)exception);
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"getting responses");
        }
        object = discoveryResponse.getResponses();
        Enumeration enumeration = discoveryResponse.getExpirations();
        if (object != null) {
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                long l = (Long)enumeration.nextElement();
                if (l <= 0L) continue;
                try {
                    object2 = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(string.getBytes()));
                    if (object2 == null) continue;
                    this.publish((Advertisement)object2, discoveryResponse.getDiscoveryType(), l, l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        DiscoveryEvent discoveryEvent = new DiscoveryEvent(this, discoveryResponse, resolverResponseMsg.getQueryId());
        DiscoveryListener discoveryListener = (DiscoveryListener)this.listenerTable.get(new Integer(resolverResponseMsg.getQueryId()));
        if (discoveryListener != null) {
            discoveryListener.discoveryEvent(new DiscoveryEvent(this, discoveryResponse, resolverResponseMsg.getQueryId()));
        }
        if (this.listeners.size() > 0) {
            int n = 0;
            while (n < this.listeners.size()) {
                discoveryListener = (DiscoveryListener)this.listeners.elementAt(n);
                discoveryListener.discoveryEvent(discoveryEvent);
                ++n;
            }
        }
    }

    public ResolverResponseMsg processQuery(ResolverQueryMsg resolverQueryMsg) throws NoResponseException, DiscardQueryException, IOException, ResendQueryException {
        DiscoveryQuery discoveryQuery;
        Vector vector;
        Vector vector2;
        block12: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery starts");
            }
            Object var3_2 = null;
            vector2 = null;
            vector = new Vector();
            try {
                discoveryQuery = new DiscoveryQuery(new ByteArrayInputStream(resolverQueryMsg.getQuery().getBytes()));
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Error in query : ", (Throwable)exception);
                }
                throw new IOException();
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Got a " + this.dirname[discoveryQuery.getDiscoveryType()] + " query " + discoveryQuery.getAttr() + " = " + discoveryQuery.getValue()));
            }
            PeerAdvertisement peerAdvertisement = null;
            try {
                peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(discoveryQuery.getPeerAdv().getBytes()));
                if (!peerAdvertisement.getPeerID().toString().equals(this.localPeerId)) {
                    this.publish(peerAdvertisement, 0, 0x6DDD00L, 0x6DDD00L);
                }
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block12;
                LOG.debug((Object)exception);
            }
        }
        vector2 = this.search(discoveryQuery.getDiscoveryType(), discoveryQuery.getAttr(), discoveryQuery.getValue(), discoveryQuery.getThreshold(), true, vector);
        if (vector2 == null || vector2.size() == 0) {
            if (this.group.isRendezvous()) {
                throw new NoResponseException();
            }
            throw new DiscardQueryException();
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Responding  to " + this.dirname[discoveryQuery.getDiscoveryType()] + " Query : " + discoveryQuery.getAttr() + " = " + discoveryQuery.getValue()));
        }
        this.updatePeerAdvStr();
        DiscoveryResponse discoveryResponse = new DiscoveryResponse(vector2.size(), discoveryQuery.getDiscoveryType(), this.localPeerAdvStr, discoveryQuery.getAttr(), discoveryQuery.getValue(), vector2, vector);
        if (discoveryQuery.getDiscoveryType() > 0 && vector2.isEmpty()) {
            throw new DiscardQueryException();
        }
        ResolverResponse resolverResponse = new ResolverResponse(this.handlerName, "JXTACRED", resolverQueryMsg.getQueryId(), discoveryResponse.toString());
        return resolverResponse;
    }

    public synchronized void addDiscoveryListener(DiscoveryListener discoveryListener) {
        this.listeners.addElement(discoveryListener);
    }

    public synchronized boolean removeDiscoveryListener(DiscoveryListener discoveryListener) {
        Enumeration enumeration = this.listenerTable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (this.listenerTable.get(k) != discoveryListener) continue;
            this.listenerTable.remove(k);
        }
        return this.listeners.removeElement(discoveryListener);
    }

    protected synchronized int next(int n) {
        long l;
        this.seed = l = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(l >>> 48 - n);
    }

    void remotePublish(String string, int n, long l) {
        DiscoveryResponse discoveryResponse;
        block6: {
            if (this.resolver == null) {
                return;
            }
            Vector vector = new Vector();
            if (n == 0) {
                return;
            }
            Vector<String> vector2 = new Vector<String>(1);
            Vector<Long> vector3 = new Vector<Long>(1);
            discoveryResponse = null;
            vector2.addElement(string);
            vector3.addElement(new Long(l));
            this.updatePeerAdvStr();
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Remote publishing Group");
                }
                discoveryResponse = new DiscoveryResponse(1, n, this.localPeerAdvStr, null, null, vector2, vector3);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block6;
                LOG.debug((Object)exception);
            }
        }
        ResolverResponse resolverResponse = new ResolverResponse(this.handlerName, "JXTACRED", 0, discoveryResponse.toString());
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"remote publishing");
        }
        this.resolver.sendResponse(null, resolverResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector search(int n, String string, String string2, int n2, boolean bl, Vector vector) {
        FileInputStream fileInputStream = null;
        Enumeration enumeration = null;
        Vector<Object> vector2 = new Vector<Object>();
        if (string != null || string2 != null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"narrowing down the response.");
            }
            if ((enumeration = this.cm.search(this.dirname[n], string, string2)) == null) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) return vector2;
                LOG.debug((Object)("No hits on query" + string + " " + string2));
                return vector2;
            }
            int n3 = 1;
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    return vector2;
                }
                String string3 = (String)enumeration.nextElement();
                try {
                    block29: {
                        if (string3.equals(this.localPeerId)) continue;
                        if (bl) {
                            vector2.addElement(new String(this.cm.restoreBytes(this.dirname[n], string3)));
                            vector.addElement(new Long(this.cm.getExpirationTime(this.dirname[n], string3)));
                        } else {
                            IOException iOException2;
                            Object var14_18;
                            try {
                                fileInputStream = this.cm.getInputStream(this.dirname[n], string3);
                                Advertisement advertisement = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), fileInputStream, this.cm.getExpirationTime(this.dirname[n], string3));
                                vector2.addElement(advertisement);
                                var14_18 = null;
                                if (fileInputStream == null) break block29;
                            }
                            catch (Throwable throwable) {
                                var14_18 = null;
                                if (fileInputStream == null) throw throwable;
                                try {
                                    fileInputStream.close();
                                    throw throwable;
                                }
                                catch (IOException iOException2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {}
                            catch (IOException iOException2) {}
                            fileInputStream.close();
                        }
                    }
                    if (++n3 <= n2) continue;
                    return vector2;
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)"search failed", (Throwable)exception);
                    continue;
                }
                break;
            }
        }
        String[] stringArray = this.cm.getFileNames(this.dirname[n]);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"remote does not care about narrowing down the response.");
        }
        if (stringArray == null) return vector2;
        if (stringArray.length == 0) {
            return vector2;
        }
        int n4 = 0;
        while (true) {
            block31: {
                if (n4 >= stringArray.length) {
                    return vector2;
                }
                try {
                    block30: {
                        if (!stringArray[n4].equals(this.localPeerId) && this.cm.getExpirationTime(this.dirname[n], stringArray[n4]) > 0L) {
                            if (bl) {
                                vector2.addElement(new String(this.cm.restoreBytes(this.dirname[n], stringArray[n4])));
                                vector.addElement(new Long(this.cm.getExpirationTime(this.dirname[n], stringArray[n4])));
                            } else {
                                IOException iOException3;
                                Object var17_21;
                                try {
                                    fileInputStream = this.cm.getInputStream(this.dirname[n], stringArray[n4]);
                                    Advertisement advertisement = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), fileInputStream, this.cm.getExpirationTime(this.dirname[n], stringArray[n4]));
                                    vector2.addElement(advertisement);
                                    var17_21 = null;
                                    if (fileInputStream == null) break block30;
                                }
                                catch (Throwable throwable) {
                                    var17_21 = null;
                                    if (fileInputStream == null) throw throwable;
                                    try {
                                        fileInputStream.close();
                                        throw throwable;
                                    }
                                    catch (IOException iOException3) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                try {}
                                catch (IOException iOException3) {}
                                fileInputStream.close();
                            }
                        }
                    }
                    if (n4 >= n2 - 1) {
                        return vector2;
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block31;
                    LOG.debug((Object)exception);
                }
            }
            ++n4;
        }
    }

    private String advToString(Advertisement advertisement) {
        StringWriter stringWriter = new StringWriter();
        MimeMediaType mimeMediaType = new MimeMediaType("text/xml");
        try {
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)advertisement.getDocument(mimeMediaType);
            structuredTextDocument.sendToWriter(stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int nextInt(int n) {
        int n2;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((n3 = this.next(31)) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    private synchronized int nextQid() {
        return qid++;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

