/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.config;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.config.ConfigUtil;
import net.jxta.impl.endpoint.Address;

public class HttpConfig {
    private static final int DEFAULT_PORT = 6002;
    private static final String DEFAULT_IMPL = "net.jxta.impl.endpoint.http.HttpTransport";
    private String mImplClassname;
    private EndpointAddress mServerAddress;
    private EndpointAddress mRouterAddress;
    private EndpointAddress mProxyAddress;
    private boolean mUseProxy;
    private boolean mUsePublicAddress;
    private EndpointAddress mPublicAddress;
    private String mPeerID;
    private static final String KEY_SERVER = "Server";
    private static final String KEY_PROXY = "ProxyServer";
    private static final String KEY_USE_PROXY = "UseProxyServer";
    private static final String KEY_ROUTER = "Router";
    private static final String KEY_IMPL = "Impl";

    public static HttpConfig createDefaultConfig() {
        HttpConfig httpConfig = new HttpConfig();
        httpConfig.setImplClassname(DEFAULT_IMPL);
        httpConfig.setServerAddress(new Address("http://localhost:6002"));
        return httpConfig;
    }

    public static HttpConfig newFromXML(TextElement textElement) {
        Enumeration enumeration = textElement.getChildren();
        if (enumeration == null) {
            return null;
        }
        HttpConfig httpConfig = new HttpConfig();
        while (enumeration.hasMoreElements()) {
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            String string = textElement2.getName();
            if (string.equals(KEY_IMPL)) {
                httpConfig.mImplClassname = textElement2.getTextValue();
                continue;
            }
            if (string.equals(KEY_SERVER)) {
                httpConfig.mServerAddress = new Address(textElement2.getTextValue());
                continue;
            }
            if (string.equals(KEY_ROUTER)) {
                httpConfig.mRouterAddress = new Address(textElement2.getTextValue());
                continue;
            }
            if (string.equals(KEY_PROXY)) {
                httpConfig.mProxyAddress = new Address(textElement2.getTextValue());
                continue;
            }
            if (string.equals(KEY_USE_PROXY)) {
                httpConfig.mUseProxy = Boolean.valueOf(textElement2.getTextValue());
                continue;
            }
            if (string.equals("PublicAddress")) {
                httpConfig.mPublicAddress = new Address(textElement2.getTextValue());
                continue;
            }
            if (!string.equals("UsePublicAddress")) continue;
            httpConfig.mUsePublicAddress = Boolean.valueOf(textElement2.getTextValue());
        }
        return httpConfig;
    }

    public void writeToXML(StructuredTextDocument structuredTextDocument) {
        TextElement textElement = structuredTextDocument.createElement("HTTP");
        structuredTextDocument.appendChild((Element)textElement);
        ConfigUtil.writeAddress(structuredTextDocument, textElement, this.mServerAddress, KEY_SERVER);
        ConfigUtil.writeAddress(structuredTextDocument, textElement, this.mRouterAddress, KEY_ROUTER);
        ConfigUtil.writeAddress(structuredTextDocument, textElement, this.mProxyAddress, KEY_PROXY);
        textElement.appendChild((Element)structuredTextDocument.createElement(KEY_USE_PROXY, String.valueOf(this.mUseProxy)));
        ConfigUtil.writeAddress(structuredTextDocument, textElement, this.mPublicAddress, "PublicAddress");
        textElement.appendChild((Element)structuredTextDocument.createElement("UsePublicAddress", String.valueOf(this.mUsePublicAddress)));
        TextElement textElement2 = structuredTextDocument.createElement(KEY_IMPL, this.mImplClassname);
        textElement.appendChild((Element)textElement2);
    }

    public EndpointAddress getServerAddress() {
        return this.mServerAddress;
    }

    public void setServerAddress(EndpointAddress endpointAddress) {
        this.mServerAddress = endpointAddress;
    }

    public String getImplClassname() {
        return this.mImplClassname;
    }

    public void setImplClassname(String string) {
        this.mImplClassname = string;
    }

    public EndpointAddress getRouterAddress() {
        return this.mRouterAddress;
    }

    public void setRouterAddress(EndpointAddress endpointAddress) {
        this.mRouterAddress = endpointAddress;
    }

    public EndpointAddress getProxyAddress() {
        return this.mProxyAddress;
    }

    public void setProxyAddress(EndpointAddress endpointAddress) {
        this.mProxyAddress = endpointAddress;
    }

    public boolean getUseProxy() {
        return this.mUseProxy;
    }

    public void setUseProxy(boolean bl) {
        this.mUseProxy = bl;
    }

    public EndpointAddress getPublicAddress() {
        return this.mPublicAddress;
    }

    public void setPublicAddress(EndpointAddress endpointAddress) {
        this.mPublicAddress = endpointAddress;
    }

    public boolean getUsePublicAddress() {
        return this.mUsePublicAddress;
    }

    public void setUsePublicAddress(boolean bl) {
        this.mUsePublicAddress = bl;
    }
}

