/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import net.jxta.impl.cm.PriorityQueue;

public class SchedulerService
implements Runnable {
    volatile boolean done = false;
    SchedulerPriorityQueue heap = new SchedulerPriorityQueue(1024, 2);

    public synchronized PendingAction scheduleAction(Action action, long l) {
        PendingAction pendingAction = null;
        if (l >= 0L) {
            pendingAction = new PendingAction(action, System.currentTimeMillis() + l);
            this.heap.put(pendingAction);
            if (this.heap.top() == pendingAction) {
                this.notify();
            }
        }
        return pendingAction;
    }

    private synchronized void doCancel(PendingAction pendingAction) {
        pendingAction.cancel();
        if (this.heap.top() == pendingAction) {
            this.notify();
        }
    }

    public void cancelAction(PendingAction pendingAction) {
        this.doCancel(pendingAction);
        pendingAction.noPerform();
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        while (!this.done) {
            PendingAction pendingAction = this.getNextEvent();
            if (this.done) break;
            try {
                pendingAction.perform(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Thread.yield();
        }
    }

    private synchronized PendingAction getNextEvent() {
        if (this.done) {
            return null;
        }
        PendingAction pendingAction = (PendingAction)this.heap.top();
        long l = pendingAction == null ? Long.MAX_VALUE : pendingAction.time - System.currentTimeMillis();
        try {
            while (!this.done) {
                if (l > 0L) {
                    this.wait(l);
                }
                if (!this.done) {
                    if (pendingAction != this.heap.top()) {
                        pendingAction = (PendingAction)this.heap.top();
                        l = pendingAction.time - System.currentTimeMillis();
                        continue;
                    }
                    this.heap.pop();
                    pendingAction.nonCancelable();
                    return pendingAction;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            this.done = true;
        }
        return null;
    }

    public static interface Action {
        public void perform(SchedulerService var1);
    }

    class SchedulerPriorityQueue
    extends PriorityQueue {
        SchedulerPriorityQueue(int n, int n2) {
            super.initialize(n, n2);
        }

        protected boolean lessThan(Object object, Object object2) {
            PendingAction pendingAction = (PendingAction)object;
            PendingAction pendingAction2 = (PendingAction)object2;
            return pendingAction.time < pendingAction2.time;
        }
    }

    public class PendingAction {
        Action action;
        boolean cancelable = true;
        long time;

        PendingAction(Action action, long l) {
            this.action = action;
            this.time = l;
        }

        public long getTime() {
            return this.time;
        }

        void perform(SchedulerService schedulerService) {
            if (this.action != null) {
                PendingAction pendingAction;
                try {
                    this.action.perform(schedulerService);
                    Object var3_2 = null;
                    pendingAction = this;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    PendingAction pendingAction2 = this;
                    synchronized (pendingAction2) {
                        this.action = null;
                        this.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (pendingAction) {
                    this.action = null;
                    this.notifyAll();
                }
            }
        }

        void nonCancelable() {
            this.cancelable = false;
        }

        void cancel() {
            if (this.cancelable) {
                this.action = null;
            }
        }

        synchronized void noPerform() {
            try {
                while (this.action != null) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

