/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.impl.cm.SchedulerService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class FileExpirationService {
    File dir;
    File db;
    File tmpDb;
    Vector docDirs;
    SchedulerService ss;
    RandomAccessFile out;
    Hashtable hash;
    int mods;
    SchedulerService.PendingAction pendingCompressAction;
    ExpirationListener listener;
    static final int SCHEDULE = 1;
    static final int CANCEL = 2;
    static final long COMPRESS_INTERVAL = 1800000L;
    static final int MOD_THRESHOLD = 128;
    static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$cm$FileExpirationService == null ? (class$net$jxta$impl$cm$FileExpirationService = FileExpirationService.class$("net.jxta.impl.cm.FileExpirationService")) : class$net$jxta$impl$cm$FileExpirationService).getName());
    static /* synthetic */ Class class$net$jxta$impl$cm$FileExpirationService;

    FileExpirationService(SchedulerService schedulerService, File file, File[] fileArray, ExpirationListener expirationListener) throws IOException {
        this.db = new File(file, "scheduler.db");
        this.tmpDb = new File(file, ".tmp.scheduler.db");
        if (!file.exists()) {
            file.mkdirs();
        }
        this.ss = schedulerService;
        this.dir = file;
        this.listener = expirationListener;
        this.docDirs = new Vector();
        this.hash = new Hashtable();
        if (this.db.exists()) {
            this.compress();
        } else {
            this.out = new RandomAccessFile(this.db, "rw");
        }
        this.pendingCompressAction = schedulerService.scheduleAction(new CleanupAction(), 1800000L);
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            this.addDocDir(file);
            ++n;
        }
    }

    void addDocDir(File file) {
        this.docDirs.addElement(file);
    }

    void stop() {
        block3: {
            this.ss.cancelAction(this.pendingCompressAction);
            try {
                if (this.db.exists()) {
                    this.compress();
                }
                this.out.close();
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block3;
                LOG.debug((Object)"Compression of log stream failed on stop()", (Throwable)iOException);
            }
        }
    }

    public synchronized long getExpirationTime(File file) {
        Entry entry = (Entry)this.hash.get(file.getAbsolutePath());
        if (entry == null) {
            return -1L;
        }
        return Math.min(entry.timeInMyCache, entry.timeoutForOthers + System.currentTimeMillis());
    }

    public void scheduleFileExpiration(File file, long l, long l2) throws IOException {
        while (true) {
            Entry entry = null;
            FileExpirationService fileExpirationService = this;
            synchronized (fileExpirationService) {
                entry = (Entry)this.hash.get(file.getAbsolutePath());
                if (entry == null) {
                    long l3 = l - System.currentTimeMillis();
                    entry = new Entry(file, l, l2);
                    ExpireAction expireAction = new ExpireAction(entry);
                    entry.myPendingAction = this.ss.scheduleAction(expireAction, l3);
                    if (entry.myPendingAction != null) {
                        this.hash.put(file.getAbsolutePath(), entry);
                        this.log(1, file, l, l2);
                        ++this.mods;
                    }
                    return;
                }
                if (entry.timeInMyCache > l) {
                    return;
                }
                if (entry.timeInMyCache == l && entry.timeoutForOthers == l2) {
                    return;
                }
                this.hash.remove(file.getAbsolutePath());
            }
            this.ss.cancelAction(entry.myPendingAction);
        }
    }

    public void cancelFileExpiration(File file) {
        Entry entry = null;
        FileExpirationService fileExpirationService = this;
        synchronized (fileExpirationService) {
            entry = (Entry)this.hash.get(file.getAbsolutePath());
            if (entry == null) {
                return;
            }
            this.hash.remove(file.getAbsolutePath());
            this.log(2, file, 0L, 0L);
            ++this.mods;
        }
        this.ss.cancelAction(entry.myPendingAction);
    }

    void log(int n, File file, long l, long l2) {
        block4: {
            try {
                this.logWrite(n, file, l, l2);
            }
            catch (IOException iOException) {
                try {
                    this.compress();
                    this.logWrite(n, file, l, l2);
                }
                catch (IOException iOException2) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                    LOG.warn((Object)("Cannot write to " + this.db + ", keeping expiration tables in memory."));
                }
            }
        }
    }

    void logWrite(int n, File file, long l, long l2) throws IOException {
        this.out.writeInt(n);
        this.out.writeUTF(file.getAbsolutePath().toString());
        this.out.writeLong(l);
        this.out.writeLong(l2);
        this.out.getFD().sync();
    }

    private void compress() throws IOException {
        IOException iOException4;
        DataInputStream dataInputStream = null;
        long l = System.currentTimeMillis();
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        if (this.tmpDb.exists()) {
            this.tmpDb.delete();
        }
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.db)));
            this.out = new RandomAccessFile(this.tmpDb, "rw");
            this.compressStreams(dataInputStream);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            IOException iOException32;
            Object var6_5 = null;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("Compressed " + this.db + " in " + (System.currentTimeMillis() - l) + " ms."));
            }
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException32) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException32) {
                    // empty catch block
                }
            }
            if (this.tmpDb.exists()) {
                if (this.db.exists()) {
                    this.db.delete();
                }
                this.tmpDb.renameTo(this.db);
            }
            this.out = new RandomAccessFile(this.db, "rw");
            this.out.seek(this.out.length());
            throw throwable;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Compressed " + this.db + " in " + (System.currentTimeMillis() - l) + " ms."));
        }
        if (dataInputStream != null) {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException4) {
                // empty catch block
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException4) {
                // empty catch block
            }
        }
        if (this.tmpDb.exists()) {
            if (this.db.exists()) {
                this.db.delete();
            }
            this.tmpDb.renameTo(this.db);
        }
        this.out = new RandomAccessFile(this.db, "rw");
        this.out.seek(this.out.length());
        this.removeUnknownFiles();
        this.mods = 0;
    }

    void compressStreams(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        try {
            while (true) {
                int n2 = dataInputStream.readInt();
                File file = new File(dataInputStream.readUTF());
                long l = dataInputStream.readLong();
                long l2 = dataInputStream.readLong();
                if (file.exists()) {
                    switch (n2) {
                        case 1: {
                            if (l <= System.currentTimeMillis()) break;
                            this.scheduleFileExpiration(file, l, l2);
                            break;
                        }
                        case 2: {
                            this.cancelFileExpiration(file);
                        }
                    }
                }
                ++n;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    void removeUnknownFiles() {
        Enumeration enumeration = this.docDirs.elements();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            this.removeUnknownFiles(file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeUnknownFiles(File file) {
        String[] stringArray = file.list();
        int n = 0;
        while (true) {
            block9: {
                if (stringArray == null || n >= stringArray.length) {
                    return;
                }
                File file2 = new File(file, stringArray[n]);
                if (!file2.isDirectory() && this.hash.get(file2.getAbsolutePath()) == null && file2.getName().indexOf("scheduler.db") == -1) {
                    Object var7_6;
                    try {
                        block8: {
                            try {
                                if (this.listener == null) break block8;
                                this.listener.expiredAndRemove(file2);
                            }
                            catch (Throwable throwable) {
                                if (LOG.isEnabledFor(Priority.DEBUG)) {
                                    LOG.debug((Object)"Throwable caught while dispatching expiration listener.", throwable);
                                }
                                var7_6 = null;
                                file2.delete();
                                break block9;
                            }
                        }
                        var7_6 = null;
                        file2.delete();
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        file2.delete();
                        throw throwable;
                    }
                }
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        SchedulerService schedulerService = new SchedulerService();
        File file = new File(stringArray[0]);
        Thread thread = new Thread(schedulerService);
        thread.start();
        FileExpirationService fileExpirationService = new FileExpirationService(schedulerService, file, null, null);
        fileExpirationService.addDocDir(new File("testdir/"));
        long l = System.currentTimeMillis() + 30000L;
        fileExpirationService.scheduleFileExpiration(new File("testdir/test1"), l, l);
        fileExpirationService.scheduleFileExpiration(new File("testdir/test2"), l, l);
        fileExpirationService.scheduleFileExpiration(new File("testdir/test3"), l, l);
        fileExpirationService.cancelFileExpiration(new File("testdir/test2"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ExpireAction
    implements SchedulerService.Action {
        Entry entry;

        ExpireAction(Entry entry) {
            this.entry = entry;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform(SchedulerService schedulerService) {
            try {
                block9: {
                    try {
                        if (FileExpirationService.this.listener == null) break block9;
                        FileExpirationService.this.listener.expiredAndRemove(this.entry.file);
                    }
                    catch (Throwable throwable) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Throwable caught while dispatching expiration listener.", throwable);
                        }
                        Object var4_3 = null;
                        FileExpirationService fileExpirationService3 = FileExpirationService.this;
                        synchronized (fileExpirationService3) {
                            this.entry.file.delete();
                            FileExpirationService.this.hash.remove(this.entry.file.getAbsolutePath());
                            return;
                        }
                    }
                }
                Object var4_2 = null;
                FileExpirationService fileExpirationService = FileExpirationService.this;
                synchronized (fileExpirationService) {
                    this.entry.file.delete();
                    FileExpirationService.this.hash.remove(this.entry.file.getAbsolutePath());
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                FileExpirationService fileExpirationService2 = FileExpirationService.this;
                synchronized (fileExpirationService2) {
                    this.entry.file.delete();
                    FileExpirationService.this.hash.remove(this.entry.file.getAbsolutePath());
                    throw throwable;
                }
            }
        }
    }

    class CleanupAction
    implements SchedulerService.Action {
        CleanupAction() {
        }

        public void perform(SchedulerService schedulerService) {
            block3: {
                try {
                    if (FileExpirationService.this.db.exists()) {
                        FileExpirationService.this.compress();
                    }
                }
                catch (IOException iOException) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block3;
                    LOG.debug((Object)"Compression of log stream failed.", (Throwable)iOException);
                }
            }
            FileExpirationService.this.pendingCompressAction = schedulerService.scheduleAction(this, 1800000L);
        }
    }

    class Entry {
        File file;
        SchedulerService.PendingAction myPendingAction;
        long timeInMyCache;
        long timeoutForOthers;

        Entry(File file, long l, long l2) {
            this.file = file;
            this.timeInMyCache = l;
            this.timeoutForOthers = l2;
        }
    }

    static interface ExpirationListener {
        public void expiredAndRemove(File var1);
    }
}

