/*
 * Decompiled with CFR 0.152.
 */
import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import net.jxta.codat.CodatID;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;

public final class IDTest
extends TestCase {
    public IDTest(String string) {
        super(string);
    }

    public void testID() {
        try {
            ID iD = ID.nullID;
            ID iD2 = ID.nullID;
            Assert.assertTrue((String)"comparison of two IDs failed", (boolean)iD.equals(iD2));
            ID iD3 = (ID)iD.clone();
            Assert.assertTrue((String)"comparison of cloned ID failed", (boolean)iD.equals(iD3));
            Assert.assertTrue((String)"zero hashcodereturned", (0 != iD.hashCode() ? 1 : 0) != 0);
            URL uRL = iD.getURL();
            String string = iD.toString();
            Assert.assertTrue((String)"comparison of ID string and string of URL was not the same", (boolean)string.equals(uRL.toString()));
            iD3 = IDFactory.fromURL(uRL);
            Assert.assertTrue((String)"result of conversion to URL and back to ID was not equal to original", (boolean)iD.equals(iD3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + exception.toString()));
        }
    }

    public void testCodatID() {
        try {
            CodatID codatID = IDFactory.newCodatID(IDFactory.newPeerGroupID());
            CodatID codatID2 = IDFactory.newCodatID(IDFactory.newPeerGroupID());
            PeerID peerID = IDFactory.newPeerID(IDFactory.newPeerGroupID());
            Assert.assertTrue((String)"comparison of a CodatID against itself failed", (boolean)codatID.equals(codatID));
            Assert.assertTrue((String)"comparison of two different CodatIDs should have failed", (!codatID.equals(codatID2) ? 1 : 0) != 0);
            CodatID codatID3 = (CodatID)codatID.clone();
            Assert.assertTrue((String)"comparison of cloned ID failed", (boolean)codatID.equals(codatID3));
            Assert.assertTrue((String)"comparison of different types should have failed", (!codatID.equals(peerID) ? 1 : 0) != 0);
            Assert.assertTrue((String)"comparison of different types should have failed", (!peerID.equals(codatID) ? 1 : 0) != 0);
            Assert.assertTrue((String)"zero hashcodereturned", (0 != codatID.hashCode() ? 1 : 0) != 0);
            URL uRL = codatID.getURL();
            String string = codatID.toString();
            Assert.assertTrue((String)"comparison of ID string and string of URL was not the same", (boolean)string.equals(uRL.toString()));
            codatID3 = (CodatID)IDFactory.fromURL(uRL);
            Assert.assertTrue((String)"result of conversion to URL and back to ID was not equal to original", (boolean)codatID.equals(codatID3));
            ID iD = codatID.getPeerGroupID();
            Assert.assertTrue((String)"clone of ID is not of same peergroup.", (boolean)codatID.getPeerGroupID().equals(codatID3.getPeerGroupID()));
            Assert.assertTrue((String)"dynamic CodatID did not test as such.", (!codatID.isStatic() ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + exception.toString()));
        }
    }

    public void testPeerGroupID() {
        try {
            PeerGroupID peerGroupID = IDFactory.newPeerGroupID();
            PeerGroupID peerGroupID2 = IDFactory.newPeerGroupID();
            PeerID peerID = IDFactory.newPeerID(IDFactory.newPeerGroupID());
            Assert.assertTrue((String)"comparison of a PeerGroupID against itself failed", (boolean)peerGroupID.equals(peerGroupID));
            Assert.assertTrue((String)"comparison against worldPeerGroup should have failed", (!peerGroupID.equals(PeerGroupID.worldPeerGroupID) ? 1 : 0) != 0);
            Assert.assertTrue((String)"comparison of two different PeerGroupIDs should have failed", (!peerGroupID.equals(peerGroupID2) ? 1 : 0) != 0);
            PeerGroupID peerGroupID3 = (PeerGroupID)peerGroupID.clone();
            Assert.assertTrue((String)"comparison of cloned ID failed", (boolean)peerGroupID.equals(peerGroupID3));
            Assert.assertTrue((String)"comparison of different types should have failed", (!peerGroupID.equals(peerID) ? 1 : 0) != 0);
            Assert.assertTrue((String)"comparison of different types should have failed", (!peerID.equals(peerGroupID) ? 1 : 0) != 0);
            Assert.assertTrue((String)"zero hashcodereturned", (0 != peerGroupID.hashCode() ? 1 : 0) != 0);
            Assert.assertTrue((String)"hashcode for world group should not have matched.", (PeerGroupID.worldPeerGroupID.hashCode() != peerGroupID.hashCode() ? 1 : 0) != 0);
            URL uRL = peerGroupID.getURL();
            String string = peerGroupID.toString();
            Assert.assertTrue((String)"comparison of ID string and string of URL was not the same", (boolean)string.equals(uRL.toString()));
            peerGroupID3 = (PeerGroupID)IDFactory.fromURL(uRL);
            Assert.assertTrue((String)"result of conversion to URL and back to ID was not equal to original", (boolean)peerGroupID.equals(peerGroupID3));
            Object object = peerGroupID.getUniqueValue();
            Object object2 = peerGroupID2.getUniqueValue();
            Assert.assertTrue((String)"comparison of UUIDs from an ID and a clone failed", (boolean)object.equals(peerGroupID3.getUniqueValue()));
            Assert.assertTrue((String)"comparison of UUIDs from an ID and a different ID should have failed.", (!object.equals(peerGroupID2.getUniqueValue()) ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + exception.toString()));
        }
    }

    public void testPeerID() {
        try {
            PeerID peerID = IDFactory.newPeerID(IDFactory.newPeerGroupID());
            PeerID peerID2 = IDFactory.newPeerID(IDFactory.newPeerGroupID());
            PeerGroupID peerGroupID = IDFactory.newPeerGroupID();
            Assert.assertTrue((String)"comparison of a PeerID against itself failed", (boolean)peerID.equals(peerID));
            Assert.assertTrue((String)"comparison of two different PeerIDs should have failed", (!peerID.equals(peerID2) ? 1 : 0) != 0);
            PeerID peerID3 = (PeerID)peerID.clone();
            Assert.assertTrue((String)"comparison of cloned ID failed", (boolean)peerID.equals(peerID3));
            Assert.assertTrue((String)"comparison of different types should have failed", (!peerID.equals(peerGroupID) ? 1 : 0) != 0);
            Assert.assertTrue((String)"comparison of different types should have failed", (!peerGroupID.equals(peerID) ? 1 : 0) != 0);
            Assert.assertTrue((String)"zero hashcodereturned", (0 != peerID.hashCode() ? 1 : 0) != 0);
            URL uRL = peerID.getURL();
            String string = peerID.toString();
            Assert.assertTrue((String)"comparison of ID string and string of URL was not the same", (boolean)string.equals(uRL.toString()));
            peerID3 = (PeerID)IDFactory.fromURL(uRL);
            Assert.assertTrue((String)"result of conversion to URL and back to ID was not equal to original", (boolean)peerID.equals(peerID3));
            Assert.assertTrue((String)"clone of ID is not of same peergroup.", (boolean)peerID.getPeerGroupID().equals(peerID3.getPeerGroupID()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + exception.toString()));
        }
    }

    public void testPipeID() {
        try {
            PipeID pipeID = IDFactory.newPipeID(IDFactory.newPeerGroupID());
            PipeID pipeID2 = IDFactory.newPipeID(IDFactory.newPeerGroupID());
            PeerGroupID peerGroupID = IDFactory.newPeerGroupID();
            Assert.assertTrue((String)"comparison of a PipeID against itself failed", (boolean)pipeID.equals(pipeID));
            Assert.assertTrue((String)"comparison of two different PipeIDs should have failed", (!pipeID.equals(pipeID2) ? 1 : 0) != 0);
            PipeID pipeID3 = (PipeID)pipeID.clone();
            Assert.assertTrue((String)"comparison of cloned ID failed", (boolean)pipeID.equals(pipeID3));
            Assert.assertTrue((String)"comparison of different types should have failed", (!pipeID.equals(peerGroupID) ? 1 : 0) != 0);
            Assert.assertTrue((String)"comparison of different types should have failed", (!peerGroupID.equals(pipeID) ? 1 : 0) != 0);
            Assert.assertTrue((String)"zero hashcode returned", (0 != pipeID.hashCode() ? 1 : 0) != 0);
            URL uRL = pipeID.getURL();
            String string = pipeID.toString();
            Assert.assertTrue((String)"comparison of ID string and string of URL was not the same", (boolean)string.equals(uRL.toString()));
            pipeID3 = (PipeID)IDFactory.fromURL(uRL);
            Assert.assertTrue((String)"result of conversion to URL and back to ID was not equal to original", (boolean)pipeID.equals(pipeID3));
            Assert.assertTrue((String)"clone of ID is not of same peergroup.", (boolean)pipeID.getPeerGroupID().equals(pipeID3.getPeerGroupID()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + exception.toString()));
        }
    }

    public void testIDFactory() {
        try {
            URL uRL = new URL("urn:jxta:idform-1234567890");
            URL uRL2 = new URL("URN:jxta:idform-1234567890");
            URL uRL3 = new URL("urn:JXTA:idform-1234567890");
            URL uRL4 = new URL("urn:JXTA:idform-123456789%30");
            URL uRL5 = new URL("urn:JXTA:IDForm-1234567890");
            URL uRL6 = new URL("urn:jxta:idform2-ABCDEFG");
            URL uRL7 = new URL("urn:jxta:idform3-31:08:66:42:67:::91:24::73");
            ID iD = IDFactory.fromURL(uRL);
            ID iD2 = IDFactory.fromURL(uRL2);
            ID iD3 = IDFactory.fromURL(uRL3);
            ID iD4 = IDFactory.fromURL(uRL4);
            ID iD5 = IDFactory.fromURL(uRL5);
            ID iD6 = IDFactory.fromURL(uRL6);
            ID iD7 = IDFactory.fromURL(uRL7);
            Assert.assertEquals((Object)iD, (Object)iD2);
            Assert.assertEquals((Object)iD2, (Object)iD3);
            Assert.assertEquals((Object)iD, (Object)iD3);
            Assert.assertEquals((Object)iD, (Object)iD4);
            Assert.assertTrue((!iD.equals(iD5) ? 1 : 0) != 0);
            Assert.assertTrue((!iD.equals(iD6) ? 1 : 0) != 0);
            Assert.assertTrue((!iD.equals(iD7) ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + exception.toString()));
        }
    }

    public static void main(String[] stringArray) {
        new TestRunner();
        TestRunner.main((String[])new String[]{"IDTest"});
    }
}

