/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.security.ProviderException;
import java.util.Enumeration;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.impl.document.LiteXMLDocument;

public final class DocTest
extends TestCase {
    public DocTest(String string) {
        super(string);
    }

    private void _test(MimeMediaType mimeMediaType) {
        try {
            StructuredTextDocument structuredTextDocument = null;
            try {
                structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, "Test");
            }
            catch (Throwable throwable) {
                Assert.fail((String)("exception thrown during construction!" + throwable.toString()));
            }
            Assert.assertTrue((String)("could not construct object for type : " + mimeMediaType), (structuredTextDocument != null ? 1 : 0) != 0);
            String string = structuredTextDocument.getName();
            Assert.assertTrue((String)"returned doctype does not equal type document was created with!", (boolean)"Test".equals(string));
            Assert.assertTrue((String)"returned doc name does not equal name of document element", (boolean)structuredTextDocument.getName().equals(string));
            TextElement textElement = structuredTextDocument.createElement("element");
            structuredTextDocument.appendChild(textElement);
            try {
                Element element = (Element)structuredTextDocument.getChildren().nextElement();
                Assert.assertTrue((String)"added a single element, but something else was returned", (boolean)textElement.equals(element));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Assert.fail((String)"added a single element, but it was not returned");
            }
            TextElement textElement2 = structuredTextDocument.createElement("element2", "value&<!");
            textElement.appendChild(textElement2);
            String string2 = textElement2.getName();
            Assert.assertTrue((String)"name of element was not correct after creation", (boolean)"element2".equals(string2));
            String string3 = textElement2.getTextValue();
            Assert.assertTrue((String)("value of element was not correct after creation. was '" + string3 + "' should be '" + "value&<!" + "'"), (boolean)"value&<!".equals(string3));
            textElement2 = structuredTextDocument.createElement("element3", "value&<!");
            textElement.appendChild(textElement2);
            textElement2 = structuredTextDocument.createElement("element4", "1");
            textElement.appendChild(textElement2);
            string3 = textElement2.getTextValue();
            Assert.assertTrue((String)"value of element was not correct after creation (length 1)", (boolean)"1".equals(string3));
            int n = 0;
            Enumeration enumeration = structuredTextDocument.getChildren();
            while (enumeration.hasMoreElements()) {
                ++n;
                enumeration.nextElement();
            }
            Assert.assertTrue((String)"Doc didnt have one child", (1 == n ? 1 : 0) != 0);
            n = 0;
            Enumeration enumeration2 = structuredTextDocument.getChildren("element");
            while (enumeration2.hasMoreElements()) {
                ++n;
                enumeration2.nextElement();
            }
            Assert.assertTrue((String)"Doc didnt have one child named 'element'", (1 == n ? 1 : 0) != 0);
            n = 0;
            Enumeration enumeration3 = structuredTextDocument.getChildren("bogus");
            while (enumeration3.hasMoreElements()) {
                ++n;
                enumeration3.nextElement();
            }
            Assert.assertTrue((String)" Doc shouldnt have had a child named 'bogus'", (0 == n ? 1 : 0) != 0);
            n = 0;
            Enumeration enumeration4 = textElement.getChildren();
            while (enumeration4.hasMoreElements()) {
                ++n;
                enumeration4.nextElement();
            }
            Assert.assertTrue((String)"element didnt have expected number of children", (3 == n ? 1 : 0) != 0);
            n = 0;
            Enumeration enumeration5 = textElement.getChildren("element2");
            while (enumeration5.hasMoreElements()) {
                ++n;
                enumeration5.nextElement();
            }
            Assert.assertTrue((String)"element didnt have expected number of children named 'element2'", (1 == n ? 1 : 0) != 0);
            TextElement textElement3 = structuredTextDocument.createElement("element2", "value&<!");
            textElement2.appendChild((Element)textElement3);
            textElement3 = structuredTextDocument.createElement("element2");
            textElement2.appendChild((Element)textElement3);
            n = 0;
            Enumeration enumeration6 = textElement2.getChildren("element2");
            while (enumeration6.hasMoreElements()) {
                ++n;
                enumeration6.nextElement();
            }
            Assert.assertTrue((String)"element didnt have expected number of children named 'element2'", (2 == n ? 1 : 0) != 0);
            if (textElement instanceof Attributable) {
                this._testAttributes((Attributable)((Object)textElement));
                this._testAttributes((Attributable)((Object)textElement3));
            }
            StructuredDocument structuredDocument = null;
            try {
                structuredDocument = StructuredDocumentFactory.newStructuredDocument(structuredTextDocument.getMimeType(), structuredTextDocument.getStream());
            }
            catch (ProviderException providerException) {
            }
            catch (Throwable throwable) {
                Assert.fail((String)("Exception thrown during construction!" + throwable.toString()));
            }
            StringWriter stringWriter = new StringWriter();
            structuredTextDocument.sendToWriter(stringWriter);
            String string4 = ((Object)stringWriter).toString().trim();
            textElement3 = structuredTextDocument.createElement("element2", string4);
            textElement2.appendChild((Element)textElement3);
            String string5 = (String)textElement3.getValue();
            Assert.assertTrue((String)"Could not faithfully store stream representation of doc in doc. (lengths dont match)", (string4.length() == string5.length() ? 1 : 0) != 0);
            int n2 = 0;
            while (n2 < string4.length()) {
                Assert.assertTrue((String)("Could not faithfully store stream representation of doc in doc. (failed at index: " + n2 + ")"), (string4.charAt(n2) == string5.charAt(n2) ? 1 : 0) != 0);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assert.fail((String)("caught an unexpected exception - " + throwable.toString()));
        }
    }

    public void _testAttributes(Attributable attributable) {
        try {
            Enumeration enumeration = attributable.getAttributes();
            Assert.assertTrue((String)"Element already had attributes!", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
            Assert.assertTrue((String)"New attribute returned previous value!", (null == attributable.addAttribute("attrName", "attrValue") ? 1 : 0) != 0);
            String string = attributable.addAttribute(new Attribute("attrName", "attrValue"));
            Assert.assertTrue((String)"New attribute didnt return previous value!", (null != string && string.equals("attrValue") ? 1 : 0) != 0);
            Attribute attribute = attributable.getAttribute("attrName");
            Assert.assertTrue((String)"Could not get attribute back!", (null != attribute ? 1 : 0) != 0);
            Assert.assertTrue((String)"value of attribute was not correct", (boolean)attribute.getValue().equals("attrValue"));
            attribute = attributable.getAttribute("bogusName");
            Assert.assertTrue((String)"Should not have been able to get an unknown attribute name", (null == attribute ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assert.fail((String)("Caught an unexpected exception - " + throwable.toString()));
        }
    }

    public void _testAttributesSolo(MimeMediaType mimeMediaType) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            LiteXMLDocument liteXMLDocument = new LiteXMLDocument(mimeMediaType, "Message");
            liteXMLDocument.addAttribute("version", "123");
            liteXMLDocument.sendToStream(byteArrayOutputStream);
            String string = liteXMLDocument.addAttribute("version", "1xx23");
            Assert.assertTrue((String)"updating attribute gave wrong result", (boolean)"123".equals(string));
            liteXMLDocument.sendToStream(byteArrayOutputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assert.fail((String)("Caught an unexpected exception - " + throwable.toString()));
        }
    }

    public static void copyElements(StructuredDocument structuredDocument, Element element, Element element2) {
        Object object = element2.getKey();
        Object object2 = element2.getValue();
        Element element3 = structuredDocument.createElement(object, object2);
        element.appendChild(element3);
        Enumeration enumeration = element2.getChildren();
        while (enumeration.hasMoreElements()) {
            Element element4 = (Element)enumeration.nextElement();
            DocTest.copyElements(structuredDocument, element3, element4);
        }
    }

    public void testXMLStructuredDoc() {
        this._test(new MimeMediaType("Text/Xml"));
        this._testAttributesSolo(new MimeMediaType("Text/Xml"));
    }

    public void testPlainTextDoc() {
        this._test(new MimeMediaType("Text/Plain"));
        this._testAttributesSolo(new MimeMediaType("Text/Plain"));
    }

    public void testExtensionMapping() {
        MimeMediaType mimeMediaType = new MimeMediaType("Text/Xml");
        String string = "xml";
        String string2 = StructuredDocumentFactory.getFileExtensionForMimeType(mimeMediaType);
        MimeMediaType mimeMediaType2 = StructuredDocumentFactory.getMimeTypeForFileExtension(string2);
        Assert.assertTrue((String)"mime type was not the same after reflex mapping", (boolean)mimeMediaType.equals(mimeMediaType2));
        Assert.assertTrue((String)"extension was not the same after reflex mapping", (boolean)string.equals(string2));
    }

    public static void main(String[] stringArray) {
        new TestRunner();
        TestRunner.main((String[])new String[]{"DocTest"});
    }
}

