/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.rsa;

import cryptix.provider.rsa.BaseRSAPublicKey;
import cryptix.util.core.BI;
import cryptix.util.core.Debug;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigInteger;

public class RawRSAPublicKey
extends BaseRSAPublicKey {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("RSA", "RawRSAPublicKey");
    private static final PrintWriter err = Debug.getOutput();
    private static final BigInteger F4 = BigInteger.valueOf(65537L);

    private static void debug(String string) {
        err.println("RawRSAPublicKey: " + string);
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        try {
            BI.toStream(this.getExponent(), bufferedOutputStream);
            BI.toStream(this.getModulus(), bufferedOutputStream);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public RawRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.setRsaParams(bigInteger, bigInteger2);
    }

    public RawRSAPublicKey(BigInteger bigInteger) {
        this(bigInteger, F4);
    }

    public RawRSAPublicKey(InputStream inputStream) throws IOException {
        BigInteger bigInteger = BI.fromStream(inputStream);
        BigInteger bigInteger2 = BI.fromStream(inputStream);
        this.setRsaParams(bigInteger2, bigInteger);
    }
}

