/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

import org.apache.tomcat.util.buf.MessageBytes;

public class MultiMap {
    protected Field[] fields;
    protected int count;
    static final int NEED_NEXT = -2;
    static final int LAST = -1;

    public MultiMap(int initial_size) {
        this.fields = new Field[initial_size];
    }

    public int addField() {
        int len = this.fields.length;
        int pos = this.count;
        if (this.count >= len) {
            Field[] tmp = new Field[pos * 2];
            System.arraycopy(this.fields, 0, tmp, 0, len);
            this.fields = tmp;
        }
        if (this.fields[pos] == null) {
            this.fields[pos] = new Field();
        }
        ++this.count;
        return pos;
    }

    public int find(String name, int starting) {
        int i = starting;
        while (i < this.count) {
            if (this.fields[i].name.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findFirst(String name) {
        int i = 0;
        while (i < this.count) {
            if (this.fields[i].name.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findIgnoreCase(String name, int starting) {
        int i = starting;
        while (i < this.count) {
            if (this.fields[i].name.equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findNext(int startPos) {
        int next = this.fields[startPos].nextPos;
        if (next != -2) {
            return next;
        }
        MessageBytes name = this.fields[startPos].name;
        int i = startPos;
        while (i < this.count) {
            if (this.fields[i].name.equals(name)) {
                this.fields[startPos].nextPos = i;
                return i;
            }
            ++i;
        }
        this.fields[startPos].nextPos = -1;
        return -1;
    }

    public MessageBytes get(String name) {
        int i = 0;
        while (i < this.count) {
            if (this.fields[i].name.equals(name)) {
                return this.fields[i].value;
            }
            ++i;
        }
        return null;
    }

    public MessageBytes getName(int n) {
        return this.fields[n].name;
    }

    public MessageBytes getValue(int n) {
        return this.fields[n].value;
    }

    public void recycle() {
        int i = 0;
        while (i < this.count) {
            this.fields[i].recycle();
            ++i;
        }
        this.count = 0;
    }

    public void remove(int i) {
        Field mh = this.fields[i];
        mh.recycle();
        this.fields[i] = this.fields[this.count - 1];
        this.fields[this.count - 1] = mh;
        --this.count;
    }

    public int size() {
        return this.count;
    }

    final class Field {
        MessageBytes name;
        MessageBytes value;
        int nextPos = -2;
        int hash;
        Field nextSameHash;

        Field() {
        }

        void recycle() {
            this.name.recycle();
            this.value.recycle();
            this.nextPos = -2;
        }
    }
}

