/*
 * Decompiled with CFR 0.152.
 */
package tyrex.tm;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.transaction.xa.Xid;
import tyrex.util.Logger;
import tyrex.util.Messages;

public final class XidImpl
implements Xid,
Serializable {
    private byte[] _global;
    private byte[] _branch;
    private static long _xidCounter;
    private static byte[] _machineId;
    public static final int XID_FORMAT = 14745550;
    public static final int GLOBAL_XID_LENGTH = 12;
    public static final int MACHINE_ID_LENGTH = 4;

    static {
        int n;
        long l;
        try {
            byte[] byArray = InetAddress.getLocalHost().getAddress();
            l = 0L;
            n = 0;
            while (n < byArray.length) {
                l = (l << 8) + (long)byArray[n];
                if (byArray[n] < 0) {
                    l += 256L;
                }
                ++n;
            }
        }
        catch (UnknownHostException unknownHostException) {
            l = -1L;
            Logger.getSystemLogger().println(Messages.message("tyrex.server.failedFindHostIP"));
        }
        _machineId = new byte[4];
        n = 0;
        while (n < 4) {
            XidImpl._machineId[n] = (byte)l;
            l >>= 8;
            ++n;
        }
    }

    public XidImpl() {
        this._branch = this.getUniqueId();
        this._global = this._branch;
    }

    public XidImpl(String string) {
        this.unmarshalXID(string);
    }

    public Object clone() {
        XidImpl xidImpl = new XidImpl();
        xidImpl._branch = this._branch;
        xidImpl._global = this._global;
        return xidImpl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XidImpl)) {
            return false;
        }
        XidImpl xidImpl = (XidImpl)object;
        int n = 0;
        while (n < 12) {
            if (this._branch[n] != xidImpl._branch[n]) {
                return false;
            }
            ++n;
        }
        if (this._global != xidImpl._global) {
            n = 0;
            while (n < 12) {
                if (this._global[n] != xidImpl._global[n]) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    long fromHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0L;
    }

    public byte[] getBranchQualifier() {
        return this._branch;
    }

    public int getFormatId() {
        return 14745550;
    }

    public byte[] getGlobalTransactionId() {
        return this._global;
    }

    private byte[] getUniqueId() {
        long l = (System.currentTimeMillis() << 12) + ++_xidCounter % 4095L;
        byte[] byArray = new byte[12];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)l;
            l >>= 8;
            ++n;
        }
        n = 0;
        while (n < 4) {
            byArray[8 + n] = _machineId[n];
            ++n;
        }
        return byArray;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 8;
        while (n2-- > 0) {
            n = (n << 4) + this._branch[n2];
        }
        return n;
    }

    public static boolean isLocal(byte[] byArray) {
        if (byArray.length != 12) {
            return false;
        }
        int n = 0;
        while (n < 4) {
            if (_machineId[n] != byArray[8 + n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public XidImpl newBranch() {
        XidImpl xidImpl = new XidImpl();
        xidImpl._global = this._global;
        xidImpl._branch = this.getUniqueId();
        return xidImpl;
    }

    static char toHex(long l) {
        if ((l &= 0xFL) < 10L) {
            return (char)(48L + l);
        }
        return (char)(55L + l);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(58);
        int n = 8;
        while (n-- > 0) {
            stringBuffer.append(XidImpl.toHex(14745550 >> 4 * n));
        }
        stringBuffer.append(':');
        n = 12;
        while (n-- > 0) {
            stringBuffer.append(XidImpl.toHex(this._global[n] >> 4));
            stringBuffer.append(XidImpl.toHex(this._global[n]));
        }
        stringBuffer.append(':');
        n = 12;
        while (n-- > 0) {
            stringBuffer.append(XidImpl.toHex(this._branch[n] >> 4));
            stringBuffer.append(XidImpl.toHex(this._branch[n]));
        }
        return stringBuffer.toString();
    }

    static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 12;
        while (n-- > 0) {
            stringBuffer.append(XidImpl.toHex(byArray[n] >> 4));
            stringBuffer.append(XidImpl.toHex(byArray[n]));
        }
        return stringBuffer.toString();
    }

    private void unmarshalXID(String string) {
        long l = 0L;
        int n = 0;
        while (n < 8) {
            l = (l << 4) + this.fromHex(string.charAt(n));
            ++n;
        }
        if (l == 14745550L) {
            this._global = new byte[12];
            int n2 = 0;
            while (n2 < 12) {
                this._global[n2] = (byte)this.fromHex(string.charAt(n2 + 9));
                ++n2;
            }
            this._branch = new byte[12];
            int n3 = 0;
            while (n3 < 12) {
                this._branch[n3] = (byte)this.fromHex(string.charAt(n3 + 10 + 12));
                ++n3;
            }
        }
    }
}

