/*
 * Decompiled with CFR 0.152.
 */
package talon.implementations;

import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.xml.DOMConfigurator;
import talon.Assert;
import talon.BaseComponent;
import talon.Component;
import talon.ComponentHandle;
import talon.TalonException;
import talon.components.Logger;

public class Log4JLogger
extends BaseComponent
implements Component,
Logger {
    private Category root = Category.getRoot();
    static /* synthetic */ Class class$talon$implementations$Log4JLogger;

    public Log4JLogger() {
        String configuration = System.getProperty("log4j.configuration");
        Assert.assert(configuration, "Configuration not specified.  Need to set the system param: 'log4j.configuration'");
        if (configuration.startsWith("file:/")) {
            DOMConfigurator.configure((String)configuration);
        } else {
            DOMConfigurator.configure((URL)Loader.getResource((String)configuration, (Class)(class$talon$implementations$Log4JLogger == null ? (class$talon$implementations$Log4JLogger = Log4JLogger.class$("talon.implementations.Log4JLogger")) : class$talon$implementations$Log4JLogger)));
        }
    }

    public Log4JLogger(Category category) {
        this.root = category;
    }

    public Log4JLogger(ComponentHandle handle, String project) {
        this();
        this.setComponentHandle(handle);
        this.root = Category.getInstance((String)project);
        this.debug("The following appenders were found...", this);
        Enumeration cats = this.root.getAllAppenders();
        while (cats.hasMoreElements()) {
            Appender next = (Appender)cats.nextElement();
            this.debug("Log4J using the following appender: " + next + this.getClass().toString(), this);
        }
    }

    public void init() throws TalonException {
    }

    public void message(Object message) {
        this.root.info(message);
    }

    public void message(Object message, Object category) {
        Category.getInstance(category.getClass()).info(message);
    }

    public void debug(Object message) {
        this.root.debug(message);
    }

    public void debug(Object message, Object category) {
        Category.getInstance(category.getClass()).debug(message);
    }

    public void warn(Object message) {
        this.root.warn(message);
    }

    public void warn(Object message, Object category) {
        Category.getInstance(category.getClass()).warn(message);
    }

    public void error(Object message) {
        this.root.error(message);
    }

    public void error(Object message, Throwable throwable) {
        this.root.error(message, throwable);
    }

    public void error(Object message, Object category, Throwable t) {
        Category.getInstance(category.getClass()).error(message, t);
    }

    public Logger getLogger(Class category) {
        Log4JLogger logger = new Log4JLogger(Category.getInstance((Class)category));
        logger.setComponentHandle(this.getComponentHandle());
        return logger;
    }

    public Logger getLogger(Object category) {
        return this.getLogger(category.getClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

