<?xml version="1.0"?> 

<!--

$Id: home.xsl,v 1.1 2002/02/25 08:17:21 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:bootstrap="http://schemas.openprivacy.org/reptile/bootstrap"
                xmlns:search="http://schemas.openprivacy.org/reptile/search"
                xmlns:dc="http://purl.org/metadata/dublin_core#"
                xmlns:xs="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:subscription-layout-extension="xalan://org.openprivacy.reptile.extensions.om.SubscriptionLayoutExtension"
                extension-element-prefixes="subscription-layout-extension"
                version="1.0">

    <xsl:output indent="yes" 
                encoding="ISO-8859-1"/>

    <xsl:template match="/bootstrap:bootstrap">

        <layout:layout>
        
            <layout:layer-index default="Unread Articles">

                <xsl:value-of select="subscription-layout-extension:layers()"
                              disable-output-escaping="yes"/>
                
                
                <layout:layer numColumns="1" name="Unread Articles"/>
                <layout:layer numColumns="1" name="Newest Articles"/>
                <layout:layer numColumns="1" name="Recent Articles"/>
                
            </layout:layer-index>

            <xsl:value-of select="subscription-layout-extension:subscriptions()"
                          disable-output-escaping="yes"/>

            <!-- home layers -->
            
            <layout:content contentType="http://schemas.openprivacy.org/reptile/stylesheet-sequence"
                            location="urn:search-request/newest-articles">

                <layout:position layer="Newest Articles" column="left"/>

            </layout:content>

            <layout:content contentType="http://schemas.openprivacy.org/reptile/stylesheet-sequence"
                            location="urn:search-request/recent-articles">

                <layout:position layer="Recent Articles" column="left"/>

            </layout:content>

            <layout:content contentType="http://schemas.openprivacy.org/reptile/stylesheet-sequence"
                            location="urn:search-request/unread-articles">

                <layout:position layer="Unread Articles" column="left"/>

            </layout:content>

            
        </layout:layout>

    </xsl:template>
    
</xsl:stylesheet>

