<?xml version="1.0"?> 

<!--

$Id: mozilla-tasks.xsl,v 1.13 2002/02/22 09:17:14 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                xmlns:jvm-settings="http://schemas.openprivacy.org/reptile/settings/jvm"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:tasks="http://schemas.openprivacy.org/reptile/settings/jvm/tasks"
                xmlns:timestamp="xalan://org.openprivacy.reptile.extensions.TimeStamp"
                extension-element-prefixes="timestamp"
                exclude-result-prefixes="timestamp"
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>                

    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.sequence.name" select="'urn:settings'"/>

    <xsl:param name="reptile.layer" select="''"/>

    <!-- output html here because this is out last step -->
    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:template match="/tasks:tasks">

         <control:content>

             <dc:title>Running (background) Tasks</dc:title>
    
             <control:body>

                 <xsl:apply-templates/>

             </control:body>

         </control:content>

    </xsl:template>

    <xsl:template match="tasks:task">

        <form action="{$reptile.home.location}">

        <logo-producer:bullet/>

        <b>Task identifier: </b>
        <xsl:value-of select="@identifier"/>

        <blockquote>

        <b>Last ran: </b> <xsl:value-of select="timestamp:get( @lastRan )"/>
        <br/>

        <b>Classname: </b> <xsl:value-of select="@classname"/>
        <br/>

        <b>Interval: </b> <timestamp:interval difference="{@interval}"/>
        <br/>

        <b>State: </b> <xsl:value-of select="@state"/>
        <br/>

        <b>Type: </b> <xsl:value-of select="@type"/>
        <br/>

        <b>Last message: </b> 
        <p>
        <xsl:value-of select="@lastMessage"/>
        </p>


        </blockquote>

        <input type="hidden" name="task_id" value="{@identifier}"/>

        <input type="hidden" name="reptile.action" value="RunTask"/>

        <input type="hidden" name="reptile.action.next.sequence" value="{$reptile.sequence.name}"/>

        <input type="hidden" name="reptile.action.next.layer" value="{$reptile.layer}"/>

        </form>

        <hr/>

    </xsl:template>

</xsl:stylesheet>

