/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.DateTool;

public final class MessageBytes
implements Cloneable,
Serializable {
    private int type = 0;
    public static final int T_NULL = 0;
    public static final int T_STR = 1;
    public static final int T_BYTES = 2;
    public static final int T_CHARS = 3;
    private int hashCode = 0;
    private boolean hasHashCode = false;
    private boolean caseSensitive = true;
    ByteChunk byteC = new ByteChunk();
    CharChunk charC = new CharChunk();
    private String strValue;
    private boolean hasStrValue = false;
    private int intValue;
    private boolean hasIntValue = false;
    private Date dateValue;
    private boolean hasDateValue = false;
    private static MessageBytesFactory factory = new MessageBytesFactory();

    public void duplicate(MessageBytes src) throws IOException {
        switch (src.getType()) {
            case 2: {
                this.type = 2;
                ByteChunk bc = src.getByteChunk();
                this.byteC.allocate(bc.getLength(), -1);
                this.byteC.append(bc);
                break;
            }
            case 3: {
                this.type = 3;
                CharChunk cc = src.getCharChunk();
                this.charC.allocate(cc.getLength(), -1);
                this.charC.append(cc);
                break;
            }
            case 1: {
                this.type = 1;
                String sc = src.getString();
                this.setString(sc);
                break;
            }
        }
    }

    public boolean equals(String s) {
        if (!this.caseSensitive) {
            return this.equalsIgnoreCase(s);
        }
        switch (this.type) {
            case 1: {
                if (this.strValue == null && s != null) {
                    return false;
                }
                return this.strValue.equals(s);
            }
            case 3: {
                return this.charC.equals(s);
            }
            case 2: {
                return this.byteC.equals(s);
            }
        }
        return false;
    }

    public boolean equals(MessageBytes mb) {
        switch (this.type) {
            case 1: {
                return mb.equals(this.strValue);
            }
        }
        if (mb.type != 3 && mb.type != 2) {
            return this.equals(mb.toString());
        }
        if (mb.type == 3 && this.type == 3) {
            return this.charC.equals(mb.charC);
        }
        if (mb.type == 2 && this.type == 2) {
            return this.byteC.equals(mb.byteC);
        }
        if (mb.type == 3 && this.type == 2) {
            return this.byteC.equals(mb.charC);
        }
        if (mb.type == 2 && this.type == 3) {
            return mb.byteC.equals(this.charC);
        }
        return true;
    }

    public boolean equalsIgnoreCase(String s) {
        switch (this.type) {
            case 1: {
                if (this.strValue == null && s != null) {
                    return false;
                }
                return this.strValue.equalsIgnoreCase(s);
            }
            case 3: {
                return this.charC.equalsIgnoreCase(s);
            }
            case 2: {
                return this.byteC.equalsIgnoreCase(s);
            }
        }
        return false;
    }

    public ByteChunk getByteChunk() {
        return this.byteC;
    }

    public CharChunk getCharChunk() {
        return this.charC;
    }

    public MessageBytes getClone() {
        try {
            return (MessageBytes)this.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getInt() {
        if (this.hasIntValue) {
            return this.intValue;
        }
        switch (this.type) {
            case 2: {
                this.intValue = this.byteC.getInt();
                break;
            }
            default: {
                this.intValue = Integer.parseInt(this.toString());
            }
        }
        this.hasIntValue = true;
        return this.intValue;
    }

    public int getLength() {
        if (this.type == 2) {
            return this.byteC.getLength();
        }
        if (this.type == 3) {
            return this.charC.getLength();
        }
        if (this.type == 1) {
            return this.strValue.length();
        }
        this.toString();
        if (this.strValue == null) {
            return 0;
        }
        return this.strValue.length();
    }

    public String getString() {
        return this.strValue;
    }

    public long getTime() {
        if (this.hasDateValue) {
            if (this.dateValue == null) {
                return -1L;
            }
            return this.dateValue.getTime();
        }
        long l = DateTool.parseDate(this);
        if (this.dateValue == null) {
            this.dateValue = new Date(l);
        } else {
            this.dateValue.setTime(l);
        }
        this.hasDateValue = true;
        return l;
    }

    public int getType() {
        return this.type;
    }

    private int hash() {
        int code = 0;
        switch (this.type) {
            case 1: {
                int i = 0;
                while (i < this.strValue.length()) {
                    code = code * 37 + this.strValue.charAt(i);
                    ++i;
                }
                return code;
            }
            case 3: {
                return this.charC.hash();
            }
            case 2: {
                return this.byteC.hash();
            }
        }
        return 0;
    }

    public int hashCode() {
        if (this.hasHashCode) {
            return this.hashCode;
        }
        int code = 0;
        code = this.caseSensitive ? this.hash() : this.hashIgnoreCase();
        this.hashCode = code;
        this.hasHashCode = true;
        return code;
    }

    private int hashIgnoreCase() {
        int code = 0;
        switch (this.type) {
            case 1: {
                int i = 0;
                while (i < this.strValue.length()) {
                    code = code * 37 + Ascii.toLower(this.strValue.charAt(i));
                    ++i;
                }
                return code;
            }
            case 3: {
                return this.charC.hashIgnoreCase();
            }
            case 2: {
                return this.byteC.hashIgnoreCase();
            }
        }
        return 0;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public int indexOf(char c, int starting) {
        switch (this.type) {
            case 1: {
                return this.strValue.indexOf(c, starting);
            }
            case 3: {
                return this.charC.indexOf(c, starting);
            }
            case 2: {
                return this.byteC.indexOf(c, starting);
            }
        }
        return -1;
    }

    public int indexOf(String s) {
        return this.indexOf(s, 0);
    }

    public int indexOf(String s, int starting) {
        this.toString();
        return this.strValue.indexOf(s, starting);
    }

    public int indexOfIgnoreCase(String s, int starting) {
        this.toString();
        String upper = this.strValue.toUpperCase();
        String sU = s.toUpperCase();
        return upper.indexOf(sU, starting);
    }

    public boolean isNull() {
        return this.byteC.isNull() && this.charC.isNull() && !this.hasStrValue;
    }

    public static MessageBytes newInstance() {
        return factory.newInstance();
    }

    public void recycle() {
        this.type = 0;
        this.byteC.recycle();
        this.charC.recycle();
        this.strValue = null;
        this.caseSensitive = true;
        this.hasStrValue = false;
        this.hasHashCode = false;
        this.hasIntValue = false;
        this.hasDateValue = false;
    }

    public void resetStringValue() {
        if (this.type != 1) {
            this.hasStrValue = false;
            this.strValue = null;
        }
    }

    public void setBytes(byte[] b, int off, int len) {
        this.recycle();
        this.byteC.setBytes(b, off, len);
        this.type = 2;
    }

    public void setCaseSenitive(boolean b) {
        this.caseSensitive = b;
    }

    public void setChars(char[] c, int off, int len) {
        this.recycle();
        this.charC.setChars(c, off, len);
        this.type = 3;
    }

    public void setEncoding(String enc) {
        if (!this.byteC.isNull()) {
            this.charC.recycle();
            this.hasStrValue = false;
        }
        this.byteC.setEncoding(enc);
    }

    public static void setFactory(MessageBytesFactory mbf) {
        factory = mbf;
    }

    public void setInt(int i) {
        this.recycle();
        this.strValue = String.valueOf(i);
        this.intValue = i;
        this.hasIntValue = true;
        this.hasStrValue = true;
        this.type = 1;
    }

    public void setString(String s) {
        this.recycle();
        if (s == null) {
            return;
        }
        this.strValue = s;
        this.hasStrValue = true;
        this.type = 1;
    }

    public void setTime(long t) {
        this.setTime(t, null);
    }

    public void setTime(long t, DateFormat df) {
        this.recycle();
        if (this.dateValue == null) {
            this.dateValue = new Date(t);
        } else {
            this.dateValue.setTime(t);
        }
        this.strValue = df == null ? DateTool.format1123(this.dateValue) : DateTool.format1123(this.dateValue, df);
        this.hasStrValue = true;
        this.hasDateValue = true;
        this.type = 1;
    }

    public boolean startsWith(String s) {
        switch (this.type) {
            case 1: {
                return this.strValue.startsWith(s);
            }
            case 3: {
                return this.charC.startsWith(s);
            }
            case 2: {
                return this.byteC.startsWith(s);
            }
        }
        return false;
    }

    public boolean startsWithIgnoreCase(String s, int pos) {
        switch (this.type) {
            case 1: {
                if (this.strValue == null) {
                    return false;
                }
                if (this.strValue.length() < pos + s.length()) {
                    return false;
                }
                int i = 0;
                while (i < s.length()) {
                    if (Ascii.toLower(s.charAt(i)) != Ascii.toLower(this.strValue.charAt(pos + i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 3: {
                return this.charC.startsWithIgnoreCase(s, pos);
            }
            case 2: {
                return this.byteC.startsWithIgnoreCase(s, pos);
            }
        }
        return false;
    }

    public void toBytes() {
    }

    public void toChars() {
        if (!this.charC.isNull()) {
            return;
        }
        this.toString();
        char[] cc = this.strValue.toCharArray();
        this.charC.setChars(cc, 0, cc.length);
    }

    public String toString() {
        if (this.hasStrValue) {
            return this.strValue;
        }
        this.hasStrValue = true;
        switch (this.type) {
            case 3: {
                this.strValue = this.charC.toString();
                return this.strValue;
            }
            case 2: {
                this.strValue = this.byteC.toString();
                return this.strValue;
            }
        }
        return null;
    }

    public static class MessageBytesFactory {
        protected MessageBytesFactory() {
        }

        public MessageBytes newInstance() {
            return new MessageBytes();
        }
    }
}

