/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLPrematureCloseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

class SSLuintX
extends SSLPDU {
    int value;
    short size;

    public SSLuintX(short s) {
        this.size = s;
    }

    public SSLuintX(short s, int n) {
        this.size = s;
        this.value = n;
    }

    public SSLuintX(int n) {
        this.size = 0;
        while (n > 0) {
            this.size = (short)(this.size + 1);
            n >>= 8;
        }
    }

    public SSLuintX(int n, int n2) {
        this(n);
        this.value = n2;
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws Error, IOException {
        SSLConn.debug(1, "Integer size " + this.size + "value " + this.value);
        switch (this.size) {
            case 4: {
                outputStream.write(this.value >> 24 & 0xFF);
            }
            case 3: {
                outputStream.write(this.value >> 16 & 0xFF);
            }
            case 2: {
                outputStream.write(this.value >> 8 & 0xFF);
            }
            case 1: {
                outputStream.write(this.value & 0xFF);
                break;
            }
            default: {
                throw new Error("Bad size for uintX");
            }
        }
        return this.size;
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException {
        this.value = 0;
        SSLConn.debug(1, "Reading a " + this.size + "byte integer");
        int n = 0;
        while (n < this.size) {
            this.value <<= 8;
            int n2 = inputStream.read();
            if (n2 < 0) {
                throw new SSLPrematureCloseException("Short read");
            }
            this.value += n2;
            SSLConn.debug(1, "Read byte " + n2);
            ++n;
        }
        SSLConn.debug(1, "Read Integer size " + this.size + "value " + this.value);
        return this.size;
    }

    public void print(SSLConn sSLConn, PrintWriter printWriter) {
        printWriter.println("Integer[" + this.size + "] =" + this.value);
    }
}

