/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLSocket;
import COM.claymoresystems.sslg.SSLPolicyInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class SSLServerSocket
extends ServerSocket {
    SSLContext ctx;

    public SSLServerSocket(SSLContext sSLContext, Integer n, Integer n2, InetAddress inetAddress) throws IOException {
        this(sSLContext, (int)n, (int)n2, inetAddress);
    }

    public SSLServerSocket(SSLContext sSLContext, int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
        this.ctx = sSLContext;
    }

    public SSLServerSocket(SSLContext sSLContext, int n) throws IOException {
        this(sSLContext, n, 50);
    }

    public SSLServerSocket(SSLContext sSLContext, int n, int n2) throws IOException {
        this(sSLContext, n, n2, (InetAddress)null);
    }

    public Socket accept() throws IOException {
        SSLSocket sSLSocket = new SSLSocket();
        this.implAccept(sSLSocket);
        sSLSocket.serverHandshake(this.ctx);
        return sSLSocket;
    }

    public static void main(String[] stringArray) throws IOException {
        SSLPolicyInt sSLPolicyInt = new SSLPolicyInt();
        sSLPolicyInt.requireClientAuth(true);
        SSLContext sSLContext = new SSLContext();
        sSLContext.setPolicy(sSLPolicyInt);
        sSLContext.loadRootCertificates("root.b64");
        sSLContext.loadEAYKeyFile("bookdsa.pem", "password");
        SSLServerSocket sSLServerSocket = new SSLServerSocket(sSLContext, 2311);
        while (true) {
            Object object;
            Object object2;
            SSLSocket sSLSocket = (SSLSocket)sSLServerSocket.accept();
            System.out.println("Cert chain");
            if (sSLPolicyInt.requireClientAuthP()) {
                object2 = sSLSocket.getCertificateChain();
                int n = 0;
                while (n < ((Vector)object2).size()) {
                    object = (X509Cert)((Vector)object2).elementAt(n);
                    System.out.println("Issuer " + ((X509Cert)object).getIssuerName().getNameString());
                    System.out.println("Subject " + ((X509Cert)object).getSubjectName().getNameString());
                    System.out.println("Serial " + ((X509Cert)object).getSerial());
                    System.out.println("Validity " + ((X509Cert)object).getValidityNotBefore() + "-" + ((X509Cert)object).getValidityNotAfter());
                    ++n;
                }
            }
            object2 = new InputStreamReader(sSLSocket.getInputStream());
            BufferedReader bufferedReader = new BufferedReader((Reader)object2);
            object = new OutputStreamWriter(sSLSocket.getOutputStream());
            BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);
            String string = bufferedReader.readLine();
            System.out.println(string);
            String string2 = "Server stuff";
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.flush();
            sSLSocket.close();
            System.out.println("Success");
        }
    }
}

