/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.mail;

import java.net.URL;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.mail.Email;
import org.apache.turbine.util.mail.EmailAttachment;

public class MultiPartEmail
extends Email {
    protected MimeMultipart emailBody;
    protected MimeBodyPart main;
    private String fileServer = null;

    protected void init() throws MessagingException {
        super.init();
        this.fileServer = null;
        this.emailBody = new MimeMultipart();
        this.message.setContent((Multipart)this.emailBody);
        this.main = new MimeBodyPart();
        this.emailBody.addBodyPart((BodyPart)this.main);
    }

    protected void initCriteria(Criteria criteria) throws MessagingException {
        Vector attachments;
        super.initCriteria(criteria);
        if (criteria.containsKey("email.body")) {
            this.setMsg(criteria.getString("email.body"));
        } else {
            this.setMsg("NO MESSAGE");
        }
        if (criteria.containsKey("attachments")) {
            Vector vector = (Vector)criteria.get("attachments");
        } else {
            attachments = new Vector();
        }
        if (criteria.containsKey("file.server")) {
            this.fileServer = criteria.getString("file.server");
        }
        int i = 0;
        while (i < attachments.size()) {
            EmailAttachment attachment = (EmailAttachment)attachments.elementAt(i);
            this.attach(attachment);
            ++i;
        }
    }

    public Email setMsg(String msg) throws MessagingException {
        if (this.charset != null) {
            this.main.setText(msg, this.charset);
        } else {
            this.main.setText(msg);
        }
        return this;
    }

    public MultiPartEmail attach(EmailAttachment attachment) throws MessagingException {
        URL url = attachment.getURL();
        if (url == null) {
            try {
                String file = attachment.getPath();
                url = new URL("file", this.fileServer, file);
            }
            catch (Exception e) {
                throw new MessagingException("Cannot find file", e);
            }
        }
        return this.attach(url, attachment.getName(), attachment.getDescription(), attachment.getDisposition());
    }

    public MultiPartEmail attach(URL url, String name, String description) throws MessagingException {
        return this.attach(url, name, description, "attachment");
    }

    public MultiPartEmail attach(URL url, String name, String description, String disposition) throws MessagingException {
        return this.attach((DataSource)new URLDataSource(url), name, description, disposition);
    }

    public MultiPartEmail attach(DataSource ds, String name, String description) throws MessagingException {
        return this.attach(ds, name, description, "attachment");
    }

    public MultiPartEmail attach(DataSource ds, String name, String description, String disposition) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        this.emailBody.addBodyPart((BodyPart)mbp);
        mbp.setDisposition(disposition);
        mbp.setFileName(name);
        mbp.setDescription(description);
        mbp.setDataHandler(new DataHandler(ds));
        return this;
    }

    public MultiPartEmail() throws MessagingException {
        this.init();
    }

    public MultiPartEmail(Criteria criteria) throws MessagingException {
        this.init();
        this.initCriteria(criteria);
    }
}

