/*
 * Decompiled with CFR 0.152.
 */
package org.arrowhead.testlet.engine;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.arrowhead.testlet.TestResultListener;
import org.arrowhead.testlet.Testlet;
import org.arrowhead.testlet.TestletContext;
import org.arrowhead.testlet.engine.AbstractTestEngine;

public class AwtTestEngine
extends AbstractTestEngine
implements TestResultListener {
    protected StringBuffer m_textData;
    protected TextField m_txtTestlet;
    protected TextArea m_taOutput;
    protected boolean m_clearTextOnRun = true;
    protected Checkbox m_bannerCheckBox;
    protected Checkbox m_successCheckBox;
    protected Checkbox m_traceCheckBox;
    protected Checkbox m_clearCheckBox;

    protected void initialize() {
        this.m_textData = new StringBuffer();
        GridBagConstraints gridBagConstraints = null;
        Frame frame = new Frame("Java Testlet Engine");
        frame.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        Label label = new Label();
        frame.add((Component)label, gridBagConstraints);
        label.setText("Testlet GUI Frontend");
        label.setFont(new Font("Dialog", 1, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        this.m_txtTestlet = new TextField();
        frame.add((Component)this.m_txtTestlet, gridBagConstraints);
        this.m_txtTestlet.setText("");
        this.m_txtTestlet.addActionListener(new RunTestActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 5;
        Button button = new Button("Go");
        frame.add((Component)button, gridBagConstraints);
        button.addActionListener(new RunTestActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        this.m_taOutput = new TextArea();
        frame.add((Component)this.m_taOutput, gridBagConstraints);
        this.m_taOutput.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        Panel panel = new Panel();
        frame.add((Component)panel, gridBagConstraints);
        panel.setLayout(new GridLayout(1, 4));
        OptionItemListener optionItemListener = new OptionItemListener();
        this.m_bannerCheckBox = new Checkbox("Show Banner", this.m_showBanner);
        this.m_bannerCheckBox.addItemListener(optionItemListener);
        panel.add(this.m_bannerCheckBox);
        this.m_successCheckBox = new Checkbox("Show Success", this.m_showSuccess);
        this.m_successCheckBox.addItemListener(optionItemListener);
        panel.add(this.m_successCheckBox);
        this.m_traceCheckBox = new Checkbox("Show Traces", this.m_showTrace);
        this.m_traceCheckBox.addItemListener(optionItemListener);
        panel.add(this.m_traceCheckBox);
        this.m_clearCheckBox = new Checkbox("Clear text on Run", this.m_clearTextOnRun);
        this.m_clearCheckBox.addItemListener(optionItemListener);
        panel.add(this.m_clearCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        Panel panel2 = new Panel();
        frame.add((Component)panel2, gridBagConstraints);
        Button button2 = new Button("Exit");
        panel2.add(button2);
        button2.addActionListener(new ExitActionListener());
        ((Component)frame).setSize(400, 200);
        frame.pack();
        frame.show();
        frame.addWindowListener(new CloseWindowListener());
    }

    public static void main(String[] stringArray) {
        AwtTestEngine awtTestEngine = new AwtTestEngine();
        awtTestEngine.runEngine(stringArray);
    }

    public void output(String string) {
        this.m_textData.append(string);
        this.m_taOutput.setText(this.m_textData.toString());
    }

    protected void testletPreamble(Testlet testlet, TestletContext testletContext) {
        if (this.m_clearTextOnRun) {
            this.m_textData.setLength(0);
            this.output("");
        }
        super.testletPreamble(testlet, testletContext);
    }

    private class ExitActionListener
    implements ActionListener {
        private ExitActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    private class OptionItemListener
    implements ItemListener {
        private OptionItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            AwtTestEngine.this.m_showTrace = AwtTestEngine.this.m_traceCheckBox.getState();
            AwtTestEngine.this.m_showBanner = AwtTestEngine.this.m_bannerCheckBox.getState();
            AwtTestEngine.this.m_showSuccess = AwtTestEngine.this.m_successCheckBox.getState();
            AwtTestEngine.this.m_clearTextOnRun = AwtTestEngine.this.m_clearCheckBox.getState();
        }
    }

    private class CloseWindowListener
    extends WindowAdapter {
        private CloseWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    private class RunTestActionListener
    implements ActionListener {
        private RunTestActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AwtTestEngine.this.processTestlet(AwtTestEngine.this.m_txtTestlet.getText());
        }
    }
}

