/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;

public abstract class PeerInfoResponseMessage {
    private ID spid = ID.nullID;
    private ID tpid = ID.nullID;
    private StructuredDocument response = null;
    private long uptime = 0L;
    private long timestamp = 0L;
    private long lastIncomingMessageTime = 0L;
    private long lastOutgoingMessageTime = 0L;
    private Hashtable incomingTraffic = new Hashtable();
    private Hashtable outgoingTraffic = new Hashtable();

    public static String getMessageType() {
        return "jxta:PeerInfoResponseMessage";
    }

    public ID getSourcePid() {
        return this.spid;
    }

    public void setSourcePid(ID iD) {
        this.spid = iD;
    }

    public ID getTargetPid() {
        return this.tpid;
    }

    public void setTargetPid(ID iD) {
        this.tpid = iD;
    }

    public Element getResponse() {
        if (null != this.response) {
            return StructuredDocumentUtils.copyAsDocument(this.response);
        }
        return null;
    }

    public void setResponse(Element element) {
        this.response = null != element ? StructuredDocumentUtils.copyAsDocument(element) : null;
    }

    public long getUptime() {
        return this.uptime;
    }

    public void setUptime(long l) {
        this.uptime = l;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public long getLastIncomingMessageTime() {
        return this.lastIncomingMessageTime;
    }

    public void setLastIncomingMessageTime(long l) {
        this.lastIncomingMessageTime = l;
    }

    public long getLastOutgoingMessageTime() {
        return this.lastOutgoingMessageTime;
    }

    public void setLastOutgoingMessageTime(long l) {
        this.lastOutgoingMessageTime = l;
    }

    public Enumeration getIncomingTrafficChannels() {
        return this.incomingTraffic.keys();
    }

    public long getIncomingTrafficOnChannel(String string) {
        Long l = (Long)this.incomingTraffic.get(string);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    public void setIncomingTrafficElement(String string, long l) {
        this.incomingTraffic.put(string, new Long(l));
    }

    public Enumeration getOutgoingTrafficChannels() {
        return this.outgoingTraffic.keys();
    }

    public long getOutgoingTrafficOnChannel(String string) {
        Long l = (Long)this.outgoingTraffic.get(string);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    public void setOutgoingTrafficElement(String string, long l) {
        this.outgoingTraffic.put(string, new Long(l));
    }

    public abstract Document getDocument(MimeMediaType var1);
}

