/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xml;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jxta.impl.xml.XmlParser;

public class BinaryXmlParser {
    public void parse(InputStream inputStream, byte[] byArray, XmlParser.ParserCallback parserCallback, AtomTable atomTable) throws IOException, XmlParser.Exception {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray2 = null;
        block9: while (true) {
            switch (dataInputStream.read()) {
                case 1: {
                    int n = dataInputStream.readInt();
                    int n2 = dataInputStream.readInt();
                    byte[] byArray3 = new byte[n2];
                    dataInputStream.readFully(byArray3);
                    atomTable.intern(byArray3);
                    break;
                }
                case 2: {
                    int n = dataInputStream.readInt();
                    byte[] byArray4 = atomTable.getAtom(n);
                    parserCallback.startTag(byArray4, 0, byArray4.length);
                    break;
                }
                case 3: {
                    int n = dataInputStream.readInt();
                    byArray2 = atomTable.getAtom(n);
                    break;
                }
                case 4: {
                    int n = dataInputStream.readInt();
                    byte[] byArray5 = atomTable.getAtom(n);
                    parserCallback.attribute(byArray2, 0, byArray2.length, byArray5, 0, byArray5.length);
                    break;
                }
                case 5: {
                    int n = dataInputStream.readInt();
                    while (true) {
                        if (n <= 0) continue block9;
                        int n3 = Math.min(n, byArray.length);
                        n3 = dataInputStream.read(byArray, 0, n3);
                        parserCallback.chars(byArray, 0, n3);
                        n -= n3;
                    }
                }
                case 6: {
                    int n = dataInputStream.readInt();
                    byte[] byArray6 = atomTable.getAtom(n);
                    parserCallback.endTag(byArray6, 0, byArray6.length);
                    break;
                }
                case 7: {
                    return;
                }
            }
        }
    }

    public static class AtomTable {
        byte[][] atoms;
        int maxAtoms;
        int maxSize;
        int pos;
        int size;

        public AtomTable(int n, int n2) {
            this.maxAtoms = n;
            this.maxSize = n2;
            this.atoms = new byte[n / 4][];
        }

        byte[] getAtom(int n) {
            if (n < this.atoms.length) {
                return this.atoms[n];
            }
            return null;
        }

        int intern(byte[] byArray) {
            if (this.pos == this.maxAtoms) {
                this.pos = 0;
            }
            if ((this.size += byArray.length) > this.maxSize) {
                this.pos = 0;
            }
            if (this.pos == this.atoms.length) {
                int n = Math.min(this.maxAtoms, 2 * this.atoms.length);
                byte[][] byArrayArray = new byte[n][];
                System.arraycopy(this.atoms, 0, byArrayArray, 0, this.atoms.length);
                this.atoms = byArrayArray;
                this.pos = 0;
            }
            int n = this.pos++;
            this.atoms[n] = byArray;
            return n;
        }
    }
}

