/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util;

import java.util.Enumeration;
import java.util.Hashtable;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.AdvertisementFactory;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.protocol.ModuleClassAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ModuleSpecAdvertisement;

public class ModuleManager {
    private static Hashtable managers = null;
    private static long LOCAL_ADV_TTL = 300000L;
    private static long REMOTE_ADV_TTL = 0L;
    private Hashtable modules = new Hashtable();
    private PeerGroup group = null;

    private ModuleManager(PeerGroup peerGroup) {
        this.group = peerGroup;
    }

    public void startModule(String string, String[] stringArray) {
        ModuleDesc moduleDesc = (ModuleDesc)this.modules.get(string);
        if (moduleDesc == null) {
            return;
        }
        moduleDesc.startApp(stringArray);
    }

    public void stopModule(String string) {
        ModuleDesc moduleDesc = (ModuleDesc)this.modules.get(string);
        if (moduleDesc == null) {
            return;
        }
        moduleDesc.stopApp();
    }

    public static ModuleManager getModuleManager(PeerGroup peerGroup) {
        if (managers == null) {
            managers = new Hashtable();
        }
        ModuleManager moduleManager = null;
        moduleManager = (ModuleManager)managers.get(peerGroup.getPeerGroupID());
        if (moduleManager == null) {
            moduleManager = new ModuleManager(peerGroup);
            managers.put(peerGroup.getPeerGroupID(), moduleManager);
        }
        return moduleManager;
    }

    private synchronized boolean registerModule(String string, Module module) {
        ModuleDesc moduleDesc = (ModuleDesc)this.modules.get(module);
        if (moduleDesc != null) {
            return false;
        }
        moduleDesc = new ModuleDesc(module);
        this.modules.put(string, moduleDesc);
        return true;
    }

    private synchronized Module unregisterModule(String string) {
        ModuleDesc moduleDesc = (ModuleDesc)this.modules.get(string);
        if (moduleDesc == null) {
            return null;
        }
        this.modules.remove(string);
        return moduleDesc.module;
    }

    public synchronized Module lookupModule(String string) {
        ModuleDesc moduleDesc = (ModuleDesc)this.modules.get(string);
        if (moduleDesc == null) {
            return null;
        }
        return moduleDesc.module;
    }

    public synchronized Module loadModule(String string, ModuleManagerLoader moduleManagerLoader) {
        Module module = this.lookupModule(string);
        if (module != null) {
            return module;
        }
        module = moduleManagerLoader.loadModule(string);
        if (module != null) {
            try {
                module.init(this.group, null, null);
            }
            catch (Exception exception) {
                return null;
            }
            this.registerModule(string, module);
        }
        return module;
    }

    public synchronized Module loadModule(String string, String string2) {
        Module module = this.lookupModule(string);
        if (module != null) {
            return module;
        }
        if (!this.createModuleAdvs(string, null, string2, null, LOCAL_ADV_TTL, REMOTE_ADV_TTL)) {
            return null;
        }
        module = this.loadModule(string);
        if (module == null) {
            return null;
        }
        return module;
    }

    private synchronized Module loadModule(String string) {
        Module module = this.lookupModule(string);
        if (module != null) {
            return module;
        }
        try {
            Enumeration enumeration = this.group.getDiscoveryService().getLocalAdvertisements(2, "Name", string);
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return null;
            }
            ModuleClassAdvertisement moduleClassAdvertisement = null;
            while (enumeration.hasMoreElements()) {
                try {
                    moduleClassAdvertisement = (ModuleClassAdvertisement)enumeration.nextElement();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            enumeration = this.group.getDiscoveryService().getLocalAdvertisements(2, "Name", string);
            if (enumeration == null || !enumeration.hasMoreElements()) {
                return null;
            }
            ModuleSpecAdvertisement moduleSpecAdvertisement = null;
            while (enumeration.hasMoreElements()) {
                try {
                    moduleSpecAdvertisement = (ModuleSpecAdvertisement)enumeration.nextElement();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            module = this.group.loadModule(moduleClassAdvertisement.getModuleClassID(), moduleSpecAdvertisement.getModuleSpecID(), 0);
            if (module != null) {
                this.registerModule(string, module);
            }
            return module;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean createModuleAdvs(String string, String string2, String string3, String string4, long l, long l2) {
        DiscoveryService discoveryService = this.group.getDiscoveryService();
        try {
            ModuleClassAdvertisement moduleClassAdvertisement = (ModuleClassAdvertisement)AdvertisementFactory.newAdvertisement(ModuleClassAdvertisement.getAdvertisementType());
            moduleClassAdvertisement.setName(string);
            moduleClassAdvertisement.setDescription("Created by ModuleManager: " + string);
            ModuleClassID moduleClassID = IDFactory.newModuleClassID();
            moduleClassAdvertisement.setModuleClassID(moduleClassID);
            discoveryService.publish(moduleClassAdvertisement, 2, l, l2);
            ModuleSpecAdvertisement moduleSpecAdvertisement = (ModuleSpecAdvertisement)AdvertisementFactory.newAdvertisement(ModuleSpecAdvertisement.getAdvertisementType());
            moduleSpecAdvertisement.setName(string);
            moduleSpecAdvertisement.setCreator("jxta.org");
            moduleSpecAdvertisement.setModuleSpecID(IDFactory.newModuleSpecID(moduleClassID));
            if (string2 != null) {
                moduleSpecAdvertisement.setSpecURI(string2);
            }
            discoveryService.publish(moduleSpecAdvertisement, 2, l, l2);
            ModuleImplAdvertisement moduleImplAdvertisement = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
            moduleImplAdvertisement.setModuleSpecID(moduleSpecAdvertisement.getModuleSpecID());
            if (string3 != null) {
                moduleImplAdvertisement.setCode(string3);
            }
            if (string4 != null) {
                moduleImplAdvertisement.setUri(string4);
            }
            moduleImplAdvertisement.setDescription("Created by ModuleManager: " + string);
            ModuleImplAdvertisement moduleImplAdvertisement2 = (ModuleImplAdvertisement)this.group.getImplAdvertisement();
            moduleImplAdvertisement.setCompat(moduleImplAdvertisement2.getCompat());
            discoveryService.publish(moduleImplAdvertisement, 2, l, l2);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private class ModuleDesc {
        protected Module module = null;
        private boolean started = false;
        private boolean stopped = true;

        public ModuleDesc(Module module) {
            this.module = module;
        }

        public void startApp(String[] stringArray) {
            if (this.module == null) {
                return;
            }
            if (this.started) {
                return;
            }
            this.module.startApp(stringArray);
            this.started = true;
            this.stopped = false;
        }

        public void stopApp() {
            if (this.module == null) {
                return;
            }
            if (this.stopped) {
                return;
            }
            this.module.stopApp();
            this.stopped = true;
            this.started = false;
        }
    }

    public static interface ModuleManagerLoader {
        public Module loadModule(String var1);
    }
}

