/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageElementEnumeration;
import net.jxta.exception.DiscardQueryException;
import net.jxta.exception.NoResponseException;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ResendQueryException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.resolver.ResolverServiceInterface;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import net.jxta.util.StringEnumeration;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class ResolverServiceImpl
implements ResolverService,
EndpointListener {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$resolver$ResolverServiceImpl == null ? (class$net$jxta$impl$resolver$ResolverServiceImpl = ResolverServiceImpl.class$("net.jxta.impl.resolver.ResolverServiceImpl")) : class$net$jxta$impl$resolver$ResolverServiceImpl).getName());
    public String outQueNameShort = "ORes";
    public String inQueNameShort = "IRes";
    public String outQueName = "ORes";
    public String inQueName = "IRes";
    private EndpointService endpoint;
    private Hashtable handlers = new Hashtable(50);
    private PeerGroup myGroup = null;
    private String localPeerId = null;
    private RendezVousService rendezvous = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private RecvDemux recvMux = null;
    private String handlerName = null;
    static /* synthetic */ Class class$net$jxta$impl$resolver$ResolverServiceImpl;

    private EndpointAddress mkAddress(String string, String string2, String string3) {
        try {
            PeerID peerID = (PeerID)IDFactory.fromURL(new URL(string));
            String string4 = "jxta://" + peerID.getUniqueValue().toString();
            EndpointAddress endpointAddress = this.endpoint.newEndpointAddress(string4);
            endpointAddress.setServiceName(string2);
            endpointAddress.setServiceParameter(string3);
            return endpointAddress;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Invalid peerID string " + string));
            }
            return null;
        }
    }

    public int startApp(String[] stringArray) {
        this.rendezvous = this.myGroup.getRendezVousService();
        try {
            this.rendezvous.addPropagateListener(this.handlerName + this.outQueName, this);
            this.rendezvous.addPropagateListener(this.handlerName + this.inQueName, this.recvMux);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"failed to add listeners", (Throwable)exception);
            }
            return 1;
        }
        return 0;
    }

    public void stopApp() {
        try {
            this.rendezvous.removePropagateListener(this.handlerName + this.outQueName, this);
            this.rendezvous.removePropagateListener(this.handlerName + this.inQueName, this.recvMux);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Service getInterface() {
        return new ResolverServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public synchronized QueryHandler registerHandler(String string, QueryHandler queryHandler) {
        return this.handlers.put(string, queryHandler);
    }

    public synchronized QueryHandler unregisterHandler(String string) {
        return (QueryHandler)this.handlers.remove(string);
    }

    public QueryHandler getHandler(String string) {
        return (QueryHandler)this.handlers.get(string);
    }

    public void sendQuery(String string, ResolverQueryMsg resolverQueryMsg) {
        if (this.rendezvous == null) {
            return;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sending query");
        }
        Object var3_3 = null;
        Message message = this.endpoint.newMessage();
        if (string == null) {
            try {
                message.addElement(message.newMessageElement(this.outQueName, new MimeMediaType("text/xml"), resolverQueryMsg.getDocument(new MimeMediaType("text/xml")).getStream()));
                this.rendezvous.propagateInGroup(message, this.handlerName, this.outQueName, 7, null);
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"Error during propagate", (Throwable)exception);
                }
                throw new RuntimeException("Error during propagate :" + exception.toString());
            }
        }
        try {
            this.respond(string, this.handlerName, this.outQueName, this.outQueName, resolverQueryMsg.getDocument(new MimeMediaType("text/xml")).getStream());
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Error while unicasting query :", (Throwable)exception);
            }
            throw new RuntimeException("Error while unicasting query :" + exception.toString());
        }
    }

    public PeerGroup getGroup() {
        return this.myGroup;
    }

    private void propagateQuery(Message message) {
        block4: {
            if (this.rendezvous == null) {
                return;
            }
            if (!this.myGroup.isRendezvous()) {
                return;
            }
            try {
                this.rendezvous.propagateInGroup(message, this.handlerName, this.outQueName, 7, this.localPeerId);
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block4;
                LOG.debug((Object)"Error propagating query", (Throwable)iOException);
            }
        }
    }

    private void resendQuery(Message message, String string) {
        block11: {
            Object object;
            if (this.rendezvous == null) {
                return;
            }
            if (!this.myGroup.isRendezvous()) {
                return;
            }
            MessageElementEnumeration messageElementEnumeration = message.getElements();
            String string2 = null;
            Vector<ResolverQuery> vector = new Vector<ResolverQuery>();
            ResolverQuery resolverQuery = null;
            while (messageElementEnumeration.hasMoreMessageElements()) {
                object = messageElementEnumeration.nextMessageElement();
                string2 = ((MessageElement)object).getName();
                if (!string2.endsWith(this.outQueNameShort) && !string2.endsWith(this.inQueNameShort)) continue;
                try {
                    MessageElement messageElement = message.getElement(string2);
                    resolverQuery = new ResolverQuery(messageElement.getStream());
                    message.removeElement(messageElement);
                    resolverQuery.setSrc(string);
                    vector.addElement(resolverQuery);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (vector.size() == 0) {
                return;
            }
            object = this.endpoint.newMessage();
            int n = 0;
            while (n < vector.size()) {
                try {
                    resolverQuery = (ResolverQuery)vector.elementAt(n);
                    object.addElement(object.newMessageElement(this.outQueName, new MimeMediaType("text/xml"), resolverQuery.getDocument(new MimeMediaType("text/xml")).getStream()));
                }
                catch (Exception exception) {
                    return;
                }
                ++n;
            }
            try {
                this.rendezvous.propagateInGroup((Message)object, this.handlerName, this.outQueName, 7, this.localPeerId);
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block11;
                LOG.debug((Object)"Error propagating resending query", (Throwable)iOException);
            }
        }
    }

    public void processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"demuxing a query");
        }
        Message message2 = (Message)message.clone();
        MessageElementEnumeration messageElementEnumeration = message.getElements();
        while (messageElementEnumeration.hasMoreElements()) {
            MessageElement messageElement = messageElementEnumeration.nextMessageElement();
            String string = messageElement.getName();
            if (!string.endsWith(this.outQueNameShort) && !string.endsWith(this.inQueNameShort)) continue;
            try {
                MessageElement messageElement2 = message.getElement(string);
                message.removeElement(messageElement2);
                ResolverQuery resolverQuery = new ResolverQuery(messageElement2.getStream());
                ResolverResponseMsg resolverResponseMsg = this.processQuery(resolverQuery);
                if (resolverResponseMsg != null) {
                    this.respond(resolverQuery.getSrc(), this.handlerName, this.inQueName, string, resolverResponseMsg.getDocument(new MimeMediaType("text/xml")).getStream());
                }
                this.propagateQuery(message2);
            }
            catch (ResendQueryException resendQueryException) {
                this.propagateQuery((Message)message2.clone());
                this.resendQuery(message2, this.localPeerId);
            }
            catch (NoResponseException noResponseException) {
                this.propagateQuery(message2);
            }
            catch (DiscardQueryException discardQueryException) {
                return;
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)exception);
                }
                return;
            }
        }
    }

    public ResolverResponseMsg processQuery(ResolverQueryMsg resolverQueryMsg) throws NoResponseException, ResendQueryException, DiscardQueryException, IOException {
        QueryHandler queryHandler;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("handing a query to  " + ((ResolverQuery)resolverQueryMsg).getHandlerName()));
        }
        if ((queryHandler = this.getHandler(((ResolverQuery)resolverQueryMsg).getHandlerName())) == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("throwing away " + ((ResolverQuery)resolverQueryMsg).getHandlerName()));
            }
            return null;
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("handing a query to  " + ((ResolverQuery)resolverQueryMsg).getHandlerName()));
        }
        ResolverResponseMsg resolverResponseMsg = queryHandler.processQuery(resolverQueryMsg);
        return resolverResponseMsg;
    }

    public void processResponse(ResolverResponseMsg resolverResponseMsg) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("pushing a response to  " + resolverResponseMsg.getHandlerName()));
        }
        QueryHandler queryHandler = this.getHandler(resolverResponseMsg.getHandlerName());
        queryHandler.processResponse(resolverResponseMsg);
    }

    public void sendResponse(String string, ResolverResponseMsg resolverResponseMsg) {
        if (string == null) {
            this.propagateResponse(resolverResponseMsg);
        } else {
            try {
                this.respond(string, this.handlerName, this.inQueName, this.inQueName, resolverResponseMsg.getDocument(new MimeMediaType("text/xml")).getStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void propagateResponse(ResolverResponseMsg resolverResponseMsg) {
        block3: {
            if (this.rendezvous == null) {
                return;
            }
            Message message = this.endpoint.newMessage();
            try {
                message.addElement(message.newMessageElement(this.inQueName, new MimeMediaType("text/xml"), resolverResponseMsg.getDocument(new MimeMediaType("text/xml")).getStream()));
                this.rendezvous.propagateInGroup(message, this.handlerName, this.inQueName, 1, null);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block3;
                LOG.debug((Object)"failure on propagateResponse", (Throwable)exception);
            }
        }
    }

    private void respond(String string, String string2, String string3, String string4, InputStream inputStream) throws RuntimeException {
        Message message;
        block12: {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("destPeer :\n" + string));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("responding to " + string2 + "  " + string3 + " " + string4));
            }
            if (inputStream == null) {
                throw new RuntimeException("Attempting to respond with a empty message");
            }
            message = this.endpoint.newMessage();
            try {
                message.addElement(message.newMessageElement(string4, null, inputStream));
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block12;
                LOG.debug((Object)"Exception ", (Throwable)exception);
            }
        }
        EndpointMessenger endpointMessenger = null;
        try {
            endpointMessenger = this.endpoint.getMessenger(this.mkAddress(string, string2, string3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (endpointMessenger == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"endpoint.getMessenger failed to get messenger");
            }
            return;
        }
        try {
            endpointMessenger.sendMessage(message);
        }
        catch (IOException iOException) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"messenger.sendMessage failed to send", (Throwable)iOException);
            }
            throw new RuntimeException("messenger.sendMessage failed to send");
        }
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)advertisement;
        this.myGroup = peerGroup;
        this.endpoint = peerGroup.getEndpointService();
        this.localPeerId = peerGroup.getPeerID().toString();
        this.handlerName = iD.toString();
        String string = peerGroup.getPeerGroupID().getUniqueValue().toString();
        this.outQueName = string + this.outQueNameShort;
        this.inQueName = string + this.inQueNameShort;
        this.localPeerId = peerGroup.getPeerID().toString();
        this.recvMux = new RecvDemux();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RecvDemux
    implements EndpointListener {
        RecvDemux() {
        }

        public void processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
            StringEnumeration stringEnumeration;
            if (message == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"RecvDemux.demux: got a null message");
                }
                return;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"demuxing a response ");
            }
            if ((stringEnumeration = message.getNames()) == null) {
                return;
            }
            MessageElementEnumeration messageElementEnumeration = message.getElements();
            while (messageElementEnumeration.hasMoreElements()) {
                MessageElement messageElement = messageElementEnumeration.nextMessageElement();
                String string = messageElement.getName();
                if (!string.endsWith(ResolverServiceImpl.this.outQueNameShort) && !string.endsWith(ResolverServiceImpl.this.inQueNameShort)) continue;
                try {
                    while (true) {
                        MessageElement messageElement2 = message.getElement(string);
                        message.removeElement(messageElement2);
                        ResolverResponse resolverResponse = new ResolverResponse(messageElement2.getStream());
                        ResolverServiceImpl.this.processResponse(resolverResponse);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

