/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointFilterListener;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.rendezvous.PeerConnection;
import net.jxta.impl.rendezvous.RdvManager;
import net.jxta.impl.rendezvous.RdvMonitor;
import net.jxta.impl.rendezvous.RendAddrCompactor;
import net.jxta.impl.rendezvous.RendezVousPropagateMessage;
import net.jxta.impl.rendezvous.RendezVousServiceInterface;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.rendezvous.RendezVousManager;
import net.jxta.rendezvous.RendezVousMonitor;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RendezVousServiceImpl
implements RendezVousService,
EndpointListener {
    public static final int MaxTTL = 10;
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$rendezvous$RendezVousServiceImpl == null ? (class$net$jxta$impl$rendezvous$RendezVousServiceImpl = RendezVousServiceImpl.class$("net.jxta.impl.rendezvous.RendezVousServiceImpl")) : class$net$jxta$impl$rendezvous$RendezVousServiceImpl).getName());
    private static final long GCDelay = 60000L;
    private static final String ConnectRequest = "jxta:Connect";
    private static final String DisconnectRequest = "jxta:Disconnect";
    private static final String ConnectedPeerReply = "jxta:ConnectedPeer";
    private static final String ConnectedLeaseReply = "jxta:ConnectedLease";
    private static final String ConnectedRdvAdvReply = "jxta:RdvAdvReply";
    private static final String PingRequest = "jxta:PingRequest";
    private static final String PingReply = "jxta:PingReply";
    private static final String RdvAdvReply = "jxta:RdvAdv";
    private String pName = null;
    private EndpointService endpoint = null;
    private ID assignedID = null;
    private PeerGroup group = null;
    private String gId = null;
    private Vector rendezVous = null;
    private Vector removedRendezVous = new Vector();
    private Vector clients = null;
    private RendezVousManager manager = null;
    private RendezVousMonitor monitor = null;
    private boolean isRendezVous = false;
    private boolean configIsRendezvous = false;
    private boolean isClient = false;
    private boolean endpointCreated = false;
    private String pParam = null;
    private String headerName = null;
    private String localPeerId = null;
    private String localPeerAddr = null;
    private Advertisement localPeerAdv = null;
    private Timer GCTimer = new Timer();
    private ModuleImplAdvertisement implAdvertisement = null;
    private Hashtable listeners = new Hashtable();
    private EndpointFilterListener filterListener = null;
    private Vector applisteners = new Vector();
    private RendAddrCompactor compactor = null;
    private Vector initialCompactorParams = new Vector();
    private boolean stopping = false;
    private static final String PropSName = "JxtaPropagate";
    private String PropPName = null;
    private PropagateListener propagateListener = null;
    private static final int MaxNbOfStoredIds = 200;
    private Vector msgIds = new Vector(200);
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$RendezVousServiceImpl;

    public synchronized RendezVousMonitor setMonitor(RendezVousMonitor rendezVousMonitor) {
        RendezVousMonitor rendezVousMonitor2 = this.monitor;
        this.monitor = rendezVousMonitor;
        return rendezVousMonitor2;
    }

    public Service getInterface() {
        return new RendezVousServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdvertisement;
    }

    public boolean isRendezVous() {
        return this.isRendezVous;
    }

    public synchronized Enumeration getConnectedPeers() {
        Vector<ID> vector = new Vector<ID>();
        if (!this.isRendezVous) {
            return vector.elements();
        }
        if (this.clients == null || this.clients.size() == 0) {
            return vector.elements();
        }
        int n = 0;
        while (n < this.clients.size()) {
            try {
                PeerConnection peerConnection = (PeerConnection)this.clients.elementAt(n);
                String string = peerConnection.getPeer();
                ID iD = IDFactory.fromURL(new URL(string));
                vector.addElement(iD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return vector.elements();
    }

    public boolean isConnectedToRendezVous() {
        Enumeration enumeration = this.getConnectedRendezVous();
        if (enumeration == null) {
            return false;
        }
        return enumeration.hasMoreElements();
    }

    public int startApp(String[] stringArray) {
        block3: {
            if (this.configIsRendezvous) {
                this.startRendezVous();
            }
            this.compactor = new RendAddrCompactor(this.group, this.initialCompactorParams);
            this.propagateListener = new PropagateListener(this);
            try {
                this.endpoint.addListener(PropSName + this.PropPName, this.propagateListener);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block3;
                LOG.warn((Object)"Cannot register the propagation listener", (Throwable)exception);
            }
        }
        this.GCTimer.scheduleAtFixedRate((TimerTask)new GCTask(this), 60000L, 60000L);
        return 0;
    }

    public synchronized void stopApp() {
        this.stopping = true;
        this.compactor.shutdown();
        this.stopRendezVous();
        this.endpoint.removeListener(PropSName + this.PropPName, this.propagateListener);
        this.endpoint.removeFilterListener(this.headerName, this.filterListener, true);
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) {
        PeerAdvertisement peerAdvertisement;
        block12: {
            this.implAdvertisement = (ModuleImplAdvertisement)advertisement;
            peerAdvertisement = (PeerAdvertisement)peerGroup.getConfigAdvertisement();
            this.group = peerGroup;
            this.gId = peerGroup.getPeerGroupID().toString();
            this.assignedID = iD;
            this.endpoint = peerGroup.getEndpointService();
            this.pParam = this.group.getPeerGroupID().toString();
            this.pName = iD.toString();
            this.PropPName = this.pParam;
            this.headerName = "RendezVousPropagate" + this.pParam;
            this.localPeerId = this.group.getPeerID().toString();
            this.localPeerAddr = "jxta://" + this.group.getPeerID().getUniqueValue().toString();
            this.localPeerAdv = this.group.getPeerAdvertisement();
            this.filterListener = new FilterListener();
            try {
                this.endpoint.addFilterListener(this.headerName, this.filterListener, true);
                this.endpoint.addFilterListener("RendezVousPropagate", this.filterListener, true);
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("Cannot register the filter: " + exception));
                }
                if (!LOG.isEnabledFor(Priority.WARN)) break block12;
                LOG.warn((Object)"This peer will not filter potentional loopbacks, expired or duplicate messages.");
            }
        }
        if (peerAdvertisement == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"RendezVousService is initialized");
            }
            return;
        }
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)peerAdvertisement.getServiceParam(iD);
        if (structuredTextDocument == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"RendezVousService is initialized");
            }
            return;
        }
        Enumeration enumeration = structuredTextDocument.getChildren("Rdv");
        this.configIsRendezvous = enumeration.hasMoreElements() && "true".equals(((TextElement)enumeration.nextElement()).getTextValue());
        enumeration = structuredTextDocument.getChildren("Addr");
        while (enumeration.hasMoreElements()) {
            this.initialCompactorParams.addElement(((TextElement)enumeration.nextElement()).getTextValue());
        }
        if (this.configIsRendezvous) {
            try {
                structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
                TextElement textElement = structuredTextDocument.createElement("Rdv", "true");
                structuredTextDocument.appendChild((Element)textElement);
                ((PeerAdvertisement)this.localPeerAdv).putServiceParam(iD, structuredTextDocument);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"RendezVousService is initialized");
        }
    }

    private void publishInParentGroup(Advertisement advertisement) {
        block5: {
            RefPeerGroup refPeerGroup = ((GenericPeerGroup)this.group).getParentGroup();
            if (refPeerGroup == null) {
                return;
            }
            DiscoveryService discoveryService = refPeerGroup.getDiscoveryService();
            if (discoveryService == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Cannot access parent's DiscoveryService Service");
                }
                return;
            }
            try {
                discoveryService.publish(advertisement, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (IOException iOException) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block5;
                LOG.warn((Object)"Cannot locally publish advertisementin parent group");
            }
        }
    }

    public void connectToRendezVous(PeerAdvertisement peerAdvertisement) throws IOException {
        String string;
        block9: {
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"connectToRendezVous with advertisement");
            }
            if (peerAdvertisement == null) {
                return;
            }
            string = peerAdvertisement.getPeerID().toString();
            if (string.equals(this.localPeerId)) {
                return;
            }
            try {
                this.group.getDiscoveryService().publish(peerAdvertisement, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                LOG.debug((Object)("   publish failed with " + exception));
            }
        }
        this.publishInParentGroup(peerAdvertisement);
        if (!this.endpoint.ping(this.mkAddress(string))) {
            throw new IOException();
        }
        EndpointMessenger endpointMessenger = this.endpoint.getMessenger(this.mkAddress(string, this.pName, this.pParam));
        if (endpointMessenger == null) {
            throw new IOException();
        }
        this.connectToRendezVous(endpointMessenger);
    }

    public void connectToRendezVous(EndpointAddress endpointAddress) throws IOException {
        Object object;
        String string;
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"connectToRendezVous with EndpointAddress");
        }
        if (endpointAddress == null) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)"bad endpoint address");
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            try {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("    to = " + endpointAddress.getProtocolName() + "://" + endpointAddress.getProtocolAddress()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(string = endpointAddress.getProtocolName()).equals("jxta")) {
            if (!this.endpoint.ping(endpointAddress)) {
                throw new IOException("Cannot ping rendezvous");
            }
        } else {
            object = endpointAddress.getProtocolName() + "://" + endpointAddress.getProtocolAddress();
            if (((String)object).equals(this.localPeerAddr)) {
                return;
            }
        }
        endpointAddress.setServiceName(this.pName);
        endpointAddress.setServiceParameter(this.pParam);
        try {
            object = this.endpoint.getMessenger(endpointAddress);
            if (object == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"no messenger");
                }
                throw new IOException("no messenger");
            }
            this.connectToRendezVous((EndpointMessenger)object);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"connectToRendezVous failed", (Throwable)exception);
            }
            throw new IOException("connectToRendezVous failed");
        }
    }

    public void reconnectToRendezVous(String string) {
        block6: {
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("reconnectToRendezVous to " + string));
            }
            if (string.equals(this.localPeerAddr)) {
                return;
            }
            try {
                EndpointMessenger endpointMessenger = this.endpoint.getMessenger(this.mkAddress(string, this.pName, this.pParam));
                if (endpointMessenger == null) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"Could not get messenger. aborting");
                    }
                    throw new IOException("Could not get messenger. aborting");
                }
                this.connectToRendezVous(endpointMessenger);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block6;
                LOG.debug((Object)"reconnecteRendezVous failed ", (Throwable)exception);
            }
        }
    }

    public void disconnectFromRendezVous(PeerID peerID) {
        if (!this.isClient || peerID == null) {
            return;
        }
        String string = peerID.toString();
        try {
            EndpointMessenger endpointMessenger = this.endpoint.getMessenger(this.mkAddress(string, this.pName, this.pParam));
            if (endpointMessenger != null) {
                this.disconnectFromRendezVous(endpointMessenger);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.removeRdv(string);
        if (this.rendezVous.size() == 0) {
            this.rendezVous = null;
            this.isClient = false;
        }
    }

    public synchronized Enumeration getConnectedRendezVous() {
        Vector<ID> vector = new Vector<ID>();
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"getConnectedRendezVous");
        }
        if (!this.isClient) {
            return vector.elements();
        }
        if (this.rendezVous == null || this.rendezVous.size() == 0) {
            return vector.elements();
        }
        int n = 0;
        while (n < this.rendezVous.size()) {
            try {
                PeerConnection peerConnection = (PeerConnection)this.rendezVous.elementAt(n);
                String string = peerConnection.getPeer();
                ID iD = IDFactory.fromURL(new URL(string));
                vector.addElement(iD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return vector.elements();
    }

    public synchronized Enumeration getDisconnectedRendezVous() {
        Vector<ID> vector = new Vector<ID>();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"getDisconnectedRendezVous");
        }
        if (!this.isClient) {
            return vector.elements();
        }
        if (this.removedRendezVous.size() == 0) {
            return vector.elements();
        }
        int n = 0;
        while (n < this.removedRendezVous.size()) {
            try {
                PeerConnection peerConnection = (PeerConnection)this.removedRendezVous.elementAt(n);
                String string = peerConnection.getPeer();
                ID iD = IDFactory.fromURL(new URL(string));
                vector.addElement(iD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        return vector.elements();
    }

    public void sendRendezVousAdv(PeerAdvertisement peerAdvertisement, PeerAdvertisement peerAdvertisement2) {
        block6: {
            try {
                this.group.getDiscoveryService().publish(peerAdvertisement, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block6;
                LOG.debug((Object)("publish failed with " + exception));
            }
        }
        this.publishInParentGroup(peerAdvertisement);
        String string = peerAdvertisement.getPeerID().toString();
        if (!this.endpoint.ping(this.endpoint.newEndpointAddress(string))) {
            return;
        }
        try {
            EndpointMessenger endpointMessenger = this.endpoint.getMessenger(this.mkAddress(string, this.pName, this.pParam));
            if (endpointMessenger == null) {
                return;
            }
            Message message = this.endpoint.newMessage();
            message.addElement(message.newMessageElement(RdvAdvReply, new MimeMediaType("text/xml"), peerAdvertisement2.getDocument(new MimeMediaType("text/xml")).getStream()));
            endpointMessenger.sendMessage(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void startRendezVous(RendezVousManager rendezVousManager) throws IOException {
        if (this.isRendezVous || rendezVousManager == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"startRendezvous: already a rendezvous");
            }
            throw new IOException();
        }
        this.manager = rendezVousManager;
        this.clients = new Vector();
        this.createLocalEndpoint();
        this.isRendezVous = true;
        try {
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), "Parm");
            TextElement textElement = structuredTextDocument.createElement("Rdv", "true");
            structuredTextDocument.appendChild((Element)textElement);
            ((PeerAdvertisement)this.localPeerAdv).putServiceParam(this.assignedID, structuredTextDocument);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((RdvMonitor)this.monitor).startRdv();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"RendezVousService is started");
        }
    }

    public synchronized void startRendezVous() {
        if (this.isRendezVous) {
            return;
        }
        try {
            this.startRendezVous(new RdvManager(this.group));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void stopRendezVous() {
        if (!this.isRendezVous) {
            return;
        }
        ((PeerAdvertisement)this.localPeerAdv).removeServiceParam(this.assignedID);
        this.isRendezVous = false;
        this.deleteLocalEndpoint();
        this.clients = null;
    }

    public void processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"demux");
        }
        try {
            if (message.hasElement(ConnectRequest)) {
                this.processConnectRequest(message);
            }
            if (message.hasElement(DisconnectRequest)) {
                this.processDisconnectRequest(message);
            }
            if (message.hasElement(RdvAdvReply)) {
                this.processRdvAdvReply(message);
            }
            if (message.hasElement(ConnectedPeerReply)) {
                this.processConnectedReply(message);
            }
            if (message.hasElement(PingRequest)) {
                this.processPingRequest(message);
            }
            if (message.hasElement(PingReply)) {
                this.processPingReply(message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void processReceivedMessage(Message message, String string, String string2, String string3, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
        EndpointListener endpointListener;
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processReceivedMessage starts");
        }
        if ((endpointListener = (EndpointListener)this.listeners.get(string2 + string3)) != null) {
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Local listener is called");
            }
            EndpointAddress endpointAddress3 = this.endpoint.newEndpointAddress(endpointAddress2.toString());
            endpointAddress3.setServiceName(string2);
            endpointAddress3.setServiceParameter(string3);
            if (this.isMsgIdRecorded(string)) {
                return;
            }
            this.addMsgId(string);
            endpointListener.processIncomingMessage(message, endpointAddress, endpointAddress3);
        } else {
            this.addMsgId(string);
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"No local listener - repropagate");
            }
            this.rePropagateInGroup(message);
        }
    }

    public synchronized void addPropagateListener(String string, EndpointListener endpointListener) throws IOException {
        block2: {
            this.listeners.put(string, endpointListener);
            try {
                this.endpoint.addListener(string, endpointListener);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.WARN)) break block2;
                LOG.warn((Object)("Cannot connect listener " + string), (Throwable)exception);
            }
        }
    }

    public synchronized void removePropagateListener(String string, EndpointListener endpointListener) throws IOException {
        EndpointListener endpointListener2 = (EndpointListener)this.listeners.get(string);
        if (endpointListener2 == null) {
            throw new IOException();
        }
        this.listeners.remove(string);
    }

    public void addListener(RendezvousListener rendezvousListener) {
        this.applisteners.addElement(rendezvousListener);
    }

    public boolean removeListener(RendezvousListener rendezvousListener) {
        return this.applisteners.removeElement(rendezvousListener);
    }

    public void propagate(Message message, String string, String string2, int n) throws IOException {
        if (n == 1) {
            this.propagateToNeighbors(message, string, string2, n, null);
        } else {
            this.propagateInGroup(message, string, string2, n, null);
        }
    }

    public void propagateToNeighbors(Message message, String string, String string2, int n, String string3) throws IOException {
        Message message2 = (Message)message.clone();
        if (this.updatePropHeader(message2, n, string, string2)) {
            this.sendToNetwork(message2, PropSName, this.PropPName);
        }
    }

    public void propagateInGroup(Message message, String string, String string2, int n, String string3) throws IOException {
        Message message2 = (Message)message.clone();
        if (this.updatePropHeader(message2, n, string, string2)) {
            this.sendToNetwork(message2, PropSName, this.PropPName);
            this.sendToEachRendezVous(message2, PropSName, this.PropPName);
            this.sendToEachClient(message2, PropSName, this.PropPName);
        }
    }

    protected void rePropagateInGroup(Message message) {
        block3: {
            try {
                Message message2 = (Message)message.clone();
                if (this.updatePropHeader(message2, 10, null, null)) {
                    this.sendToNetwork(message2, PropSName, this.PropPName);
                    this.sendToEachRendezVous(message2, PropSName, this.PropPName);
                    this.sendToEachClient(message2, PropSName, this.PropPName);
                }
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block3;
                LOG.debug((Object)"Cannot repropagate the message ", (Throwable)exception);
            }
        }
    }

    private boolean isPeerInPropHeader(Message message, String string) {
        MessageElement messageElement = message.getElement(this.headerName);
        if (messageElement == null && (messageElement = message.getElement("RendezVousPropagate")) == null) {
            return false;
        }
        try {
            InputStream inputStream = messageElement.getStream();
            if (inputStream == null) {
                return false;
            }
            RendezVousPropagateMessage rendezVousPropagateMessage = null;
            rendezVousPropagateMessage = new RendezVousPropagateMessage(inputStream);
            return rendezVousPropagateMessage.hasInPath(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private EndpointAddress mkAddress(String string) {
        try {
            PeerID peerID = (PeerID)IDFactory.fromURL(new URL(string));
            String string2 = "jxta://" + peerID.getUniqueValue().toString();
            EndpointAddress endpointAddress = this.endpoint.newEndpointAddress(string2);
            return endpointAddress;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Invalid peerID string " + string));
            }
            return null;
        }
    }

    private EndpointAddress mkAddress(String string, String string2, String string3) {
        EndpointAddress endpointAddress = this.mkAddress(string);
        endpointAddress.setServiceName(string2);
        endpointAddress.setServiceParameter(string3);
        return endpointAddress;
    }

    private synchronized void addRdv(String string, long l) {
        PeerConnection peerConnection;
        if (string == null) {
            return;
        }
        if (!this.isClient) {
            this.rendezVous = new Vector();
            this.isClient = true;
        }
        if (this.rendezVous.contains(peerConnection = new PeerConnection(this.group, string, l))) {
            block13: {
                if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   already registered");
                }
                try {
                    int n = this.rendezVous.indexOf(peerConnection);
                    if (n == -1) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("addRdv: cannot access PeerConnection for " + string));
                        }
                    } else {
                        peerConnection = (PeerConnection)this.rendezVous.elementAt(n);
                        long l2 = System.currentTimeMillis();
                        if (l < 0L) {
                            peerConnection.setLease(l);
                        } else {
                            peerConnection.setLease(l2 + l);
                        }
                        peerConnection.connect();
                        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("Got renewed leased for " + string));
                        }
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                    LOG.debug((Object)"addRdv has failed [1] ", (Throwable)exception);
                }
            }
            return;
        }
        peerConnection.connect();
        this.rendezVous.addElement(peerConnection);
        this.generateEvent(0, string);
        if (this.removedRendezVous.contains(peerConnection)) {
            this.removedRendezVous.remove(peerConnection);
        }
    }

    private synchronized void removeRdv(String string) {
        if (string == null) {
            return;
        }
        PeerConnection peerConnection = new PeerConnection(this.group, string, 0L);
        if (!this.rendezVous.contains(peerConnection)) {
            return;
        }
        peerConnection.close();
        this.rendezVous.removeElement(peerConnection);
        this.removedRendezVous.addElement(peerConnection);
        this.generateEvent(4, string);
    }

    private synchronized void addClient(String string, long l) {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"addClient starts");
        }
        if (string == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"no peer");
            }
            return;
        }
        if (!this.isRendezVous) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"is not a rendezvous");
            }
            return;
        }
        PeerConnection peerConnection = new PeerConnection(this.group, string, l);
        if (this.clients.contains(peerConnection)) {
            block16: {
                if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   already registered");
                }
                try {
                    int n = this.clients.indexOf(peerConnection);
                    if (n == -1) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("addClient: cannot access PeerConnection for " + string));
                        }
                    } else {
                        peerConnection = (PeerConnection)this.clients.elementAt(n);
                        long l2 = System.currentTimeMillis();
                        if (l < 0L) {
                            peerConnection.setLease(l);
                        } else {
                            peerConnection.setLease(l2 + l);
                        }
                        peerConnection.connect();
                        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("Renewed leased for " + string));
                        }
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block16;
                    LOG.debug((Object)"addClient has failed [1] ", (Throwable)exception);
                }
            }
            return;
        }
        peerConnection.connect();
        this.clients.addElement(peerConnection);
        this.generateEvent(2, string);
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"   done");
        }
    }

    private synchronized void removeClient(String string) {
        if (string == null) {
            return;
        }
        PeerConnection peerConnection = new PeerConnection(this.group, string, 0L);
        if (!this.clients.contains(peerConnection)) {
            return;
        }
        peerConnection.close();
        this.clients.removeElement(peerConnection);
        this.generateEvent(6, string);
    }

    private void createLocalEndpoint() throws IOException {
        if (this.endpointCreated) {
            return;
        }
        try {
            this.endpoint.addListener(this.pName + this.pParam, this);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        this.endpointCreated = true;
    }

    private void deleteLocalEndpoint() {
        if (!this.endpointCreated) {
            return;
        }
        this.endpoint.removeListener(this.pName + this.pParam, this);
        this.endpointCreated = false;
    }

    private void connectToRendezVous(EndpointMessenger endpointMessenger) throws IOException {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"connectToRendezVous begins");
        }
        if (endpointMessenger == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   messenger is null");
            }
            throw new IOException("   messenger is null");
        }
        this.createLocalEndpoint();
        Message message = this.endpoint.newMessage();
        try {
            InputStream inputStream = null;
            Document document = null;
            document = this.localPeerAdv.getDocument(new MimeMediaType("text/xml"));
            inputStream = document.getStream();
            message.addElement(message.newMessageElement(ConnectRequest, new MimeMediaType("text/xml"), inputStream));
            endpointMessenger.sendMessage(message);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"connectToRendezVous failed", (Throwable)exception);
            }
            throw new IOException("connectToRendezVous failed");
        }
    }

    private void disconnectFromRendezVous(EndpointMessenger endpointMessenger) throws IOException {
        if (endpointMessenger == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   messenger is null");
            }
            throw new IOException("   messenger is null");
        }
        Message message = this.endpoint.newMessage();
        try {
            InputStream inputStream = null;
            Document document = null;
            document = this.localPeerAdv.getDocument(new MimeMediaType("text/xml"));
            inputStream = document.getStream();
            message.addElement(message.newMessageElement(DisconnectRequest, new MimeMediaType("text/xml"), inputStream));
            endpointMessenger.sendMessage(message);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"disconnectFromRendezVous failed", (Throwable)exception);
            }
            throw new IOException("disconnectFromRendezVous failed");
        }
    }

    private void processConnectRequest(Message message) {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processConnectRequest");
        }
        if (!this.isRendezVous || this.manager == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   not a rendezvous");
            }
            return;
        }
        PeerAdvertisement peerAdvertisement = null;
        try {
            MessageElement messageElement = message.getElement(ConnectRequest);
            message.removeElement(ConnectRequest);
            peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), messageElement.getStream());
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   cannot retrieve advertisment from request");
            }
            return;
        }
        if (peerAdvertisement == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   advertisement is null");
            }
            return;
        }
        long l = this.manager.requestConnection(peerAdvertisement);
        if (!this.sendReply(peerAdvertisement.getPeerID().toString(), peerAdvertisement, l)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("processConnectRequest. Cannot reach client " + peerAdvertisement.getPeerID()));
            }
            return;
        }
        if (l != 0L) {
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  addClient");
            }
            this.addClient(peerAdvertisement.getPeerID().toString(), l);
        }
    }

    private void processDisconnectRequest(Message message) {
        if (!this.isRendezVous || this.manager == null) {
            return;
        }
        PeerAdvertisement peerAdvertisement = null;
        try {
            peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), message.getElement(DisconnectRequest).getStream());
        }
        catch (Exception exception) {
            return;
        }
        if (peerAdvertisement == null) {
            return;
        }
        this.removeClient(peerAdvertisement.getPeerID().toString());
    }

    private void processConnectedReply(Message message) {
        Object object;
        Object object2;
        block28: {
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processConnectedReply");
            }
            boolean bl = false;
            InputStream inputStream = message.getElement(ConnectedRdvAdvReply).getStream();
            Advertisement advertisement = null;
            if (inputStream != null) {
                try {
                    advertisement = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), inputStream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (advertisement == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   no advertisement");
                }
            } else {
                this.publishInParentGroup(advertisement);
                try {
                    this.group.getDiscoveryService().publish(advertisement, 0, 0x6DDD00L, 0x6DDD00L);
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block28;
                    LOG.debug((Object)("   publish failed with " + exception));
                }
            }
        }
        long l = 0L;
        try {
            object2 = message.getElement(ConnectedLeaseReply);
            if (object2 == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"missing lease");
                }
                return;
            }
            object = ((MessageElement)object2).getBytesOffset();
            int n = ((MessageElement)object2).getOffset();
            int n2 = ((MessageElement)object2).getLength();
            l = Long.parseLong(new String((byte[])object, n, n2));
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("lease=" + l));
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)(" leased failed with " + exception));
            }
            return;
        }
        object2 = null;
        try {
            object = message.getElement(ConnectedPeerReply);
            if (object == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"missing rdv peer");
                }
                return;
            }
            byte[] byArray = ((MessageElement)object).getBytesOffset();
            object2 = new String(((MessageElement)object).getBytesOffset(), ((MessageElement)object).getOffset(), ((MessageElement)object).getLength());
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("peer=" + (String)object2));
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  getting peer failed with " + exception));
            }
            return;
        }
        object = null;
        try {
            object = (PeerID)IDFactory.fromURL(new URL((String)object2));
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   getting peer advertisement failed with " + exception));
            }
            return;
        }
        if (l == 0L) {
            if (this.monitor != null) {
                this.monitor.disconnected((PeerID)object);
            }
        } else {
            this.addRdv((String)object2, l);
            if (this.monitor != null) {
                this.monitor.connected((PeerID)object, l);
            }
        }
    }

    private void processRdvAdvReply(Message message) {
        if (this.monitor == null) {
            return;
        }
        Advertisement advertisement = null;
        try {
            advertisement = AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), message.getElement(RdvAdvReply).getStream());
        }
        catch (Exception exception) {
            return;
        }
        if (advertisement == null) {
            return;
        }
        this.monitor.discovered(advertisement);
    }

    private boolean sendReply(String string, Advertisement advertisement, long l) {
        EndpointAddress endpointAddress;
        block17: {
            this.localPeerAdv = this.group.getPeerAdvertisement();
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendReply");
            }
            try {
                this.group.getDiscoveryService().publish(advertisement, 0, 0x6DDD00L, 0x6DDD00L);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block17;
                LOG.debug((Object)("   publish failed with " + exception));
            }
        }
        this.publishInParentGroup(advertisement);
        try {
            endpointAddress = this.mkAddress(string, this.pName, this.pParam);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)(" malformed peer id " + string));
            }
            return false;
        }
        if (!this.endpoint.ping(endpointAddress)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   cannot get route to peer " + endpointAddress));
            }
            return false;
        }
        EndpointMessenger endpointMessenger = null;
        try {
            endpointMessenger = this.endpoint.getMessenger(endpointAddress);
            if (endpointMessenger == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"    no messenger");
                }
                return false;
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("   getting messenger failed with " + exception));
            }
            return false;
        }
        Message message = this.endpoint.newMessage();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.localPeerId.getBytes());
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(Long.toString(l).getBytes());
        try {
            InputStream inputStream = null;
            Document document = null;
            document = this.localPeerAdv.getDocument(new MimeMediaType("text/xml"));
            inputStream = document.getStream();
            message.addElement(message.newMessageElement(ConnectedRdvAdvReply, new MimeMediaType("text/xml"), inputStream));
            message.setString(ConnectedPeerReply, this.localPeerId);
            message.setString(ConnectedLeaseReply, Long.toString(l));
            endpointMessenger.sendMessage(message);
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"   message sent");
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("  failed with " + exception));
            }
            return false;
        }
        return true;
    }

    private void sendToNetwork(Message message, String string, String string2) {
        block2: {
            try {
                this.endpoint.propagate(message, string, string2);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block2;
                LOG.debug((Object)exception.toString());
            }
        }
    }

    private void sendToEachClient(Message message, String string, String string2) {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sendToEachClient");
        }
        if (!this.isRendezVous || this.clients == null || this.clients.size() == 0) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  no clients");
            }
            return;
        }
        int n = this.clients.size() - 1;
        while (n >= 0) {
            block10: {
                PeerConnection peerConnection = null;
                try {
                    peerConnection = (PeerConnection)this.clients.elementAt(n);
                    if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("to: " + peerConnection.getPeer()));
                    }
                    if (!this.isPeerInPropHeader(message, peerConnection.getPeer())) {
                        Message message2 = (Message)message.clone();
                        peerConnection.sendMessage(message2, string, string2);
                        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("   sent to " + peerConnection.getPeer()));
                        }
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block10;
                    LOG.debug((Object)("   failed sent to " + peerConnection.getPeer()), (Throwable)exception);
                }
            }
            --n;
        }
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"   done");
        }
    }

    private void sendToEachRendezVous(Message message, String string, String string2) {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"sendToEachRendezVous");
        }
        if (!this.isClient || this.rendezVous == null || this.rendezVous.size() == 0) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"  no rendezvous");
            }
            return;
        }
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"    Sending to all rendezvous");
        }
        int n = this.rendezVous.size() - 1;
        while (n >= 0) {
            block9: {
                try {
                    PeerConnection peerConnection = (PeerConnection)this.rendezVous.elementAt(n);
                    if (!this.isPeerInPropHeader(message, peerConnection.getPeer())) {
                        Message message2 = (Message)message.clone();
                        peerConnection.sendMessage(message2, string, string2);
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                    LOG.debug((Object)("   failed with " + exception));
                }
            }
            --n;
        }
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"     done");
        }
    }

    private void ping(String string) {
        block9: {
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("ping " + string));
            }
            EndpointMessenger endpointMessenger = null;
            try {
                endpointMessenger = this.endpoint.getMessenger(this.mkAddress(string, this.pName, this.pParam));
                if (endpointMessenger == null) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"    no messenger");
                    }
                    return;
                }
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("   getting messenger failed with " + exception));
                }
                return;
            }
            Message message = this.endpoint.newMessage();
            try {
                message.setString(PingRequest, this.localPeerId);
                endpointMessenger.sendMessage(message);
                if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"   message sent");
                }
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break block9;
                LOG.debug((Object)("  failed with " + exception));
            }
        }
    }

    private synchronized void gcClients() {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"GC CLIENTS starts");
        }
        if (this.clients == null || this.clients.size() == 0) {
            return;
        }
        PeerConnection peerConnection = null;
        int n = 0;
        while (n < this.clients.size()) {
            block12: {
                try {
                    peerConnection = (PeerConnection)this.clients.elementAt(n);
                    long l = System.currentTimeMillis();
                    if (!peerConnection.isConnected() || peerConnection.getLease() < l) {
                        if (LOG.isDebugEnabled()) {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("GC CLIENT: drop " + peerConnection.getPeer()));
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("        lease= " + peerConnection.getLease()));
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)(" current time= " + l));
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("    connected= " + peerConnection.isConnected()));
                            }
                        }
                        this.clients.removeElementAt(n);
                        peerConnection.close();
                        --n;
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block12;
                    LOG.debug((Object)("gcClient failed " + exception));
                }
            }
            ++n;
        }
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"GC RENDEZVOUS done");
        }
    }

    private synchronized void gcRdvs() {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"GC Rendezvous starts");
        }
        if (this.rendezVous == null) {
            return;
        }
        PeerConnection peerConnection = null;
        int n = 0;
        while (n < this.rendezVous.size()) {
            block12: {
                try {
                    peerConnection = (PeerConnection)this.rendezVous.elementAt(n);
                    long l = System.currentTimeMillis();
                    if (!peerConnection.isConnected() || peerConnection.getLease() < l) {
                        if (LOG.isDebugEnabled()) {
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("GC RDV: drop " + peerConnection.getPeer()));
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("        lease= " + peerConnection.getLease()));
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)(" current time= " + l));
                            }
                            if (LOG.isEnabledFor(Priority.DEBUG)) {
                                LOG.debug((Object)("    connected= " + peerConnection.isConnected()));
                            }
                        }
                        this.rendezVous.removeElementAt(n);
                        peerConnection.close();
                        this.removedRendezVous.add(peerConnection);
                        --n;
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block12;
                    LOG.debug((Object)("ping failed " + exception));
                }
            }
            ++n;
        }
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"GC RENDEZVOUS done");
        }
    }

    private void gc() {
        this.gcClients();
        this.gcRdvs();
    }

    private synchronized void clientIsConnected(String string) {
        if (this.clients == null) {
            return;
        }
        PeerConnection peerConnection = null;
        int n = 0;
        while (n < this.clients.size()) {
            try {
                peerConnection = (PeerConnection)this.clients.elementAt(n);
                if (peerConnection.getPeer().equals(string)) {
                    peerConnection.connect();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    private void processPingReply(Message message) {
        String string = message.getString(PingReply);
        this.clientIsConnected(string);
    }

    private void processPingRequest(Message message) {
        EndpointMessenger endpointMessenger = null;
        try {
            block10: {
                String string = message.getString(PingRequest);
                try {
                    endpointMessenger = this.endpoint.getMessenger(this.mkAddress(string, this.pName, this.pParam));
                    if (endpointMessenger == null) {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"    no messenger");
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)("   getting messenger failed with " + exception));
                    }
                    return;
                }
                Message message2 = this.endpoint.newMessage();
                try {
                    message2.setString(PingReply, this.localPeerId);
                    endpointMessenger.sendMessage(message2);
                    if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"   message sent");
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) break block10;
                    LOG.debug((Object)("  failed with " + exception));
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void generateEvent(int n, String string) {
        if (this.applisteners.size() > 0) {
            RendezvousEvent rendezvousEvent = new RendezvousEvent(this, n, string);
            int n2 = 0;
            while (n2 < this.applisteners.size()) {
                RendezvousListener rendezvousListener = (RendezvousListener)this.applisteners.elementAt(n2);
                rendezvousListener.rendezvousEvent(rendezvousEvent);
                ++n2;
            }
        }
    }

    private boolean updatePropHeader(Message message, int n, String string, String string2) throws IOException {
        RendezVousPropagateMessage rendezVousPropagateMessage = null;
        if (n > 10) {
            n = 10;
        }
        try {
            InputStream inputStream;
            MessageElement messageElement = message.getElement(this.headerName);
            if (messageElement != null) {
                message.removeElement(this.headerName);
            }
            MessageElement messageElement2 = null;
            messageElement2 = message.getElement("RendezVousPropagate");
            if (messageElement2 != null) {
                message.removeElement("RendezVousPropagate");
            }
            if (messageElement == null) {
                messageElement = messageElement2;
            }
            if (messageElement != null && (inputStream = messageElement.getStream()) != null) {
                rendezVousPropagateMessage = new RendezVousPropagateMessage(inputStream);
                int n2 = rendezVousPropagateMessage.getTTL();
                if (n2 > n) {
                    n2 = n;
                }
                if (n2 < 1) {
                    return false;
                }
                rendezVousPropagateMessage.setTTL(--n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rendezVousPropagateMessage == null) {
            rendezVousPropagateMessage = new RendezVousPropagateMessage();
            rendezVousPropagateMessage.setTTL(n);
            if (string == null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"No destination - discard");
                }
                return false;
            }
            rendezVousPropagateMessage.setDestSName(string);
            rendezVousPropagateMessage.setDestSParam(string2);
            rendezVousPropagateMessage.setMsgId(this.createMsgId());
            this.addMsgId(rendezVousPropagateMessage.getMsgId());
        }
        rendezVousPropagateMessage.addToPath(this.localPeerId);
        message.addElement(message.newMessageElement(this.headerName, new MimeMediaType("text/xml"), rendezVousPropagateMessage.getInputStream()));
        message.addElement(message.newMessageElement("RendezVousPropagate", new MimeMediaType("text/xml"), rendezVousPropagateMessage.getInputStream()));
        return true;
    }

    private synchronized void addMsgId(String string) {
        block6: {
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("addMsgId " + string));
            }
            if (this.isMsgIdRecorded(string)) {
                return;
            }
            if (this.msgIds.size() >= 200) {
                try {
                    if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"   remove id");
                    }
                    this.msgIds.removeElementAt(0);
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block6;
                    LOG.warn((Object)("addMsgId failed to remove oldest element: " + exception));
                }
            }
        }
        this.msgIds.addElement(string);
    }

    private synchronized boolean isMsgIdRecorded(String string) {
        boolean bl = this.msgIds.contains(string);
        if (LOG.isDebugEnabled()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"isMsgIsRecorded:");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    id= " + string));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("status= " + bl));
            }
        }
        return bl;
    }

    private String createMsgId() {
        return String.valueOf(System.currentTimeMillis());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FilterListener
    implements EndpointFilterListener {
        private Category LOG = Category.getInstance((String)(class$net$jxta$impl$rendezvous$RendezVousServiceImpl == null ? (class$net$jxta$impl$rendezvous$RendezVousServiceImpl = FilterListener.class$("net.jxta.impl.rendezvous.RendezVousServiceImpl")) : class$net$jxta$impl$rendezvous$RendezVousServiceImpl).getName());
        static /* synthetic */ Class class$net$jxta$impl$rendezvous$RendezVousServiceImpl;

        public Message processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
            block9: {
                try {
                    RendezVousPropagateMessage rendezVousPropagateMessage;
                    MessageElement messageElement = message.getElement(RendezVousServiceImpl.this.headerName);
                    if (messageElement == null) {
                        messageElement = message.getElement("RendezVousPropagate");
                    }
                    if ((rendezVousPropagateMessage = new RendezVousPropagateMessage(messageElement.getStream())).getTTL() <= 0) {
                        if (this.LOG.isDebugEnabled() && this.LOG.isEnabledFor(Priority.DEBUG)) {
                            this.LOG.debug((Object)"Dead on arrival");
                        }
                        return null;
                    }
                    if (rendezVousPropagateMessage.hasInPath(RendezVousServiceImpl.this.localPeerId)) {
                        if (this.LOG.isDebugEnabled() && this.LOG.isEnabledFor(Priority.DEBUG)) {
                            this.LOG.debug((Object)"Loopback");
                        }
                        return null;
                    }
                    if (RendezVousServiceImpl.this.isMsgIdRecorded(rendezVousPropagateMessage.getMsgId())) {
                        if (this.LOG.isDebugEnabled() && this.LOG.isEnabledFor(Priority.DEBUG)) {
                            this.LOG.debug((Object)"Feedback");
                        }
                        return null;
                    }
                }
                catch (Exception exception) {
                    if (!this.LOG.isEnabledFor(Priority.DEBUG)) break block9;
                    this.LOG.debug((Object)("Filter failed " + exception));
                }
            }
            return message;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public class GCTask
    extends TimerTask {
        RendezVousServiceImpl rendezvous = null;

        public GCTask(RendezVousServiceImpl rendezVousServiceImpl2) {
            this.rendezvous = rendezVousServiceImpl2;
        }

        public void run() {
            this.rendezvous.gc();
        }
    }

    private class PropagateListener
    implements EndpointListener {
        private RendezVousServiceImpl rdv = null;

        public PropagateListener(RendezVousServiceImpl rendezVousServiceImpl2) {
            this.rdv = rendezVousServiceImpl2;
        }

        public void processIncomingMessage(Message message, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
            MessageElement messageElement = null;
            RendezVousPropagateMessage rendezVousPropagateMessage = null;
            try {
                messageElement = message.getElement(RendezVousServiceImpl.this.headerName);
                if (messageElement == null && (messageElement = message.getElement("RendezVousPropagate")) == null) {
                    return;
                }
                rendezVousPropagateMessage = new RendezVousPropagateMessage(messageElement.getStream());
            }
            catch (Exception exception) {
                return;
            }
            if (rendezVousPropagateMessage.getMsgId() == null) {
                if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"Received a message without msgid. Drop it.");
                }
                return;
            }
            String string = rendezVousPropagateMessage.getDestSName();
            String string2 = rendezVousPropagateMessage.getDestSParam();
            this.rdv.processReceivedMessage(message, rendezVousPropagateMessage.getMsgId(), string, string2, endpointAddress, endpointAddress2);
        }
    }
}

