/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.net.URL;
import java.util.Enumeration;
import net.jxta.discovery.DiscoveryService;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.EndpointReceiveQueue;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PeerConnection
implements Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$rendezvous$PeerConnection == null ? (class$net$jxta$impl$rendezvous$PeerConnection = PeerConnection.class$("net.jxta.impl.rendezvous.PeerConnection")) : class$net$jxta$impl$rendezvous$PeerConnection).getName());
    public static final int MaxNbOfMessages = 40;
    private String peer = null;
    private String peerName = null;
    private long lease = 0L;
    private boolean connected = false;
    private EndpointService endpoint = null;
    private DiscoveryService discovery = null;
    private EndpointReceiveQueue queue = null;
    private Thread thread = null;
    static /* synthetic */ Class class$net$jxta$impl$rendezvous$PeerConnection;

    public PeerConnection(PeerGroup peerGroup, String string, long l) {
        this.peer = string;
        this.endpoint = peerGroup.getEndpointService();
        this.discovery = peerGroup.getDiscoveryService();
        this.connected = true;
        this.lease = System.currentTimeMillis() + l < 0L ? l : System.currentTimeMillis() + l;
    }

    public synchronized void connect() {
        this.connected = true;
        if (this.queue == null) {
            this.queue = new EndpointReceiveQueue();
            this.queue.setMaxNbOfMessages(40);
        }
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "RDV Connection to " + this.getPeerName());
        this.thread.start();
        Thread.currentThread();
        Thread.yield();
    }

    private synchronized void setThreadName() {
        block3: {
            if (this.thread != null) {
                try {
                    this.thread.setName("RDV Connection [queue = " + this.queue.getNbOfQueuedMessages() + " ] to " + this.getPeerName());
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                    LOG.error((Object)"Cannot change thread name", (Throwable)exception);
                }
            }
        }
    }

    public synchronized String getPeerName() {
        if (this.peerName != null) {
            return this.peerName;
        }
        try {
            Enumeration enumeration = this.discovery.getLocalAdvertisements(0, "PID", this.peer);
            if (enumeration != null && enumeration.hasMoreElements()) {
                PeerAdvertisement peerAdvertisement = (PeerAdvertisement)enumeration.nextElement();
                this.peerName = peerAdvertisement.getName();
            }
        }
        catch (Exception exception) {
            this.peerName = null;
            return this.peer;
        }
        return this.peerName;
    }

    public synchronized void setLease(long l) {
        this.lease = l;
    }

    public synchronized long getLease() {
        return this.lease;
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized void setPeer(String string) {
        this.peer = string;
    }

    public synchronized String getPeer() {
        return this.peer;
    }

    private EndpointMessenger getMessenger(String string, String string2) {
        EndpointMessenger endpointMessenger = null;
        try {
            endpointMessenger = this.endpoint.getMessenger(this.mkAddress(this.peer, string, string2));
            return endpointMessenger;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void doSendMessage(Message message) {
        String string;
        if (!this.isConnected()) {
            return;
        }
        EndpointAddress endpointAddress = message.getDestinationAddress();
        String string2 = endpointAddress.getServiceName();
        EndpointMessenger endpointMessenger = this.getMessenger(string2, string = endpointAddress.getServiceParameter());
        if (endpointMessenger == null) {
            this.notifyFailure();
            return;
        }
        try {
            endpointMessenger.sendMessage(message);
        }
        catch (Exception exception) {
            this.notifyFailure();
        }
    }

    public void sendMessage(Message message, String string, String string2) {
        if (!this.isConnected()) {
            return;
        }
        EndpointAddress endpointAddress = message.getDestinationAddress();
        if (endpointAddress != null) {
            endpointAddress.setServiceName(string);
            endpointAddress.setServiceParameter(string2);
        } else {
            endpointAddress = this.mkAddress(this.peer, string, string2);
        }
        message.setDestinationAddress(endpointAddress);
        PeerConnection peerConnection = this;
        synchronized (peerConnection) {
            this.queue.push(message);
            this.setThreadName();
        }
    }

    private EndpointAddress mkAddress(String string) {
        try {
            PeerID peerID = (PeerID)IDFactory.fromURL(new URL(string));
            String string2 = "jxta://" + peerID.getUniqueValue().toString();
            EndpointAddress endpointAddress = this.endpoint.newEndpointAddress(string2);
            return endpointAddress;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("Invalid peerID string " + string));
            }
            return null;
        }
    }

    private EndpointAddress mkAddress(String string, String string2, String string3) {
        EndpointAddress endpointAddress = this.mkAddress(string);
        endpointAddress.setServiceName(string2);
        endpointAddress.setServiceParameter(string3);
        return endpointAddress;
    }

    public boolean equals(Object object) {
        return this.peer.equals(((PeerConnection)object).peer);
    }

    public void run() {
        Message message = null;
        while (true) {
            if (!this.isConnected()) {
                this.close();
                return;
            }
            try {
                message = this.queue.waitForMessage();
                this.setThreadName();
            }
            catch (InterruptedException interruptedException) {
                if (!this.isConnected()) {
                    this.close();
                    return;
                }
                this.notifyFailure();
                continue;
            }
            this.doSendMessage(message);
        }
    }

    private synchronized void notifyFailure() {
        this.close();
        this.connected = false;
    }

    public synchronized void close() {
        block4: {
            this.connected = false;
            if (this.queue != null) {
                this.queue.close();
                this.queue = null;
            }
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread = null;
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                    LOG.warn((Object)("Cannot interrupt RDV thread for " + this.getPeerName()), (Throwable)exception);
                }
            }
        }
    }

    public void finalize() {
        this.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

