/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.relay;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.EndpointService;
import net.jxta.id.ID;
import net.jxta.impl.relay.RelayLease;
import net.jxta.impl.relay.RelayLeaseException;
import net.jxta.impl.util.Base64;
import net.jxta.impl.util.BoundedQueue;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class RelayServer {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$relay$RelayServer == null ? (class$net$jxta$impl$relay$RelayServer = RelayServer.class$("net.jxta.impl.relay.RelayServer")) : class$net$jxta$impl$relay$RelayServer).getName());
    private static Timer timer = new Timer();
    private static final String LEASE_LEN_KEY = "RelayServer.LeaseLength";
    private int leaseLength = 1800000;
    private SecureRandom random = null;
    private EndpointService endpoint = null;
    private HashMap leaseMap = new HashMap();
    private HashMap queueMap = new HashMap();
    private HashMap expirationTaskMap = new HashMap();
    private HashMap peerIdToLeaseIdMap = new HashMap();
    static /* synthetic */ Class class$net$jxta$impl$relay$RelayServer;

    public ID getPeerID() {
        return this.endpoint.getGroup().getPeerID();
    }

    public RelayServer(EndpointService endpointService, Properties properties) {
        this.endpoint = endpointService;
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (LOG.isEnabledFor(Priority.ERROR)) {
                LOG.error((Object)"RelayServer does not have SHA1PRNG crypto algorithm");
            }
            throw new RuntimeException("RelayServer does not have SHA1PRNG crypto algorithm");
        }
        if (properties != null) {
            String string = properties.getProperty(LEASE_LEN_KEY);
            if (string != null) {
                try {
                    this.leaseLength = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Illegal value specified for RelayServer.LeaseLength");
                    }
                }
            } else if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"Using default value for lease length");
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("lease length = " + this.leaseLength));
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"Generating initial lease key");
        }
        this.generateLeaseId();
    }

    public synchronized RelayLease issueNewLease(String string) {
        Object var2_2 = null;
        String string2 = (String)this.peerIdToLeaseIdMap.get(string);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("issuing new lease for " + string));
        }
        if (string2 != null && LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("Peer " + string + " already has a lease"));
        }
        return this.newLease(string, string2);
    }

    public synchronized RelayLease renewLease(String string) throws RelayLeaseException {
        RelayLease relayLease;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("attempting to renew lease " + string));
        }
        if ((relayLease = (RelayLease)this.leaseMap.get(string)) == null || !relayLease.isValid()) {
            throw new RelayLeaseException("Existing lease is not valid");
        }
        String string2 = relayLease.getPeerId();
        return this.newLease(string2, string);
    }

    private RelayLease newLease(String string, String string2) {
        Object object;
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("making lease for peer " + string + " with lease " + (string2 == null ? "(none)" : string2)));
        }
        BoundedQueue boundedQueue = null;
        this.peerIdToLeaseIdMap.remove(string);
        if (string2 != null) {
            this.leaseMap.remove(string2);
            boundedQueue = (BoundedQueue)this.queueMap.remove(string2);
            object = (TimerTask)this.expirationTaskMap.get(string2);
            if (object != null) {
                ((TimerTask)object).cancel();
            }
            this.expirationTaskMap.remove(string2);
        } else {
            boundedQueue = new BoundedQueue(32);
        }
        object = this.generateLeaseId();
        RelayLease relayLease = new RelayLease(string, (String)object, this.leaseLength);
        this.leaseMap.put(object, relayLease);
        this.peerIdToLeaseIdMap.put(string, object);
        this.queueMap.put(object, boundedQueue);
        LeaseExpirationTask leaseExpirationTask = new LeaseExpirationTask((String)object, this);
        this.expirationTaskMap.put(object, leaseExpirationTask);
        timer.schedule((TimerTask)leaseExpirationTask, this.leaseLength);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("peer " + string + " new lease id = " + (String)object));
        }
        return relayLease;
    }

    public synchronized boolean hasLease(String string) {
        String string2 = (String)this.peerIdToLeaseIdMap.get(string);
        if (string2 != null) {
            RelayLease relayLease = null;
            relayLease = (RelayLease)this.leaseMap.get(string2);
            if (relayLease != null && relayLease.isValid()) {
                return true;
            }
        }
        return false;
    }

    public synchronized BoundedQueue getOutboundMessageQueueByPeerId(String string) {
        String string2 = (String)this.peerIdToLeaseIdMap.get(string);
        if (string2 != null) {
            return (BoundedQueue)this.queueMap.get(string2);
        }
        return null;
    }

    public synchronized BoundedQueue getOutboundMessageQueueByLeaseId(String string) {
        return (BoundedQueue)this.queueMap.get(string);
    }

    private String generateLeaseId() {
        byte[] byArray = new byte[16];
        this.random.nextBytes(byArray);
        return new String(Base64.encodeBase64(byArray));
    }

    protected void removeLease(String string) {
        BoundedQueue boundedQueue = null;
        RelayServer relayServer = this;
        synchronized (relayServer) {
            RelayLease relayLease = null;
            relayLease = (RelayLease)this.leaseMap.get(string);
            this.leaseMap.remove(string);
            this.peerIdToLeaseIdMap.remove(relayLease.getPeerId());
            this.expirationTaskMap.remove(string);
            boundedQueue = (BoundedQueue)this.queueMap.get(string);
            this.queueMap.remove(string);
        }
        if (boundedQueue != null) {
            boundedQueue.clear();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LeaseExpirationTask
    extends TimerTask {
        String leaseId = null;
        RelayServer relayServer = null;

        LeaseExpirationTask(String string, RelayServer relayServer2) {
            this.leaseId = string;
            this.relayServer = relayServer2;
        }

        public void run() {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("expiring lease: " + this.leaseId));
            }
            this.relayServer.removeLease(this.leaseId);
        }
    }
}

