/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.ResolverQueryMsg;
import org.apache.log4j.Category;

public class ResolverQuery
extends ResolverQueryMsg {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$protocol$ResolverQuery == null ? (class$net$jxta$impl$protocol$ResolverQuery = ResolverQuery.class$("net.jxta.impl.protocol.ResolverQuery")) : class$net$jxta$impl$protocol$ResolverQuery).getName());
    private static final String handlernameTag = "HandlerName";
    private static final String credentialTag = "Credential";
    private static final String queryIdTag = "QueryID";
    private static final String srcPeerIdTag = "SrcPeerID";
    private static final String queryTag = "Query";
    static /* synthetic */ Class class$net$jxta$impl$protocol$ResolverQuery;

    public ResolverQuery(InputStream inputStream) throws IOException {
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), inputStream);
        this.readIt(structuredTextDocument);
    }

    public ResolverQuery(TextElement textElement) {
        if (!ResolverQueryMsg.getAdvertisementType().equals(textElement.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + textElement.getName());
        }
        this.readIt(textElement);
    }

    public void readIt(TextElement textElement) {
        Enumeration enumeration = textElement.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement textElement2 = (TextElement)enumeration.nextElement();
            if (textElement2.getName().equals(handlernameTag)) {
                this.setHandlerName(textElement2.getTextValue());
                continue;
            }
            if (textElement2.getName().equals(credentialTag)) {
                this.setCredential(textElement2.getTextValue());
                continue;
            }
            if (textElement2.getName().equals(queryIdTag)) {
                this.queryid = Integer.parseInt(textElement2.getTextValue());
                continue;
            }
            if (textElement2.getName().equals(srcPeerIdTag)) {
                this.setSrc(textElement2.getTextValue());
                continue;
            }
            if (!textElement2.getName().equals(queryTag)) continue;
            this.setQuery(textElement2.getTextValue());
        }
    }

    public ResolverQuery(String string, String string2, String string3, String string4, int n) {
        this.setHandlerName(string);
        this.setCredential(string2);
        this.setQueryId(n);
        this.setSrc(string3);
        this.setQuery(string4);
    }

    public Document getDocument(MimeMediaType mimeMediaType) throws Exception {
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, ResolverQueryMsg.getAdvertisementType());
        TextElement textElement = structuredTextDocument.createElement(handlernameTag, this.getHandlerName());
        structuredTextDocument.appendChild((Element)textElement);
        textElement = structuredTextDocument.createElement(credentialTag, this.getCredential());
        structuredTextDocument.appendChild((Element)textElement);
        textElement = structuredTextDocument.createElement(queryIdTag, Integer.toString(this.queryid));
        structuredTextDocument.appendChild((Element)textElement);
        textElement = structuredTextDocument.createElement(srcPeerIdTag, this.getSrc());
        structuredTextDocument.appendChild((Element)textElement);
        textElement = structuredTextDocument.createElement(queryTag, this.getQuery());
        structuredTextDocument.appendChild((Element)textElement);
        return structuredTextDocument;
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)this.getDocument(new MimeMediaType("text/xml"));
            structuredTextDocument.sendToWriter(stringWriter);
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception exception) {
            LOG.debug((Object)"Could not generate ResolverQuery");
            return "";
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

