/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.protocol.DiscoveryResponseMsg;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class DiscoveryResponse
extends DiscoveryResponseMsg {
    private static final String countTag = "Count";
    private static final String typeTag = "Type";
    private static final String peerAdvTag = "PeerAdv";
    private static final String responsesTag = "Response";
    private static final String expirationTag = "Expiration";
    private static final String queryAttrTag = "Attr";
    private static final String queryValueTag = "Value";
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$protocol$DiscoveryResponse == null ? (class$net$jxta$impl$protocol$DiscoveryResponse = DiscoveryResponse.class$("net.jxta.impl.protocol.DiscoveryResponse")) : class$net$jxta$impl$protocol$DiscoveryResponse).getName());
    static /* synthetic */ Class class$net$jxta$impl$protocol$DiscoveryResponse;

    public DiscoveryResponse(InputStream inputStream) throws IOException {
        StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text", "xml"), inputStream);
        this.readIt(structuredTextDocument);
    }

    public DiscoveryResponse(TextElement textElement) {
        if (!DiscoveryResponseMsg.getAdvertisementType().equals(textElement.getName())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + " from doc containing a " + textElement.getName());
        }
        this.readIt(textElement);
    }

    public void readIt(TextElement textElement) {
        Vector<Long> vector;
        Vector<Object> vector2;
        block12: {
            vector2 = new Vector<Object>();
            vector = new Vector<Long>();
            try {
                vector2.removeAllElements();
                Enumeration enumeration = textElement.getChildren();
                while (enumeration.hasMoreElements()) {
                    long l;
                    TextElement textElement2 = (TextElement)enumeration.nextElement();
                    if (textElement2.getName().equals(countTag)) {
                        this.count = Integer.parseInt(textElement2.getTextValue());
                        continue;
                    }
                    if (textElement2.getName().equals(typeTag)) {
                        this.type = Integer.parseInt(textElement2.getTextValue());
                        continue;
                    }
                    if (textElement2.getName().equals(peerAdvTag)) {
                        this.setPeerAdv(textElement2.getTextValue());
                        continue;
                    }
                    if (textElement2.getName().equals(queryAttrTag)) {
                        this.setQueryAttr(textElement2.getTextValue());
                        continue;
                    }
                    if (textElement2.getName().equals(queryValueTag)) {
                        this.setQueryValue(textElement2.getTextValue());
                        continue;
                    }
                    if (!textElement2.getName().equals(responsesTag)) continue;
                    vector2.addElement(textElement2.getValue());
                    Attribute attribute = ((Attributable)((Object)textElement2)).getAttribute(expirationTag);
                    if (null == attribute) {
                        vector.addElement(new Long(0x6DDD00L));
                        continue;
                    }
                    String string = attribute.getValue();
                    if (null != string) {
                        l = Long.parseLong(string);
                    } else {
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)"Received an old-style DiscoveryResponse.\n You received a response from a peer that does \nnot support advertisement aging. \nSetting expiration to DiscoveryService.DEFAULT_EXPIRATION ");
                        }
                        l = 0x6DDD00L;
                    }
                    vector.addElement(new Long(l));
                }
            }
            catch (Exception exception) {
                if (!LOG.isDebugEnabled() || !LOG.isEnabledFor(Priority.DEBUG)) break block12;
                LOG.debug((Object)"Got an Exception during Parse ", (Throwable)exception);
            }
        }
        this.setResponses(vector2);
        this.setExpirations(vector);
    }

    public DiscoveryResponse(int n, int n2, String string, String string2, String string3, Vector vector, Vector vector2) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("DiscoveryResponse.<init>:  response count = " + vector.size()));
        }
        this.setResponseCount(n);
        this.setDiscoveryType(n2);
        this.setPeerAdv(string);
        this.setQueryAttr(string2);
        this.setQueryValue(string3);
        this.setResponses(vector);
        this.setExpirations(vector2);
    }

    public Document getDocument(MimeMediaType mimeMediaType) throws Exception {
        StructuredTextDocument structuredTextDocument;
        block3: {
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, DiscoveryResponseMsg.getAdvertisementType());
            TextElement textElement = structuredTextDocument.createElement(countTag, Integer.toString(this.count));
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(typeTag, Integer.toString(this.type));
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(peerAdvTag, this.getPeerAdv());
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(queryAttrTag, this.getQueryAttr());
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(queryValueTag, this.getQueryValue());
            structuredTextDocument.appendChild((Element)textElement);
            Enumeration enumeration = this.getResponses();
            Enumeration enumeration2 = this.getExpirations();
            try {
                while (enumeration.hasMoreElements()) {
                    Long l = (Long)enumeration2.nextElement();
                    textElement = structuredTextDocument.createElement(responsesTag, (String)enumeration.nextElement());
                    structuredTextDocument.appendChild((Element)textElement);
                    ((Attributable)((Object)textElement)).addAttribute(expirationTag, l.toString());
                }
            }
            catch (Exception exception) {
                if (!LOG.isDebugEnabled() || !LOG.isEnabledFor(Priority.DEBUG)) break block3;
                LOG.debug((Object)"Got an Exception during doc creation ", (Throwable)exception);
            }
        }
        return structuredTextDocument;
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)this.getDocument(new MimeMediaType("text/xml"));
            structuredTextDocument.sendToWriter(stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Got an Exception during Parse ", (Throwable)exception);
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

