/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.DiscardQueryException;
import net.jxta.exception.NoResponseException;
import net.jxta.exception.ResendQueryException;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.util.JxtaTimer;
import net.jxta.impl.util.JxtaTimerHandler;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.InputPipe;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class PipeResolver
implements JxtaTimerHandler,
QueryHandler {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$pipe$PipeResolver == null ? (class$net$jxta$impl$pipe$PipeResolver = PipeResolver.class$("net.jxta.impl.pipe.PipeResolver")) : class$net$jxta$impl$pipe$PipeResolver).getName());
    private static final String PipeResolverName = "JxtaPipeResolver";
    private static final String MsgTypeTag = "MsgType";
    private static final String PipeIdTag = "PipeId";
    private static final String TypeTag = "Type";
    private static final String PeerIdTag = "Peer";
    private static final String CachedTag = "Cached";
    private static final String PeerAdvTag = "PeerAdv";
    private static final String FoundTag = "Found";
    private static final String QueryMsgType = "Query";
    private static final String AnswerMsgType = "Answer";
    private static long DefaultPipeLease = 3600000L;
    private static long GcDelay = 600000L;
    private static int qid = 0;
    private ResolverService resolver = null;
    private Hashtable pipes = null;
    private Hashtable cachedPipes = null;
    private Vector localAddrs = null;
    private RefPeerGroup myGroup = null;
    private EndpointService endpoint = null;
    private DiscoveryService discovery = null;
    private String localPeerId = null;
    private JxtaTimer gcTimer = null;
    private Hashtable listeners = new Hashtable();
    static /* synthetic */ Class class$net$jxta$impl$pipe$PipeResolver;

    public PipeResolver(PeerGroup peerGroup) {
        this.myGroup = (RefPeerGroup)peerGroup;
        this.localPeerId = this.myGroup.getPeerID().toString();
        this.endpoint = this.myGroup.getEndpointService();
        this.pipes = new Hashtable();
        this.cachedPipes = new Hashtable();
        this.resolver = peerGroup.getResolverService();
        this.discovery = this.myGroup.getDiscoveryService();
        this.resolver.registerHandler(PipeResolverName, this);
        this.gcTimer = new JxtaTimer(this, GcDelay, true);
    }

    protected void stop() {
        this.resolver.unregisterHandler(PipeResolverName);
    }

    public void registerCached(String string, String string2) {
        if (LOG.isDebugEnabled()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"registerCached:");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("      Id = " + string));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    peer = " + string2));
            }
        }
        PipeEntry pipeEntry = null;
        if (this.cachedPipes.containsKey(string)) {
            pipeEntry = (PipeEntry)this.cachedPipes.get(string);
            if (pipeEntry != null) {
                pipeEntry.peer = string2;
                this.resetLease(pipeEntry);
            } else if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"registerCached. unexpected null pointer");
            }
            return;
        }
        pipeEntry = new PipeEntry(string2);
        this.resetLease(pipeEntry);
        try {
            PipeEntry pipeEntry2 = this.cachedPipes.put(string, pipeEntry);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("registerCached failed " + exception));
            }
            return;
        }
        this.notifyWaitingThreads();
    }

    public void register(String string, InputPipe inputPipe) {
        if (LOG.isDebugEnabled() && LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("register " + string));
        }
        try {
            InputPipe inputPipe2 = this.pipes.put(string, inputPipe);
        }
        catch (Exception exception) {
            return;
        }
        this.notifyWaitingThreads();
    }

    public void forget(String string) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("forget " + string));
        }
        Object v = this.pipes.remove(string);
    }

    public void forgetCached(String string) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("forgetCached " + string));
        }
        Object v = this.cachedPipes.remove(string);
    }

    public String findLocal(String string) {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("findLocal " + string));
        }
        String string2 = null;
        Object v = this.pipes.get(string);
        if (v != null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("findLocal: found local InputPipe for " + string));
            }
            return this.localPeerId;
        }
        string2 = this.findCached(string);
        return string2;
    }

    public String find(PipeAdvertisement pipeAdvertisement, long l, boolean bl) {
        String string;
        String string2 = pipeAdvertisement.getPipeID().toString();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("find " + string2));
        }
        if ((string = this.findLocal(string2)) == null) {
            Object var7_6 = null;
            string = this.findRemote(pipeAdvertisement, l, bl);
            return string;
        }
        if (this.listeners.containsKey(string2)) {
            Event event = new Event(this, string, string2, "JxtaUnicast", 0);
            Listener listener = (Listener)this.listeners.get(string2);
            listener.pipeResolverEvent(event);
        }
        return string;
    }

    public void sendVerify(String string, String string2, String string3) {
        if (LOG.isDebugEnabled()) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendVerify:");
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    pipe= " + string2));
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("    peer= " + string));
            }
        }
        try {
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:PipeResolver");
            TextElement textElement = null;
            textElement = structuredTextDocument.createElement(MsgTypeTag, QueryMsgType);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(PipeIdTag, string2);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(TypeTag, string3);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(PeerIdTag, string);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(CachedTag, "false");
            structuredTextDocument.appendChild((Element)textElement);
            StringWriter stringWriter = new StringWriter();
            structuredTextDocument.sendToWriter(stringWriter);
            ResolverQuery resolverQuery = new ResolverQuery(PipeResolverName, null, this.localPeerId, stringWriter.toString(), qid++);
            this.resolver.sendQuery(string, resolverQuery);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("sendVerify failed with " + exception));
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void processResponse(ResolverResponseMsg var1_1) {
        if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
            PipeResolver.LOG.debug((Object)"processResponse got a response");
        }
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = null;
        try {
            var4_4 = new MimeMediaType("text/xml");
        }
        catch (RuntimeException var8_8) {
            if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
                PipeResolver.LOG.debug((Object)("processResponse: cannot get MimeMediaType " + var8_8));
            }
            return;
        }
        var8_9 = new ByteArrayInputStream(var1_1.getResponse().getBytes());
        var9_10 = null;
        try {
            var9_10 = StructuredDocumentFactory.newStructuredDocument(var4_4, var8_9);
        }
        catch (Exception var10_11) {
            if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
                PipeResolver.LOG.debug((Object)"processResponse: malformed response - discard");
            }
            return;
        }
        var2_2 = var9_10.getChildren();
        var10_12 = new Vector<Object>();
        var11_13 = true;
        while (var2_2.hasMoreElements()) {
            var12_14 = (TextElement)var2_2.nextElement();
            if (var12_14.getName().equals("Peer")) {
                var10_12.addElement(var12_14.getValue());
                continue;
            }
            if (var12_14.getName().equals("PipeId")) {
                var5_5 = (String)var12_14.getValue();
                continue;
            }
            if (var12_14.getName().equals("Type")) {
                var6_6 = (String)var12_14.getValue();
                continue;
            }
            if (var12_14.getName().equals("Found")) {
                var11_13 = ((String)var12_14.getValue()).equals("true");
                continue;
            }
            if (!var12_14.getName().equals("PeerAdv")) continue;
            var7_7 = (String)var12_14.getValue();
            this.saveAdv(var7_7);
        }
        if (var5_5 == null || var10_12.size() == 0) {
            if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
                PipeResolver.LOG.debug((Object)"processResponse: malformed response - discard.");
            }
            return;
        }
        if (var6_6 == null) {
            if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
                PipeResolver.LOG.debug((Object)"processResponse: no type - using UnicastType as default");
            }
            var6_6 = "JxtaUnicast";
        }
        if ((var2_2 = var10_12.elements()) != null) ** GOTO lbl69
        if (PipeResolver.LOG.isEnabledFor(Priority.DEBUG)) {
            PipeResolver.LOG.debug((Object)"processResponse: empty response");
        }
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = (String)var2_2.nextElement();
            if (!var11_13) {
                var12_14 = this.findLocal(var5_5);
                if (var12_14 == null || !var12_14.equals(var3_3)) continue;
                this.forgetCached(var5_5);
                return;
            }
            this.registerCached(var5_5, var3_3);
            if (!this.listeners.containsKey(var5_5)) continue;
            var12_14 = new Event(this, var3_3, var5_5, var6_6, var1_1.getQueryId());
            var13_15 = (Listener)this.listeners.get(var5_5);
            var13_15.pipeResolverEvent((Event)var12_14);
lbl69:
            // 4 sources

            ** while (var2_2.hasMoreElements())
        }
lbl70:
        // 1 sources

    }

    public ResolverResponseMsg processQuery(ResolverQueryMsg resolverQueryMsg) throws NoResponseException, DiscardQueryException, IOException, ResendQueryException {
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"processQuery starts");
        }
        MimeMediaType mimeMediaType = null;
        mimeMediaType = new MimeMediaType("text/xml");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(resolverQueryMsg.getQuery().getBytes());
        StructuredTextDocument structuredTextDocument = null;
        try {
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(mimeMediaType, byteArrayInputStream);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: malformed request ", (Throwable)exception);
            }
            throw new IOException("processQuery: malformed request ");
        }
        String string = null;
        boolean bl = true;
        String string2 = null;
        String string3 = null;
        Enumeration enumeration = structuredTextDocument.getChildren();
        while (enumeration.hasMoreElements()) {
            TextElement textElement = (TextElement)enumeration.nextElement();
            if (textElement.getName().equals(PipeIdTag)) {
                string = (String)textElement.getValue();
                continue;
            }
            if (textElement.getName().equals(PeerIdTag)) {
                string2 = (String)textElement.getValue();
                continue;
            }
            if (textElement.getName().equals(TypeTag)) {
                string3 = (String)textElement.getValue();
                continue;
            }
            if (!textElement.getName().equals(CachedTag)) continue;
            bl = ((String)textElement.getValue()).equals("true");
        }
        if (string == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: malformed request, no PipeId.");
            }
            throw new IOException();
        }
        if (string3 == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: type is null, discarded.");
            }
            throw new DiscardQueryException("processQuery: type is null, discarded.");
        }
        if (string2 != null && !string2.equals(this.localPeerId)) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: request not for this peer, discarded.");
            }
            throw new DiscardQueryException("processQuery: request not for this peer, discarded.");
        }
        int n = resolverQueryMsg.getQueryId();
        String string4 = null;
        string4 = !bl ? (this.pipes.get(string) != null ? this.localPeerId : null) : this.findLocal(string);
        if (string4 == null && string2 == null) {
            if (this.myGroup.isRendezvous()) {
                throw new NoResponseException();
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: message discarded.");
            }
            throw new DiscardQueryException("processQuery: message discarded.");
        }
        try {
            Object object;
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:PipeResolver");
            TextElement textElement = null;
            textElement = structuredTextDocument.createElement(MsgTypeTag, AnswerMsgType);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(PipeIdTag, string);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(TypeTag, string3);
            structuredTextDocument.appendChild((Element)textElement);
            if (string4 == null) {
                textElement = structuredTextDocument.createElement(PeerIdTag, this.localPeerId);
                structuredTextDocument.appendChild((Element)textElement);
                textElement = structuredTextDocument.createElement(FoundTag, "false");
                structuredTextDocument.appendChild((Element)textElement);
            } else {
                textElement = structuredTextDocument.createElement(PeerIdTag, string4);
                structuredTextDocument.appendChild((Element)textElement);
                object = this.advString(string4);
                if (object != null) {
                    textElement = structuredTextDocument.createElement(PeerAdvTag, (String)object);
                    structuredTextDocument.appendChild((Element)textElement);
                }
            }
            object = new StringWriter();
            structuredTextDocument.sendToWriter((Writer)object);
            ResolverResponse resolverResponse = new ResolverResponse(PipeResolverName, null, n, ((StringWriter)object).toString());
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: sending answer.");
            }
            return resolverResponse;
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"processQuery: error while processing query:", (Throwable)exception);
            }
            throw new IOException(exception.toString());
        }
    }

    public void signal(JxtaTimer jxtaTimer) {
        this.refreshCachedPipes();
    }

    private void resetLease(PipeEntry pipeEntry) {
        if (pipeEntry == null) {
            return;
        }
        long l = System.currentTimeMillis();
        pipeEntry.lease = l + DefaultPipeLease;
    }

    private synchronized void refreshCachedPipes() {
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.cachedPipes.keys();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return;
        }
        PipeEntry pipeEntry = null;
        String string = null;
        while (enumeration.hasMoreElements()) {
            try {
                string = (String)enumeration.nextElement();
                pipeEntry = (PipeEntry)this.cachedPipes.get(string);
                if (pipeEntry == null) {
                    if (!LOG.isEnabledFor(Priority.DEBUG)) continue;
                    LOG.debug((Object)("refreshCachedPipe: empty entry for pipe " + string));
                    continue;
                }
                if (pipeEntry.lease >= l) continue;
                this.cachedPipes.remove(string);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.DEBUG)) break;
                LOG.debug((Object)("refreshCachedPipe: " + exception));
                break;
            }
        }
    }

    private String findCached(String string) {
        PipeEntry pipeEntry = (PipeEntry)this.cachedPipes.get(string);
        if (pipeEntry == null) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("findCached did not find " + string));
            }
            return null;
        }
        this.resetLease(pipeEntry);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("findCached found" + string));
        }
        return pipeEntry.peer;
    }

    private String findRemote(PipeAdvertisement pipeAdvertisement, long l, boolean bl) {
        Object object;
        String string = pipeAdvertisement.getPipeID().toString();
        String string2 = pipeAdvertisement.getType();
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("findRemote " + string));
        }
        try {
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:PipeResolver");
            TextElement textElement = null;
            textElement = structuredTextDocument.createElement(MsgTypeTag, QueryMsgType);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(PipeIdTag, string);
            structuredTextDocument.appendChild((Element)textElement);
            textElement = structuredTextDocument.createElement(TypeTag, string2);
            structuredTextDocument.appendChild((Element)textElement);
            if (bl) {
                textElement = structuredTextDocument.createElement(CachedTag, "false");
                structuredTextDocument.appendChild((Element)textElement);
            }
            object = new StringWriter();
            structuredTextDocument.sendToWriter((Writer)object);
            ResolverQuery resolverQuery = new ResolverQuery(PipeResolverName, null, this.localPeerId, ((StringWriter)object).toString(), qid++);
            this.resolver.sendQuery(null, resolverQuery);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)("findRemote failed with " + exception));
            }
            return null;
        }
        if (l == 0L) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"findRemote no timeout");
            }
            return null;
        }
        long l2 = System.currentTimeMillis() + l;
        object = null;
        while (true) {
            if ((object = this.findLocal(string)) != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("findRemote found " + (String)object));
                }
                return object;
            }
            object = this.findCached(string);
            if (object != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("findRemote found " + (String)object));
                }
                return object;
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"findRemote waiting...");
            }
            if (l < 0L) {
                this.goWait(Long.MAX_VALUE);
                continue;
            }
            long l3 = l2 - System.currentTimeMillis();
            if (l3 <= 0L) break;
            this.goWait(l3);
        }
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)"findRemote timeout.");
        }
        return null;
    }

    private synchronized void goWait(long l) {
        try {
            this.wait(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void notifyWaitingThreads() {
        this.notifyAll();
    }

    private String advString(String string) {
        Enumeration enumeration;
        DiscoveryService discoveryService = this.myGroup.getDiscoveryService();
        try {
            enumeration = discoveryService.getLocalAdvertisements(0, "PID", string);
        }
        catch (IOException iOException) {
            return null;
        }
        if (enumeration.hasMoreElements()) {
            Advertisement advertisement = (Advertisement)enumeration.nextElement();
            StringWriter stringWriter = new StringWriter();
            MimeMediaType mimeMediaType = new MimeMediaType("text/xml");
            try {
                StructuredTextDocument structuredTextDocument = (StructuredTextDocument)advertisement.getDocument(mimeMediaType);
                structuredTextDocument.sendToWriter(stringWriter);
                return stringWriter.toString();
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.ERROR)) {
                    LOG.error((Object)"Bad Peer Adverisement, or error during toString conversion");
                }
                return null;
            }
        }
        return null;
    }

    private void saveAdv(String string) {
        block3: {
            PeerAdvertisement peerAdvertisement = null;
            this.discovery = this.myGroup.getDiscoveryService();
            try {
                peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement(new MimeMediaType("text/xml"), new ByteArrayInputStream(string.getBytes()));
                if (!peerAdvertisement.getPeerID().toString().equals(this.localPeerId)) {
                    this.discovery.publish(peerAdvertisement, 0, 0x6DDD00L, 0x6DDD00L);
                }
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                LOG.error((Object)"Error Saving Peer Advertisement during pipe resolution");
            }
        }
    }

    public synchronized void addListener(String string, Listener listener) {
        this.listeners.put(string, listener);
    }

    public synchronized Listener removeListener(String string) {
        return (Listener)this.listeners.remove(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Event
    extends EventObject {
        private String peerid = null;
        private String pipeid = null;
        private int queryID = -1;
        private String type = null;

        public Event(Object object, String string, String string2, String string3, int n) {
            super(object);
            this.peerid = string;
            this.pipeid = string2;
            this.type = string3;
            this.queryID = n;
        }

        public String getPeerID() {
            return new String(this.peerid);
        }

        public String getPipeID() {
            return new String(this.pipeid);
        }

        public String getType() {
            return this.type;
        }

        public int getQueryID() {
            return this.queryID;
        }
    }

    public static interface Listener
    extends EventListener {
        public void pipeResolverEvent(Event var1);
    }

    public class PipeEntry {
        protected String peer = null;
        protected long lease = 0L;

        public PipeEntry(String string) {
            this.peer = string;
            this.lease = DefaultPipeLease;
        }

        public boolean equals(Object object) {
            PipeEntry pipeEntry = (PipeEntry)object;
            return this.peer.equals(pipeEntry.peer);
        }
    }
}

