/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.Element;
import net.jxta.document.StructuredDocument;
import net.jxta.endpoint.EndpointService;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ProtocolNotSupportedException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.exception.ViolationException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.loader.RefJxtaLoader;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.protocol.PeerAdv;
import net.jxta.impl.protocol.PeerGroupAdv;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peer.PeerInfoService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeService;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.resolver.ResolverService;
import net.jxta.service.Service;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public abstract class GenericPeerGroup
implements RefPeerGroup {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$peergroup$GenericPeerGroup == null ? (class$net$jxta$impl$peergroup$GenericPeerGroup = GenericPeerGroup.class$("net.jxta.impl.peergroup.GenericPeerGroup")) : class$net$jxta$impl$peergroup$GenericPeerGroup).getName());
    private EndpointService endpoint;
    private ResolverService resolver;
    private DiscoveryService discovery;
    private PipeService pipe;
    private MembershipService membership;
    private RendezVousService rendezvous;
    private PeerInfoService peerinfo;
    public static final JxtaLoader loader = new RefJxtaLoader("./Downloaded");
    private PeerAdvertisement peerAdvertisement = null;
    private PeerGroupAdvertisement peerGroupAdvertisement = null;
    private ModuleImplAdvertisement implAdvertisement = null;
    private PeerAdvertisement configAdvertisement = null;
    private RefPeerGroup parentGroup = null;
    private Hashtable services = new Hashtable();
    private boolean stopping = false;
    private boolean published = false;
    static /* synthetic */ Class class$net$jxta$impl$peergroup$GenericPeerGroup;
    static /* synthetic */ Class class$net$jxta$protocol$ModuleImplAdvertisement;
    static /* synthetic */ Class class$net$jxta$protocol$PeerGroupAdvertisement;

    private Enumeration discoverSome(int n, String string, String string2, int n2, Class clazz) {
        return this.discoverSome(this.discovery, n, string, string2, n2, clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Enumeration discoverSome(DiscoveryService discoveryService, int n, String string, String string2, int n2, Class clazz) {
        Vector<Advertisement> vector = new Vector<Advertisement>();
        try {
            int n3 = 0;
            do {
                Enumeration enumeration = discoveryService.getLocalAdvertisements(n, string, string2);
                while (enumeration.hasMoreElements()) {
                    Advertisement advertisement = (Advertisement)enumeration.nextElement();
                    if (!clazz.isInstance(advertisement)) continue;
                    vector.add(advertisement);
                }
                if (vector.size() > 0) return vector.elements();
                if (n3 % 30 == 0) {
                    discoveryService.getRemoteAdvertisements(null, n, string, string2, 20);
                }
                Thread.sleep(1000L);
            } while (n3++ < n2);
            return vector.elements();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector.elements();
    }

    private Advertisement discoverOne(int n, String string, String string2, int n2, Class clazz) {
        Enumeration enumeration = this.discoverSome(n, string, string2, n2, clazz);
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        return (Advertisement)enumeration.nextElement();
    }

    private void setShortCut(ID iD, Service service) {
        if (PeerGroup.endpointClassID.equals(iD)) {
            this.endpoint = (EndpointService)service;
            return;
        }
        if (PeerGroup.resolverClassID.equals(iD)) {
            this.resolver = (ResolverService)service;
            return;
        }
        if (PeerGroup.discoveryClassID.equals(iD)) {
            this.discovery = (DiscoveryService)service;
            return;
        }
        if (PeerGroup.pipeClassID.equals(iD)) {
            this.pipe = (PipeService)service;
            return;
        }
        if (PeerGroup.membershipClassID.equals(iD)) {
            this.membership = (MembershipService)service;
            return;
        }
        if (PeerGroup.peerinfoClassID.equals(iD)) {
            this.peerinfo = (PeerInfoService)service;
            return;
        }
        if (PeerGroup.rendezvousClassID.equals(iD)) {
            this.rendezvous = (RendezVousService)service;
            return;
        }
    }

    private void clearShortCut(ModuleClassID moduleClassID) {
        if (PeerGroup.endpointClassID.equals(moduleClassID)) {
            this.endpoint = null;
            return;
        }
        if (PeerGroup.resolverClassID.equals(moduleClassID)) {
            this.resolver = null;
            return;
        }
        if (PeerGroup.discoveryClassID.equals(moduleClassID)) {
            this.discovery = null;
            return;
        }
        if (PeerGroup.pipeClassID.equals(moduleClassID)) {
            this.pipe = null;
            return;
        }
        if (PeerGroup.membershipClassID.equals(moduleClassID)) {
            this.membership = null;
            return;
        }
        if (PeerGroup.peerinfoClassID.equals(moduleClassID)) {
            this.peerinfo = null;
            return;
        }
        if (PeerGroup.rendezvousClassID.equals(moduleClassID)) {
            this.rendezvous = null;
            return;
        }
    }

    private synchronized Service addServiceSync(ID iD, Service service) {
        if (this.stopping) {
            return null;
        }
        Service service2 = (Service)this.services.remove(iD);
        this.services.put(iD, service);
        return service2;
    }

    protected void addService(ID iD, Service service) {
        Service service2 = this.addServiceSync(iD, service);
        this.setShortCut(iD, service);
    }

    public synchronized Service lookupService(ID iD) throws ServiceNotFoundException {
        Service service = (Service)this.services.get(iD);
        if (service == null) {
            throw new ServiceNotFoundException(iD.toString());
        }
        return service.getInterface();
    }

    protected void checkServices() throws ServiceNotFoundException {
        Service service = this.lookupService(PeerGroup.endpointClassID);
        service = this.lookupService(PeerGroup.resolverClassID);
        service = this.lookupService(PeerGroup.discoveryClassID);
        service = this.lookupService(PeerGroup.pipeClassID);
        service = this.lookupService(PeerGroup.rendezvousClassID);
        service = this.lookupService(PeerGroup.membershipClassID);
        service = this.lookupService(PeerGroup.peerinfoClassID);
    }

    private synchronized void removeAllServicesSync() {
        this.stopping = true;
        Hashtable hashtable = this.services;
        this.services = new Hashtable();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Service service = (Service)enumeration.nextElement();
            service.stopApp();
        }
    }

    private synchronized void removeServiceSync(ModuleClassID moduleClassID, Service service) throws ServiceNotFoundException, ViolationException {
        Service service2 = (Service)this.services.get(moduleClassID);
        if (service2 == null) {
            throw new ServiceNotFoundException(moduleClassID.toString());
        }
        if (service2 != service) {
            throw new ViolationException(moduleClassID.toString());
        }
        this.services.remove(moduleClassID);
    }

    protected void removeService(ModuleClassID moduleClassID, Service service) throws ServiceNotFoundException, ViolationException {
        this.removeServiceSync(moduleClassID, service);
        this.clearShortCut(moduleClassID);
    }

    public abstract boolean compatible(Element var1);

    public Module loadModule(ID iD, Advertisement advertisement) throws ProtocolNotSupportedException, PeerGroupException {
        Module module;
        ModuleImplAdvertisement moduleImplAdvertisement = (ModuleImplAdvertisement)advertisement;
        StructuredDocument structuredDocument = moduleImplAdvertisement.getCompat();
        if (!this.compatible(structuredDocument)) {
            throw new ProtocolNotSupportedException("Incompatible Module");
        }
        try {
            module = (Module)loader.loadClass(moduleImplAdvertisement.getCode(), moduleImplAdvertisement.getUri(), true).newInstance();
        }
        catch (Exception exception) {
            throw new PeerGroupException(exception.getMessage());
        }
        module.init(this, iD, moduleImplAdvertisement);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Loaded. class : " + moduleImplAdvertisement.getCode()));
        }
        try {
            if (this.discovery != null) {
                this.discovery.publish(advertisement, 2, 1471228928L, 1209600000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return module;
    }

    public Module loadModule(ID iD, ModuleSpecID moduleSpecID, int n) {
        Advertisement advertisement;
        Enumeration enumeration;
        boolean bl;
        boolean bl2 = n == 0 || n == 2;
        boolean bl3 = bl = n == 1 || n == 2;
        if (bl2 && this.discovery != null) {
            enumeration = this.discoverSome(2, "MSID", moduleSpecID.toString(), 120, class$net$jxta$protocol$ModuleImplAdvertisement == null ? (class$net$jxta$protocol$ModuleImplAdvertisement = GenericPeerGroup.class$("net.jxta.protocol.ModuleImplAdvertisement")) : class$net$jxta$protocol$ModuleImplAdvertisement);
            while (enumeration.hasMoreElements()) {
                try {
                    advertisement = (Advertisement)enumeration.nextElement();
                    if (!((ModuleImplAdvertisement)advertisement).getModuleSpecID().equals(moduleSpecID)) continue;
                    Module module = this.loadModule(iD, advertisement);
                    return module;
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.INFO)) continue;
                    LOG.info((Object)"Not a valid impl adv: ", (Throwable)exception);
                }
            }
        }
        if (bl) {
            if (this.parentGroup == null) {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)"Loading module from SpecID without discovery is not yet supported.");
                }
                return null;
            }
            enumeration = this.discoverSome(this.parentGroup.getDiscoveryService(), 2, "MSID", moduleSpecID.toString(), 120, class$net$jxta$protocol$ModuleImplAdvertisement == null ? (class$net$jxta$protocol$ModuleImplAdvertisement = GenericPeerGroup.class$("net.jxta.protocol.ModuleImplAdvertisement")) : class$net$jxta$protocol$ModuleImplAdvertisement);
            while (enumeration.hasMoreElements()) {
                try {
                    advertisement = (Advertisement)enumeration.nextElement();
                    if (!((ModuleImplAdvertisement)advertisement).getModuleSpecID().equals(moduleSpecID)) continue;
                    Module module = this.loadModule(iD, advertisement);
                    try {
                        this.parentGroup.getDiscoveryService().publish(advertisement, 2, 1471228928L, 1209600000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return module;
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) continue;
                    LOG.warn((Object)"Bad impl adv: ", (Throwable)exception);
                }
            }
        }
        return null;
    }

    public RefPeerGroup getParentGroup() {
        return this.parentGroup;
    }

    public Advertisement getConfigAdvertisement() {
        if (this.configAdvertisement == null) {
            return null;
        }
        return (Advertisement)this.configAdvertisement.clone();
    }

    protected void setConfigAdvertisement(Advertisement advertisement) {
        this.configAdvertisement = (PeerAdvertisement)advertisement;
    }

    public void init(PeerGroup peerGroup, ID iD, Advertisement advertisement) throws PeerGroupException {
        this.implAdvertisement = (ModuleImplAdvertisement)advertisement;
        this.parentGroup = (RefPeerGroup)peerGroup;
        this.peerAdvertisement = new PeerAdv();
        if (this.configAdvertisement != null) {
            this.peerAdvertisement.putServiceParam(PeerGroup.peerGroupClassID, this.configAdvertisement.getServiceParam(PeerGroup.peerGroupClassID));
            this.peerAdvertisement.setPeerID(this.configAdvertisement.getPeerID());
            this.peerAdvertisement.setName(this.configAdvertisement.getName());
        }
        try {
            String string;
            PeerGroupID peerGroupID;
            if (iD == null || iD.equals(ID.nullID)) {
                peerGroupID = IDFactory.newPeerGroupID();
                string = peerGroupID.toString();
            } else {
                string = iD.toString();
                peerGroupID = (PeerGroupID)IDFactory.fromURL(new URL(string));
            }
            this.peerAdvertisement.setPeerGroupID(peerGroupID);
            if (peerGroup == null) {
                if (this.peerAdvertisement.getPeerID() == null || this.peerAdvertisement.getPeerID().equals(ID.nullID)) {
                    this.peerAdvertisement.setPeerID(IDFactory.newPeerID(peerGroupID));
                }
                if (this.peerAdvertisement.getName() == null) {
                    this.peerAdvertisement.setName("Anonymous Coward");
                }
            } else {
                DiscoveryService discoveryService;
                Enumeration enumeration;
                this.peerAdvertisement.setPeerID(peerGroup.getPeerID());
                this.peerAdvertisement.setName(peerGroup.getPeerName());
                if (iD != null && !iD.equals(ID.nullID) && (enumeration = (discoveryService = this.parentGroup.getDiscoveryService()).getLocalAdvertisements(1, "GID", string)).hasMoreElements()) {
                    this.peerGroupAdvertisement = (PeerGroupAdvertisement)enumeration.nextElement();
                }
            }
            if (this.peerGroupAdvertisement == null) {
                this.peerGroupAdvertisement = new PeerGroupAdv();
                this.peerGroupAdvertisement.setName("Anonymous Group");
                this.peerGroupAdvertisement.setDescription("Nondescript Group");
                this.peerGroupAdvertisement.setPeerGroupID(peerGroupID);
                this.peerGroupAdvertisement.setModuleSpecID(this.implAdvertisement.getModuleSpecID());
            } else {
                this.published = true;
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Group init failed.", (Throwable)exception);
            }
            throw new PeerGroupException(exception.getMessage());
        }
    }

    public int startApp(String[] stringArray) {
        return 0;
    }

    public void stopApp() {
        this.removeAllServicesSync();
    }

    public Service getInterface() {
        return this;
    }

    public Advertisement getImplAdvertisement() {
        return (Advertisement)this.implAdvertisement.clone();
    }

    public void publishGroup(String string, String string2) throws IOException {
        if (this.published) {
            return;
        }
        this.peerGroupAdvertisement.setName(string);
        this.peerGroupAdvertisement.setDescription(string2);
        if (this.parentGroup == null) {
            return;
        }
        this.parentGroup.getDiscoveryService().publish(this.peerGroupAdvertisement, 1, 1471228928L, 1209600000L);
        this.published = true;
    }

    public PeerGroup newGroup(Advertisement advertisement) throws PeerGroupException {
        PeerGroup peerGroup;
        block3: {
            PeerGroupAdvertisement peerGroupAdvertisement = (PeerGroupAdvertisement)advertisement;
            peerGroup = (PeerGroup)this.loadModule(peerGroupAdvertisement.getPeerGroupID(), peerGroupAdvertisement.getModuleSpecID(), 0);
            if (peerGroup == null) {
                throw new PeerGroupException("Could not find all implementations.");
            }
            try {
                peerGroup.publishGroup(peerGroupAdvertisement.getName(), peerGroupAdvertisement.getDescription());
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.INFO)) break block3;
                LOG.info((Object)("Could not publish the group advertisement: " + exception.getMessage()));
            }
        }
        return peerGroup;
    }

    public PeerGroup newGroup(PeerGroupID peerGroupID, Advertisement advertisement, String string, String string2) throws PeerGroupException {
        PeerGroup peerGroup;
        block4: {
            try {
                peerGroup = (PeerGroup)this.loadModule(peerGroupID, advertisement);
            }
            catch (Exception exception) {
                throw new PeerGroupException(exception.getMessage());
            }
            try {
                peerGroup.publishGroup(string, string2);
            }
            catch (Exception exception) {
                if (!LOG.isEnabledFor(Priority.INFO)) break block4;
                LOG.info((Object)("Could not publish group or implementation:" + exception.toString()));
            }
        }
        return peerGroup;
    }

    public PeerGroup newGroup(PeerGroupID peerGroupID) throws PeerGroupException {
        PeerGroupAdvertisement peerGroupAdvertisement;
        try {
            peerGroupAdvertisement = (PeerGroupAdvertisement)this.discoverOne(1, "GID", peerGroupID.toString(), 120, class$net$jxta$protocol$PeerGroupAdvertisement == null ? (class$net$jxta$protocol$PeerGroupAdvertisement = GenericPeerGroup.class$("net.jxta.protocol.PeerGroupAdvertisement")) : class$net$jxta$protocol$PeerGroupAdvertisement);
        }
        catch (Exception exception) {
            throw new PeerGroupException(exception.getMessage());
        }
        if (peerGroupAdvertisement == null) {
            throw new PeerGroupException("Could not find group advertisement");
        }
        PeerGroup peerGroup = (PeerGroup)this.loadModule(peerGroupID, peerGroupAdvertisement.getModuleSpecID(), 0);
        try {
            peerGroup.publishGroup(peerGroupAdvertisement.getName(), peerGroupAdvertisement.getDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (peerGroup == null) {
            throw new PeerGroupException("Could not find all implementations.");
        }
        return peerGroup;
    }

    public JxtaLoader getLoader() {
        return loader;
    }

    public String getPeerName() {
        return this.peerAdvertisement.getName();
    }

    public String getPeerGroupName() {
        return this.peerGroupAdvertisement.getName();
    }

    public PeerGroupID getPeerGroupID() {
        return this.peerGroupAdvertisement.getPeerGroupID();
    }

    public PeerID getPeerID() {
        return this.peerAdvertisement.getPeerID();
    }

    public PeerAdvertisement getPeerAdvertisement() {
        return this.peerAdvertisement;
    }

    public PeerGroupAdvertisement getPeerGroupAdvertisement() {
        return this.peerGroupAdvertisement;
    }

    public boolean isRendezvous() {
        return this.rendezvous != null && this.rendezvous.isRendezVous();
    }

    public EndpointService getEndpointService() {
        return this.endpoint;
    }

    public ResolverService getResolverService() {
        return this.resolver;
    }

    public DiscoveryService getDiscoveryService() {
        return this.discovery;
    }

    public PeerInfoService getPeerInfoService() {
        return this.peerinfo;
    }

    public MembershipService getMembershipService() {
        return this.membership;
    }

    public PipeService getPipeService() {
        return this.pipe;
    }

    public RendezVousService getRendezVousService() {
        return this.rendezvous;
    }

    public abstract ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

