/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import net.jxta.impl.index.BloomFilterProperties;
import net.jxta.impl.index.SummaryUpdate;
import net.jxta.impl.xml.XmlParser;

public class SummaryUpdate {
    String serialNumber = null;
    String id = null;
    int[] bitPositions = null;
    int nItems = 0;
    BloomFilterProperties bloomFilterProperties;

    SummaryUpdate(BloomFilterProperties bloomFilterProperties, String string, String string2, int[] nArray) {
        this.bloomFilterProperties = bloomFilterProperties;
        this.serialNumber = string;
        this.id = string2;
        this.add(nArray);
    }

    public static SummaryUpdate parse(InputStream inputStream) throws XmlParser.Exception, IOException {
        Object object;
        XmlParser xmlParser = new XmlParser();
        byte[] byArray = new byte[128];
        class SUCallback
        implements XmlParser.ParserCallback {
            BloomFilterProperties bfp;
            String id;
            String sn;
            StringBuffer sb;
            static final int NOTHING = 0;
            static final int ID = 1;
            static final int SN = 2;
            static final int BFPARAMS = 3;
            static final int CBITS = 4;
            static final int NFUN = 5;
            static final int NBITS = 6;
            static final int LEN = 7;
            int state;

            SUCallback() {
                this.bfp = new BloomFilterProperties();
                this.sb = new StringBuffer();
                this.state = 0;
            }

            public void startTag(byte[] byArray, int n, int n2) {
                String string = new String(byArray, n, n2);
                if (this.state == 0) {
                    this.state = string.equals("ID") ? 1 : (string.equals("SN") ? 2 : (string.equals("BloomFilterParameters") ? 3 : (string.equals("ChangedBits") ? 4 : 0)));
                } else if (this.state == 3) {
                    if (string.equals("nFunctionsPerEntry")) {
                        this.state = 5;
                    } else if (string.equals("nBitsPerFunction")) {
                        this.state = 6;
                    } else if (string.equals("length")) {
                        this.state = 7;
                    }
                }
            }

            public void attribute(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
            }

            public void chars(byte[] byArray, int n, int n2) {
                String string = new String(byArray, n, n2);
                int n3 = -1;
                switch (this.state) {
                    case 1: {
                        this.id = string;
                        break;
                    }
                    case 2: {
                        this.sn = string;
                        break;
                    }
                    case 4: {
                        this.sb.append(string);
                        break;
                    }
                    case 5: {
                        try {
                            n3 = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n3 == -1) break;
                        this.bfp.setNFunctions(n3);
                        break;
                    }
                    case 6: {
                        try {
                            n3 = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n3 == -1) break;
                        this.bfp.setNBitsPerFunction(n3);
                        break;
                    }
                    case 7: {
                        try {
                            n3 = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n3 == -1) break;
                        this.bfp.setLength(n3);
                        break;
                    }
                }
            }

            public void endTag(byte[] byArray, int n, int n2) {
                switch (this.state) {
                    case 5: 
                    case 6: 
                    case 7: {
                        this.state = 3;
                        break;
                    }
                    default: {
                        this.state = 0;
                    }
                }
            }
        }
        SUCallback sUCallback = new SUCallback();
        XmlParser.parse(inputStream, byArray, sUCallback);
        StringTokenizer stringTokenizer = new StringTokenizer(sUCallback.sb.toString(), ",");
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            try {
                int n3 = Integer.parseInt((String)object);
                nArray[n2++] = n3;
            }
            catch (NumberFormatException numberFormatException) {
                throw new XmlParser.Exception("Invalid Bit Position Value");
            }
        }
        object = new SummaryUpdate(sUCallback.bfp, sUCallback.sn, sUCallback.id, nArray);
        return object;
    }

    public void add(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int[] nArray2 = new int[this.nItems + nArray.length];
        if (this.nItems > 0) {
            System.arraycopy(this.bitPositions, 0, nArray2, 0, this.nItems);
        }
        System.arraycopy(nArray, 0, nArray2, this.nItems, nArray.length);
        this.nItems += nArray.length;
        this.bitPositions = nArray2;
    }

    public String getId() {
        return this.id;
    }

    public BloomFilterProperties getProperties() {
        return this.bloomFilterProperties;
    }

    public int[] getBitPositions() {
        return this.bitPositions;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<ID>" + this.id + "</ID>\n");
        int n = 5;
        int n2 = 0;
        stringBuffer.append("<SN>" + this.serialNumber + "</SN>\n");
        stringBuffer.append(this.bloomFilterProperties.toString());
        int n3 = 0;
        while ((double)n3 < Math.ceil((double)this.nItems / (double)n)) {
            stringBuffer.append("<ChangedBits>");
            int n4 = 0;
            while (n4 < n && n2 < this.nItems) {
                stringBuffer.append(this.bitPositions[n2++] + ",");
                ++n4;
            }
            stringBuffer.append("</ChangedBits>\n");
            ++n3;
        }
        return stringBuffer.toString();
    }
}

