/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.index;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import net.jxta.impl.index.BloomFilter;
import net.jxta.impl.index.RemoteSummary;
import net.jxta.impl.index.SummaryUpdate;
import net.jxta.impl.index.xpath.Expression;

public class IndexSummary {
    int maxNumKeys;
    static final int MAX_BUFFER = 1000;
    BloomFilter bf = null;
    byte[] bitCounter;
    int[] bitsChanged;
    int numKeysStored = 0;
    int numBitsPerEntry;
    long versionNumber = 0L;
    String indexId;
    int pointer = 0;

    public IndexSummary(String string, int n) {
        this.maxNumKeys = n;
        this.indexId = string;
        this.bf = new BloomFilter(this.maxNumKeys);
        this.bitsChanged = new int[1000];
        this.bitCounter = new byte[this.bf.getLength()];
        this.numBitsPerEntry = this.bf.getBitsPerEntry();
        this.versionNumber = 0L;
    }

    public IndexSummary(File file) throws IOException {
        this.load(file);
    }

    public void load(File file) throws IOException {
    }

    public void write(File file) throws IOException {
    }

    public boolean add(Expression.Literal literal) {
        int n;
        if (this.numKeysStored >= this.maxNumKeys) {
            return false;
        }
        if (this.pointer + this.numBitsPerEntry >= 1000) {
            this.publishCurrentChanges();
        }
        int[] nArray = this.bf.getBitPositions(literal.getName().toString());
        int n2 = 0;
        while (n2 < this.numBitsPerEntry) {
            n = nArray[n2];
            if (this.bitCounter[n] == 127) {
                return false;
            }
            ++n2;
        }
        ++this.numKeysStored;
        n = 0;
        while (n < this.numBitsPerEntry) {
            int n3 = nArray[n];
            if (this.bitCounter[n3] == 0) {
                this.bitsChanged[this.pointer++] = n3;
            }
            int n4 = n3;
            this.bitCounter[n4] = (byte)(this.bitCounter[n4] + 1);
            ++n;
        }
        return true;
    }

    public boolean remove(Expression.Literal literal) {
        int n;
        if (this.numKeysStored == 0) {
            return false;
        }
        if (this.pointer + this.numBitsPerEntry >= 1000) {
            this.publishCurrentChanges();
        }
        int[] nArray = this.bf.getBitPositions(literal.getName().toString());
        int n2 = 0;
        while (n2 < this.numBitsPerEntry) {
            n = nArray[n2];
            if (this.bitCounter[n] == 0) {
                return false;
            }
            ++n2;
        }
        --this.numKeysStored;
        n = 0;
        while (n < this.numBitsPerEntry) {
            int n3 = nArray[n];
            if (this.bitCounter[n3] == 1) {
                this.bitsChanged[this.pointer++] = n3 | Integer.MIN_VALUE;
            }
            int n4 = n3;
            this.bitCounter[n4] = (byte)(this.bitCounter[n4] - 1);
            ++n;
        }
        return true;
    }

    public void publishCurrentChanges() {
        SummaryUpdate summaryUpdate = this.delta();
        if (summaryUpdate == null) {
            return;
        }
        System.out.println(summaryUpdate.toString());
        this.pointer = 0;
        ++this.versionNumber;
    }

    private SummaryUpdate delta() {
        if (this.pointer == 0) {
            return null;
        }
        String string = new String(System.currentTimeMillis() + ":" + this.versionNumber);
        int[] nArray = new int[this.pointer];
        System.arraycopy(this.bitsChanged, 0, nArray, 0, this.pointer);
        SummaryUpdate summaryUpdate = new SummaryUpdate(this.bf.getProperties(), string, this.indexId, nArray);
        return summaryUpdate;
    }

    public static void main(String[] stringArray) {
        Expression.Literal[] literalArray = new Expression.Literal[5];
        String string = "INDEX_ID1";
        IndexSummary indexSummary = new IndexSummary(string, 1000);
        literalArray[0] = new Expression.Literal("item1");
        literalArray[1] = new Expression.Literal("item2");
        literalArray[2] = new Expression.Literal("item3");
        literalArray[3] = new Expression.Literal("item4");
        literalArray[4] = new Expression.Literal("item5");
        indexSummary.add(literalArray[0]);
        indexSummary.add(literalArray[1]);
        indexSummary.add(literalArray[2]);
        indexSummary.add(literalArray[3]);
        indexSummary.add(literalArray[4]);
        System.out.println("Number of Keys Stored:" + indexSummary.numKeysStored);
        String string2 = indexSummary.delta().toString();
        System.out.println("SummaryUpdate: ");
        System.out.println(string2);
        byte[] byArray = string2.getBytes();
        SummaryUpdate summaryUpdate = null;
        try {
            summaryUpdate = SummaryUpdate.parse(new ByteArrayInputStream(byArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (summaryUpdate == null) {
            System.out.println("ERROR: could not read SummaryUpdate from InputStream");
        }
        RemoteSummary remoteSummary = new RemoteSummary(summaryUpdate);
        System.out.println("Does the RemoteSummary created contain all literals?\n" + remoteSummary.query(literalArray));
        indexSummary.remove(literalArray[0]);
        indexSummary.remove(literalArray[1]);
        indexSummary.remove(literalArray[2]);
        remoteSummary.update(indexSummary.delta());
        System.out.println("Removed some items from the remotesummary");
        System.out.println("Does the RemoteSummary contain all literals now?\n" + remoteSummary.query(literalArray));
        Expression.Literal[] literalArray2 = new Expression.Literal[]{literalArray[3], literalArray[4]};
        System.out.println("This query should answer true now?\n" + remoteSummary.query(literalArray2));
        System.out.println("Number of Keys currently stored: " + indexSummary.numKeysStored);
    }
}

