/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLSocket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.StructuredDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.tls.JTlsInputStream;
import net.jxta.impl.endpoint.tls.JTlsOutputStream;
import net.jxta.impl.endpoint.tls.JTlsParams;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.TlsConfig;
import net.jxta.impl.endpoint.tls.TlsManager;
import net.jxta.impl.endpoint.tls.TlsTransport;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TlsConn {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$TlsConn == null ? (class$net$jxta$impl$endpoint$tls$TlsConn = TlsConn.class$("net.jxta.impl.endpoint.tls.TlsConn")) : class$net$jxta$impl$endpoint$tls$TlsConn).getName());
    TlsManager manager = null;
    TlsTransport transport = null;
    static final String userPassword = "password";
    SSLSocket ssls = null;
    JTlsOutputStream jout = null;
    JTlsInputStream jin = null;
    JTlsParams params = null;
    String rootdir = null;
    String rootfile = null;
    String keyfile = null;
    String dhfile = null;
    String passphrase = null;
    String suites = null;
    String ppPath = null;
    String rootCertFile = null;
    boolean unverifiedCerts = true;
    boolean checkDates = true;
    boolean clientAuthorization = false;
    ReadPlaintextMessage readerThread = null;
    EndpointAddress destAddr = null;
    int which = 0;
    private boolean handshakeDone = false;
    private boolean inputDead = false;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsConn;

    public boolean getHandshakeDone() {
        return this.handshakeDone;
    }

    public boolean getInputDead() {
        return this.inputDead;
    }

    public TlsConn(TlsManager tlsManager, TlsTransport tlsTransport, EndpointAddress endpointAddress, boolean bl, Message message) throws IOException {
        this.manager = tlsManager;
        this.transport = tlsTransport;
        this.destAddr = endpointAddress;
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("TlsConn, contacting: " + endpointAddress.getProtocolAddress()));
        }
        this.setPathnames();
        String string = new String(TlsConfig.passitOn);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("TlsConn, password = " + string));
        }
        if (string == null) {
            throw new IOException("TlsConn: null password. Cannot proceed.");
        }
        this.passphrase = JTlsUtil.readPassPhrase(this.ppPath, string);
        string = null;
        this.unverifiedCerts = true;
        this.clientAuthorization = false;
        this.rootCertFile = this.getRootCert(endpointAddress);
        if (this.rootCertFile != null) {
            if (bl) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Verifying certs, root = " + this.rootCertFile));
                }
                this.unverifiedCerts = false;
            } else {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("Authorizing client, root = " + this.rootCertFile));
                }
                this.clientAuthorization = true;
            }
        } else {
            this.rootCertFile = this.rootfile;
            if (LOG.isEnabledFor(Priority.INFO)) {
                String string2 = bl ? "Server" : "Client";
                LOG.info((Object)("NOT Verifying " + string2 + " cert, root = " + this.rootCertFile));
            }
        }
        if (bl) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"TLS Client");
            }
            this.params = new JTlsParams();
            this.params.setClientParameters(this.rootCertFile, this.keyfile, this.passphrase, this.suites, this.unverifiedCerts, this.checkDates);
            this.which = 1;
        } else {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"TLS Server");
            }
            this.params = new JTlsParams();
            this.params.setServerParameters(this.rootCertFile, this.keyfile, this.dhfile, this.passphrase, this.clientAuthorization);
            this.which = 2;
        }
        if (!this.unverifiedCerts || this.clientAuthorization) {
            this.removeRootCertFile();
        }
        this.rootCertFile = null;
        this.jin = new JTlsInputStream(this);
        if (message != null) {
            this.jin.queueIncomingMessage(message);
        }
        this.jout = new JTlsOutputStream(this, tlsTransport, endpointAddress);
    }

    public void openTLSConnection() throws IOException {
        String string = this.destAddr.getProtocolAddress();
        int n = 1376911;
        boolean bl = this.which == 1;
        long l = 0L;
        if (LOG.isEnabledFor(Priority.INFO)) {
            l = System.currentTimeMillis();
            LOG.info((Object)((bl ? "Client:" : "Server:") + " Handshake START"));
        }
        this.handshakeDone = false;
        this.ssls = new SSLSocket(this.params.getContext(), (InputStream)this.jin, (OutputStream)this.jout, string, n, this.which);
        this.handshakeDone = true;
        if (LOG.isEnabledFor(Priority.INFO)) {
            long l2 = (System.currentTimeMillis() - l) / 1000L;
            LOG.info((Object)((bl ? "Client:" : "Server:") + "Handshake DONE in " + l2 + " secs\n"));
        }
        this.jin.setPlaintextInputStream(this.ssls);
        this.jout.setPlaintextOutputStream(this.ssls);
        this.readerThread = new ReadPlaintextMessage(this.jin, this.transport);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"TLS: Started plaintext reader thread");
        }
    }

    public void sendMessage(Message message) throws IOException {
        this.jout.writeMessage(message);
    }

    private void setPathnames() {
        String string;
        String string2 = JTlsUtil.getPCEPath();
        this.rootdir = string = JTlsUtil.getPCERootPath();
        String string3 = JTlsUtil.getPCEClientPath();
        this.rootfile = string + "peer-root.pem";
        this.keyfile = string3 + "peer-service.pem";
        this.ppPath = string3 + "peer.phrase";
        this.dhfile = null;
    }

    private String getRootCert(EndpointAddress endpointAddress) {
        Object object;
        String string = "urn:jxta:" + endpointAddress.getProtocolAddress();
        PeerGroup peerGroup = this.transport.getPeerGroup();
        DiscoveryService discoveryService = peerGroup.getDiscoveryService();
        Enumeration enumeration = null;
        String string2 = null;
        try {
            enumeration = discoveryService.getLocalAdvertisements(0, "PID", string);
            if (!enumeration.hasMoreElements()) {
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)("getRootCert: enum is empty\n  PID = " + string));
                }
                return null;
            }
            object = (PeerAdvertisement)enumeration.nextElement();
            StructuredDocument structuredDocument = ((PeerAdvertisement)object).getServiceParam(PeerGroup.peerGroupClassID);
            Enumeration enumeration2 = structuredDocument.getChildren("RootCert");
            string2 = (String)((TextElement)enumeration2.nextElement()).getValue();
            string2 = string2 + "\n";
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("getRootCert, Exception: " + exception.getMessage()));
                exception.printStackTrace();
            }
            return null;
        }
        object = this.rootdir + string + ".pem";
        try {
            JTlsUtil.writeRootCert(string2, (String)object);
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.WARN)) {
                LOG.warn((Object)("genRootCert, Exception: " + exception.getMessage()));
            }
            return null;
        }
        return object;
    }

    private void removeRootCertFile() {
        File file = new File(this.rootCertFile);
        try {
            if (!LOG.isEnabledFor(Priority.INFO)) {
                file.delete();
            } else {
                LOG.info((Object)("Removed " + this.rootCertFile));
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ReadPlaintextMessage
    implements Runnable {
        JTlsInputStream ptin = null;
        TlsTransport tp = null;
        int nErrors = 0;
        Thread th = null;
        private static final long ERRORWAIT = 30000L;

        public ReadPlaintextMessage(JTlsInputStream jTlsInputStream, TlsTransport tlsTransport) {
            this.ptin = jTlsInputStream;
            this.tp = tlsTransport;
            this.th = new Thread((Runnable)this, "jxtatlsInputThread");
            this.th.setDaemon(true);
            this.th.start();
        }

        public void run() {
            while (true) {
                MessageImpl messageImpl;
                int n;
                if ((n = this.ptin.readMessage(messageImpl = new MessageImpl())) == 0) {
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)"Dispatching msg to TlsTransport");
                    }
                    this.tp.processReceivedMessage(messageImpl);
                    this.nErrors = 0;
                    continue;
                }
                if (LOG.isEnabledFor(Priority.INFO)) {
                    LOG.info((Object)"I/O error while reading decrypted Message");
                }
                ++this.nErrors;
                if (this.nErrors != 10) continue;
                TlsConn.this.inputDead = true;
                try {
                    Thread.currentThread();
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.nErrors = 0;
            }
        }
    }
}

