/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.PeerCerts;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class TlsConfig {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$TlsConfig == null ? (class$net$jxta$impl$endpoint$tls$TlsConfig = TlsConfig.class$("net.jxta.impl.endpoint.tls.TlsConfig")) : class$net$jxta$impl$endpoint$tls$TlsConfig).getName());
    private static final boolean wantDH = false;
    static String passitOn = null;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$TlsConfig;

    public static boolean willConfigureTls() {
        try {
            String string = JTlsUtil.getPCEPath();
            File file = new File(string);
            if (!file.exists()) {
                return true;
            }
            if (!TlsConfig.allPCEChildrenExist()) {
                return true;
            }
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    public static void init(String string, String string2) {
        if (LOG.getChainedPriority().equals(Priority.INFO)) {
            SSLDebug.setDebug((int)4);
        }
        SSLDebug.debug((int)128, (String)("TlsConfig, peer = " + string + ", password = " + string2 + "\n"));
        String string3 = JTlsUtil.getPCEPath();
        File file = new File(string3);
        boolean bl = false;
        try {
            if (!file.exists()) {
                file.mkdir();
                TlsConfig.makeChildren();
                bl = true;
            } else if (!TlsConfig.allPCEChildrenExist()) {
                TlsConfig.removeAllChildren();
                TlsConfig.makeChildren();
                bl = true;
            } else {
                boolean bl2 = true;
                if (!bl2) {
                    TlsConfig.removeAllChildren();
                    TlsConfig.makeChildren();
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            if (LOG.isEnabledFor(Priority.FATAL)) {
                LOG.fatal((Object)"Cert generation failed", (Throwable)exception);
            }
            return;
        }
        if (bl) {
            try {
                SSLDebug.debug((int)128, (String)"TlsConfig: Generating certs ...");
                System.out.println("\nSecurity initialization in progress.\nThis will take 10 or more seconds ...\n");
                PeerCerts.generateCerts(string, string2, false);
                JTlsUtil.createPasswdFile(string2, false);
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)"Cert generation failed", (Throwable)exception);
                }
                return;
            }
        }
        if (string2.compareTo("password") != 0 && JTlsUtil.validPasswd("password")) {
            try {
                JTlsUtil.createPasswdFile(string2, true);
                String string4 = JTlsUtil.getPCEClientPath() + "peer.phrase";
                String string5 = JTlsUtil.readPassPhrase(string4, "password");
                PeerCerts.writePassphrase(string4, string5, string2);
            }
            catch (Exception exception) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)"Cannot create password file:", (Throwable)exception);
                }
                return;
            }
        }
        if (SSLDebug.getDebug((int)128)) {
            if (JTlsUtil.validPasswd(string2)) {
                System.out.println(string2 + " VALID");
            } else {
                System.out.println(string2 + " NOT VALID");
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)"Cert generation OK");
        }
        SSLDebug.debug((int)128, (String)"Cert generation OK");
        passitOn = new String(string2);
    }

    static void makeChildren() throws SecurityException, IOException {
        String string = JTlsUtil.getPCEClientPath();
        String string2 = JTlsUtil.getPCERootPath();
        String string3 = JTlsUtil.getPCEPasswdPath();
        File file = new File(string);
        file.mkdir();
        File file2 = new File(string2);
        file2.mkdir();
        File file3 = new File(string3);
        file2.mkdir();
    }

    static void removeAllChildren() throws SecurityException {
        String string = JTlsUtil.getPCEClientPath();
        String string2 = JTlsUtil.getPCERootPath();
        String string3 = JTlsUtil.getPCEPasswdPath();
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = new File(string3);
        String[] stringArray = file.list();
        String[] stringArray2 = file2.list();
        String[] stringArray3 = file3.list();
        SSLDebug.debug((int)128, (String)"Removing child files");
        TlsConfig.removeDir(file, stringArray);
        TlsConfig.removeDir(file2, stringArray2);
        TlsConfig.removeDir(file3, stringArray3);
    }

    static void removeDir(File file, String[] stringArray) throws SecurityException {
        if (stringArray != null) {
            int n = stringArray.length;
            if (stringArray != null && n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    File file2 = new File(stringArray[n2]);
                    file2.delete();
                    SSLDebug.debug((int)128, (String)(" " + stringArray[n2]));
                    ++n2;
                }
            }
        }
        if (file.exists()) {
            file.delete();
        }
    }

    static boolean allPCEChildrenExist() throws SecurityException {
        String string = JTlsUtil.getPCEClientPath();
        String string2 = JTlsUtil.getPCERootPath();
        String string3 = JTlsUtil.getPCEPasswdPath();
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = new File(string3);
        if (!(file.exists() && file2.exists() && file3.exists())) {
            return false;
        }
        String string4 = string2 + "peer-root.pem";
        String string5 = string + "peer-service.pem";
        String string6 = string + "peer.phrase";
        String string7 = string3 + "passwd";
        File file4 = new File(string4);
        File file5 = new File(string5);
        File file6 = new File(string6);
        File file7 = new File(string7);
        if (!(file4.exists() && file5.exists() && file6.exists() && file7.exists())) {
            SSLDebug.debug((int)128, (String)"Missing certificate, passphrase, or password file.");
            return false;
        }
        return JTlsUtil.verifySignedCert(string4, string5);
    }

    public static String getRootCert() throws IOException {
        String string = JTlsUtil.getPCERootPath() + "peer-root.pem";
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string2 = JTlsUtil.loadObject(bufferedReader, "CERTIFICATE");
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

