/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import COM.claymoresystems.ptls.SSLSocket;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.MessageImpl;
import net.jxta.impl.endpoint.MessageWireFormat;
import net.jxta.impl.endpoint.MessageWireFormatBinary;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.JTlsUtil;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class JTlsOutputStream
extends OutputStream {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$tls$JTlsOutputStream == null ? (class$net$jxta$impl$endpoint$tls$JTlsOutputStream = JTlsOutputStream.class$("net.jxta.impl.endpoint.tls.JTlsOutputStream")) : class$net$jxta$impl$endpoint$tls$JTlsOutputStream).getName());
    private MessageElement sentMelt = null;
    private MessageWireFormat wFout = new MessageWireFormatBinary(JTlsDefs.MTYPE);
    private int sequenceNumber = 0;
    private EndpointAddress destAddr = null;
    private TlsTransport tp = null;
    private TlsConn conn = null;
    private long aveRTT = 0L;
    private int nACKS = 0;
    long RTO = 0L;
    long minRTO = 0L;
    long maxRTO = 0L;
    private long lastACKTime = 0L;
    private static final long initRTT = 1000L;
    private static final long ONEMINUTE = 60000L;
    private static final int RETRMAXAGE = 10;
    private static final int MAXRETRQSIZE = 100;
    private int nIQTests = 0;
    private int aveIQSize = 0;
    private int mrrIQFreeSpace = 0;
    private int rmaxQSize = 0;
    private static final int RWINDOW = 5;
    Retransmitter retrThread = null;
    long sackRetransTime = 0L;
    static final boolean testRetrans = false;
    private OutputStream plaintext_out = null;
    static final int BOSIZE = 16000;
    Vector retrQ = new Vector(10, 1);
    private static final byte[] MARKText = new byte[]{84, 76, 83, 82, 69, 84};
    static /* synthetic */ Class class$net$jxta$impl$endpoint$tls$JTlsOutputStream;

    public JTlsOutputStream(TlsConn tlsConn, TlsTransport tlsTransport, EndpointAddress endpointAddress) {
        this.setupJxtaMsgs();
        this.conn = tlsConn;
        this.tp = tlsTransport;
        this.destAddr = endpointAddress;
        this.aveRTT = 1000L;
        this.RTO = this.minRTO = 1000L;
        this.maxRTO = 5L * this.minRTO;
        this.rmaxQSize = this.mrrIQFreeSpace = tlsConn.jin.getMaxIQSize();
        this.lastACKTime = System.currentTimeMillis();
        this.retrThread = new Retransmitter();
    }

    private void setupJxtaMsgs() {
        this.wFout = new MessageWireFormatBinary(JTlsDefs.MTYPE);
        this.sequenceNumber = 1;
        this.sentMelt = null;
    }

    public void setPlaintextOutputStream(SSLSocket sSLSocket) {
        this.plaintext_out = sSLSocket.getOutputStream();
    }

    public OutputStream getPlaintextOutputStream() {
        return this.plaintext_out;
    }

    public synchronized void writeMessage(Message message) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.plaintext_out, 16000);
        this.wFout.writeMessage(bufferedOutputStream, message);
        bufferedOutputStream.flush();
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        String string = "jxtatls:" + this.sequenceNumber;
        MessageImpl messageImpl = new MessageImpl();
        this.sentMelt = messageImpl.newMessageElement(string, null, byArray2, 0, n2);
        messageImpl.addElement(this.sentMelt);
        int n3 = this.aveRTT < 200L ? (int)this.aveRTT : 200;
        int n4 = n3 / 60;
        if (n4 < 1) {
            n4 = 1;
        }
        int n5 = 0;
        while (this.mrrIQFreeSpace < this.rmaxQSize / 5 || this.retrQ.size() > this.rmaxQSize) {
            if (n5++ == n4) {
                if (!LOG.isEnabledFor(Priority.INFO)) break;
                LOG.info((Object)"write() wait for ACK, maxwait timer expired");
                break;
            }
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("write() wait for ACK, remote IQ size = " + this.mrrIQFreeSpace));
                LOG.info((Object)("    MIN to continue = " + this.rmaxQSize / 5));
                LOG.info((Object)("    retQ.size() = " + this.retrQ.size()));
            }
            try {
                Thread.currentThread();
                Thread.sleep(60L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!LOG.isEnabledFor(Priority.INFO)) continue;
            LOG.info((Object)("write() woke up, remote IQ size = " + this.mrrIQFreeSpace));
        }
        this.retransEnqueue(this.sequenceNumber, (Message)messageImpl.clone());
        this.tp.sendToRemoteTls(this.destAddr, messageImpl);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! TLS Record sent, len = " + n2 + " Seq# = " + this.sequenceNumber));
            if (this.sequenceNumber < 6) {
                String string2 = JTlsUtil.toHex(byArray, n, n2);
                LOG.info((Object)("HexDump:\n" + string2));
            }
        }
        ++this.sequenceNumber;
    }

    private synchronized void retransEnqueue(int n, Message message) {
        RetrQElt retrQElt = new RetrQElt(n, message);
        this.retrQ.add(retrQElt);
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! retrans Enqueue, size = " + this.retrQ.size() + ", added seq#" + n));
        }
    }

    private int retrQfirstEntryAgeMins() {
        if (this.retrQ.size() == 0) {
            return 0;
        }
        RetrQElt retrQElt = (RetrQElt)this.retrQ.elementAt(0);
        long l = System.currentTimeMillis() - retrQElt.enqueuedAt;
        int n = (int)(l / 60000L);
        return n;
    }

    private void calcRTT(long l) {
        long l2 = System.currentTimeMillis() - l;
        if (l2 == 0L) {
            ++l2;
        }
        int n = this.nACKS++;
        this.aveRTT = ((long)n * this.aveRTT + l2) / (long)this.nACKS;
        this.RTO = (this.aveRTT << 1) + (this.aveRTT >> 1);
        if (this.RTO < this.minRTO) {
            this.RTO = this.minRTO;
        } else if (this.RTO > this.maxRTO) {
            this.RTO = this.maxRTO;
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! RTT = " + l2 + " aveRTT = " + this.aveRTT + "ms" + " RTO = " + this.RTO));
        }
    }

    private Vector sortSackList(String string) {
        Vector<Integer> vector = new Vector<Integer>(1, 1);
        while (string != null) {
            Integer n = new Integer(0);
            int n2 = string.indexOf(",");
            if (n2 == -1) {
                n = new Integer(string);
                string = null;
            } else {
                String string2 = string.substring(0, n2);
                n = new Integer(string2);
                string = string.substring(n2 + 1);
            }
            boolean bl = false;
            int n3 = 0;
            while (n3 < vector.size()) {
                if (n.compareTo((Integer)vector.elementAt(n3)) < 0) {
                    vector.insertElementAt(n, n3);
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (bl) continue;
            vector.add(n);
        }
        return vector;
    }

    private int callAVEIQ(int n) {
        int n2 = this.nIQTests++;
        this.aveIQSize = (n2 * this.aveIQSize + n) / this.nIQTests;
        return this.aveIQSize;
    }

    synchronized void ackReceived(int n, String string) {
        this.lastACKTime = System.currentTimeMillis();
        int n2 = 0;
        int n3 = this.retrQ.size();
        Vector vector = null;
        int n4 = 1;
        if (string != null) {
            vector = this.sortSackList(string);
            n4 = vector.size();
        }
        this.mrrIQFreeSpace = this.rmaxQSize - n4;
        if (n3 == 0) {
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)"TLS!! RETRANS Q EMPTY");
            }
            return;
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! RETRQ(SIZE = " + n3 + "):"));
            int n5 = 0;
            while (n5 < n3) {
                RetrQElt retrQElt = (RetrQElt)this.retrQ.elementAt(n5);
                LOG.info((Object)("r(" + n5 + ")=" + retrQElt.seqnum));
                ++n5;
            }
        }
        long l = 0L;
        while (this.retrQ.size() > 0) {
            RetrQElt retrQElt = (RetrQElt)this.retrQ.elementAt(0);
            if (retrQElt.seqnum > n) break;
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("TLS!! SEQUENTIALLY ACKD SEQN = " + retrQElt.seqnum));
            }
            this.retrQ.remove(0);
            JTlsUtil.removeElements(retrQElt.msg);
            l = retrQElt.enqueuedAt;
            if (l != 0L) {
                this.calcRTT(l);
            }
            retrQElt.msg = null;
            retrQElt = null;
            ++n2;
        }
        if (string != null) {
            RetrQElt retrQElt;
            int n6;
            int n7;
            int n8;
            int n9 = 0;
            int n10 = 0;
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("SACK Vector(" + string + "):"));
                n8 = 0;
                while (n8 < vector.size()) {
                    LOG.info((Object)("v(" + n8 + ")=" + (Integer)vector.elementAt(n8)));
                    ++n8;
                }
            }
            n8 = 0;
            while (n10 < vector.size() && this.retrQ.size() > 0) {
                n8 = (Integer)vector.elementAt(n10++);
                n7 = 0;
                n6 = n9;
                while (n6 < this.retrQ.size()) {
                    retrQElt = (RetrQElt)this.retrQ.elementAt(n6);
                    if (retrQElt.seqnum == n8) {
                        this.retrQ.remove(n6);
                        n9 = n6;
                        ++n2;
                        l = retrQElt.enqueuedAt;
                        if (l != 0L) {
                            this.calcRTT(l);
                        }
                        JTlsUtil.removeElements(retrQElt.msg);
                        retrQElt.msg = null;
                        retrQElt = null;
                        if (LOG.isEnabledFor(Priority.INFO)) {
                            LOG.info((Object)("TLS!! SACKD SEQN = " + n8));
                        }
                        n7 = 1;
                        break;
                    }
                    ++n6;
                }
                if (n7 != 0 || !LOG.isEnabledFor(Priority.INFO)) continue;
                LOG.info((Object)("TLS!! Duplicate SACK = " + n8));
            }
            n7 = vector.size();
            n6 = this.callAVEIQ(n7);
            if (this.retrQ.size() > 0) {
                retrQElt = (RetrQElt)this.retrQ.elementAt(0);
                if (n < n8 && retrQElt.seqnum < n8) {
                    int n11 = 1;
                    int n12 = 5 < this.retrQ.size() ? 5 : this.retrQ.size();
                    n3 = 1;
                    while (n3 < n12) {
                        retrQElt = (RetrQElt)this.retrQ.elementAt(n3);
                        if (retrQElt.seqnum >= n8) break;
                        ++n11;
                        ++n3;
                    }
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("RETR: Fill hole, SACK, Seqnum = " + n + ", Max seqnum = " + n8 + ", Window =" + n11));
                    }
                    this.retransmit(n11);
                    this.sackRetransTime = System.currentTimeMillis();
                }
            }
        }
        if (LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! N ACKED = " + n2));
        }
    }

    private void markRetransmit(Message message) {
        MessageElement messageElement = message.newMessageElement("jxtatls:MARKRetr", null, MARKText, 0, MARKText.length);
        message.addElement(messageElement);
    }

    synchronized int retransmit(int n) {
        int n2;
        int n3 = n2 = this.retrQ.size() < n ? this.retrQ.size() : n;
        if (n2 > 0 && LOG.isEnabledFor(Priority.INFO)) {
            LOG.info((Object)("TLS!! RETRANSMITING [rwindow = " + n3 + "]:"));
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            block6: {
                RetrQElt retrQElt = (RetrQElt)this.retrQ.elementAt(n5);
                try {
                    if (!retrQElt.marked) {
                        this.markRetransmit(retrQElt.msg);
                        retrQElt.marked = true;
                    }
                    Message message = (Message)retrQElt.msg.clone();
                    this.tp.sendToRemoteTls(this.destAddr, message);
                    ++n4;
                    if (LOG.isEnabledFor(Priority.INFO)) {
                        LOG.info((Object)("TLS!! RETRANSMIT SEQN = " + retrQElt.seqnum));
                    }
                }
                catch (IOException iOException) {
                    if (!LOG.isEnabledFor(Priority.INFO)) break block6;
                    LOG.info((Object)("TLS!! IOErr while RETRANS SEQN = " + retrQElt.seqnum));
                }
            }
            ++n5;
        }
        return n4;
    }

    void triggerRetransmission() {
        long l = System.currentTimeMillis() - this.lastACKTime;
        if (l >= this.RTO + this.minRTO) {
            this.retransmit(1);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Retransmitter
    implements Runnable {
        Thread th = new Thread((Runnable)this, "TLS Retransmit thread");
        int nretransmitted = 0;
        int nAtThisRTO = 0;

        public Retransmitter() {
            this.th.setDaemon(true);
            this.th.start();
            if (LOG.isEnabledFor(Priority.INFO)) {
                LOG.info((Object)("TLS!! STARTED TLS Retransmit thread, RTO = " + JTlsOutputStream.this.RTO));
            }
        }

        public int getRetransCount() {
            return this.nretransmitted;
        }

        public void run() {
            int n = 0;
            JTlsOutputStream.this.sackRetransTime = System.currentTimeMillis();
            while (true) {
                try {
                    Thread.currentThread();
                    Thread.sleep(JTlsOutputStream.this.RTO);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long l = System.currentTimeMillis() - JTlsOutputStream.this.sackRetransTime;
                if (l < JTlsOutputStream.this.RTO) {
                    if (!LOG.isEnabledFor(Priority.INFO)) continue;
                    LOG.info((Object)("RETR: No retrans, sack retrans " + l + " ms ago"));
                    continue;
                }
                long l2 = System.currentTimeMillis() - JTlsOutputStream.this.lastACKTime;
                long l3 = 0L;
                if (JTlsOutputStream.this.retrQ.size() > 0) {
                    l3 = System.currentTimeMillis() - ((RetrQElt)JTlsOutputStream.this.retrQ.elementAt((int)0)).enqueuedAt;
                }
                long l4 = l2 = l2 < l3 ? l3 : l2;
                if (l2 >= JTlsOutputStream.this.RTO && l3 >= JTlsOutputStream.this.RTO) {
                    int n2 = JTlsOutputStream.this.retransmit(5);
                    this.nretransmitted += n2;
                    this.nAtThisRTO += n2 == 0 ? 0 : n2;
                    if (n2 > 0 && l2 >= 2L * JTlsOutputStream.this.RTO && this.nAtThisRTO >= 10) {
                        JTlsOutputStream.this.RTO = l2 > JTlsOutputStream.this.maxRTO ? JTlsOutputStream.this.maxRTO : 2L * JTlsOutputStream.this.RTO;
                        this.nAtThisRTO = 0;
                    }
                    if (!LOG.isEnabledFor(Priority.INFO)) continue;
                    LOG.info((Object)("TLS!! RETR: RTO(" + this.nAtThisRTO + ") = " + JTlsOutputStream.this.RTO + " N RETRANS = " + n2));
                    continue;
                }
                if (++n == 2) {
                    JTlsOutputStream.this.RTO = JTlsOutputStream.this.minRTO;
                    n = 0;
                }
                if (!LOG.isEnabledFor(Priority.INFO)) continue;
                LOG.info((Object)("TLS!! RETR IDLE: RTO = " + JTlsOutputStream.this.RTO + " WAIT = " + l2));
            }
        }
    }

    private class RetrQElt {
        int seqnum;
        long enqueuedAt;
        Message msg;
        boolean marked;

        public RetrQElt(int n, Message message) {
            this.seqnum = n;
            this.msg = message;
            this.enqueuedAt = System.currentTimeMillis();
            this.marked = false;
        }
    }
}

