/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointMessenger;
import net.jxta.endpoint.Message;
import net.jxta.impl.endpoint.EndpointReceiveQueue;
import net.jxta.impl.endpoint.MessageWireFormatFactory;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class HttpClientConnection
implements EndpointMessenger,
Runnable {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$servlethttp$HttpClientConnection == null ? (class$net$jxta$impl$endpoint$servlethttp$HttpClientConnection = HttpClientConnection.class$("net.jxta.impl.endpoint.servlethttp.HttpClientConnection")) : class$net$jxta$impl$endpoint$servlethttp$HttpClientConnection).getName());
    public static final int MaxNbOfMessages = 40;
    private URL url = null;
    private boolean waiting = false;
    private long lastUsed = 0L;
    private Thread thread = null;
    private EndpointReceiveQueue queue = null;
    private long nbOfMessagesSent = 0L;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$servlethttp$HttpClientConnection;

    public HttpClientConnection(URL uRL) {
        this.url = uRL;
    }

    private synchronized void setThreadName() {
        block3: {
            if (this.thread != null) {
                try {
                    this.thread.setName("HTTP Connection to " + this.url.toString() + " [" + this.queue.getNbOfQueuedMessages() + ", " + this.nbOfMessagesSent + " ]");
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.ERROR)) break block3;
                    LOG.error((Object)"Cannot change thread name", (Throwable)exception);
                }
            }
        }
    }

    private void doSendMessage(Message message) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.connect();
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.flush();
        MessageWireFormatFactory.newMessageWireFormat(new MimeMediaType("application/x-jxta-msg")).writeMessage(outputStream, message);
        outputStream.flush();
        outputStream.close();
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            throw new IOException("Message not accepted: HTTP status code=" + n + " reason=" + httpURLConnection.getResponseMessage());
        }
        ++this.nbOfMessagesSent;
        this.setThreadName();
    }

    public void sendMessage(Message message) throws IOException {
        this.connect();
        HttpClientConnection httpClientConnection = this;
        synchronized (httpClientConnection) {
            this.queue.push(message);
        }
        this.setThreadName();
        Thread.yield();
    }

    public void run() {
        Message message = null;
        try {
            while (true) {
                message = this.queue.waitForMessage();
                this.setThreadName();
                this.doSendMessage(message);
            }
        }
        catch (InterruptedException interruptedException) {
            this.thread = null;
            return;
        }
        catch (IOException iOException) {
            this.notifyFailure();
            this.thread = null;
            return;
        }
    }

    private void connect() {
        HttpClientConnection httpClientConnection = this;
        synchronized (httpClientConnection) {
            if (this.queue == null) {
                this.queue = new EndpointReceiveQueue();
                this.queue.setMaxNbOfMessages(40);
            }
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread((Runnable)this, "HTTP Connection to " + this.url.toString() + " [Unused]");
            this.thread.start();
        }
        Thread.yield();
    }

    private synchronized void notifyFailure() {
        this.close();
    }

    public synchronized void close() {
        block4: {
            if (this.queue != null) {
                this.queue.close();
                this.queue = null;
            }
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread = null;
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block4;
                    LOG.warn((Object)("Cannot interrupt thread for " + this.url.toString()), (Throwable)exception);
                }
            }
        }
    }

    public synchronized long getLastUsed() {
        return this.lastUsed;
    }

    public synchronized void setLastUsed(long l) {
        this.lastUsed = l;
    }

    public void finalize() {
        this.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

