/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Vector;
import net.jxta.impl.endpoint.http.HttpMessage;
import net.jxta.impl.endpoint.http.HttpTransport;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

class HttpServer
extends Thread {
    private static final Category LOG = Category.getInstance((String)(class$net$jxta$impl$endpoint$http$HttpServer == null ? (class$net$jxta$impl$endpoint$http$HttpServer = HttpServer.class$("net.jxta.impl.endpoint.http.HttpServer")) : class$net$jxta$impl$endpoint$http$HttpServer).getName());
    public static final int MaxCnxBacklog = 50;
    private HttpTransport owner;
    private UnicastThreadPool unicastPool;
    private ServerSocket serverSocket;
    private HashMap clientConnections;
    static /* synthetic */ Class class$net$jxta$impl$endpoint$http$HttpServer;

    public HttpServer(ThreadGroup threadGroup, HttpTransport httpTransport, InetAddress inetAddress, int n) {
        block6: {
            super(threadGroup, null, "Server Listener");
            this.owner = null;
            this.unicastPool = null;
            this.clientConnections = new HashMap();
            this.owner = httpTransport;
            this.unicastPool = new UnicastThreadPool();
            this.unicastPool.createThreads();
            try {
                this.serverSocket = new ServerSocket(n, 50, inetAddress);
            }
            catch (BindException bindException) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)("[1] Cannot bind ServerSocket on port: " + n + " because port is in use or disallowed."));
                }
            }
            catch (IOException iOException) {
                if (LOG.isEnabledFor(Priority.FATAL)) {
                    LOG.fatal((Object)("[1] Canot create ServerSocket on port " + n), (Throwable)iOException);
                }
            }
            catch (SecurityException securityException) {
                if (!LOG.isEnabledFor(Priority.FATAL)) break block6;
                LOG.fatal((Object)("[1] Canot create ServerSocket on port " + n), (Throwable)securityException);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            if (HttpServer.LOG.isEnabledFor(Priority.DEBUG)) {
                HttpServer.LOG.debug((Object)"Server is ready to receive request");
            }
            while (true) lbl-1000:
            // 5 sources

            {
                try {
                    while (true) {
                        block15: {
                            if (null == (var1_1 = this.unicastPool.getIncomingThread(0L))) {
                                continue;
                            }
                            var2_4 = this.serverSocket.accept();
                            if (HttpServer.LOG.isEnabledFor(Priority.DEBUG)) {
                                HttpServer.LOG.debug((Object)(var2_4.getInetAddress().getHostAddress() + ":" + var2_4.getPort() + " connected on " + var1_1.getName()));
                            }
                            try {
                                var2_4.setSoLinger(true, 30000);
                                var2_4.setSoTimeout(30000);
                            }
                            catch (Exception var3_7) {
                                if (!HttpServer.LOG.isEnabledFor(Priority.DEBUG)) break block15;
                                HttpServer.LOG.debug((Object)"setting socket options failed ", (Throwable)var3_7);
                            }
                        }
                        var3_6 = var1_1;
                        synchronized (var3_6) {
                            var1_1.setSocket(var2_4);
                            var1_1.notify();
                        }
                    }
                }
                catch (IOException var1_2) {
                    if (!HttpServer.LOG.isEnabledFor(Priority.DEBUG)) ** GOTO lbl-1000
                    HttpServer.LOG.debug((Object)("[1] ServerSocket.accept() on port " + this.serverSocket.getLocalPort() + " has failed."), (Throwable)var1_2);
                }
                catch (SecurityException var2_5) {
                    if (!HttpServer.LOG.isEnabledFor(Priority.DEBUG)) ** GOTO lbl-1000
                    HttpServer.LOG.debug((Object)("[2] ServerSocket.accept() on port " + this.serverSocket.getLocalPort() + " has failed."), (Throwable)var2_5);
                    continue;
                }
                break;
            }
        }
        catch (Throwable var1_3) {
            if (HttpServer.LOG.isEnabledFor(Priority.FATAL)) {
                HttpServer.LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), var1_3);
            }
            return;
        }
        ** GOTO lbl-1000
    }

    synchronized boolean addClientConnection(String string, Socket socket, InputStream inputStream, OutputStream outputStream) {
        ClientConnection clientConnection;
        ClientConnection clientConnection2 = new ClientConnection(string, socket, inputStream, outputStream);
        if (LOG.isEnabledFor(Priority.DEBUG)) {
            LOG.debug((Object)("Adding new client connection for " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort() + (null != inputStream ? " I " : "   ") + (null != outputStream ? " O " : "   ")));
        }
        if (null != (clientConnection = this.clientConnections.put(string, clientConnection2))) {
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"Closing previous connection to client");
            }
            clientConnection.close();
        }
        return null == clientConnection;
    }

    synchronized ClientConnection getClientConnection(String string) {
        ClientConnection clientConnection = (ClientConnection)this.clientConnections.remove(string);
        return clientConnection;
    }

    void sendMessageToClient(String string, Vector vector, long l) {
        block10: {
            ClientConnection clientConnection;
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendMessageToClient");
            }
            if ((clientConnection = this.getClientConnection(string)) != null) {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"  Using client connection");
                }
                String string2 = "<Code>" + Integer.toString(4) + "</" + "Code" + ">" + "<" + "Msg" + ">\n";
                String string3 = "</Msg>";
                try {
                    vector.insertElementAt(string2.getBytes(), 0);
                    vector.addElement(string3.getBytes());
                }
                catch (Exception exception) {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"sendMessageToClient failed ", (Throwable)exception);
                    }
                    return;
                }
                clientConnection.sendToClient(vector, l + (long)string2.length() + (long)string3.length());
            } else {
                if (LOG.isEnabledFor(Priority.WARN)) {
                    LOG.warn((Object)("   Storing into the spooler for " + string));
                }
                try {
                    String string4 = this.owner.HttpSpool + File.separatorChar + string;
                    String string5 = HttpTransport.cm.createTmpName(string4);
                    HttpMessage httpMessage = new HttpMessage(string4, string5, vector);
                }
                catch (Exception exception) {
                    if (!LOG.isEnabledFor(Priority.WARN)) break block10;
                    LOG.warn((Object)"sendMessageToClient: failed to spool message", (Throwable)exception);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ClientConnection {
        private String clientId = null;
        public Socket inputSocket = null;
        public InputStream inputStream = null;
        public OutputStream outputStream = null;

        ClientConnection(String string, Socket socket, InputStream inputStream, OutputStream outputStream) {
            this.clientId = string;
            this.inputSocket = socket;
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        public void sendToClient(Vector vector, long l) {
            block13: {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)"sendToClient begins");
                }
                if (this.outputStream == null && this.inputSocket != null) {
                    try {
                        this.outputStream = this.inputSocket.getOutputStream();
                    }
                    catch (IOException iOException) {
                        if (!LOG.isEnabledFor(Priority.DEBUG)) break block13;
                        LOG.debug((Object)"failed to get outputstream for socket", (Throwable)iOException);
                    }
                }
            }
            if (this.outputStream == null) {
                String string = ((HttpServer)HttpServer.this).owner.HttpSpool + File.separatorChar + this.clientId;
                HttpServer.this.owner;
                String string2 = HttpTransport.cm.createTmpName(string);
                try {
                    if (LOG.isEnabledFor(Priority.DEBUG)) {
                        LOG.debug((Object)"sendToClient: spooling message ");
                    }
                    Vector<ByteArrayInputStream> vector2 = new Vector<ByteArrayInputStream>();
                    int n = 0;
                    while (n < vector.size()) {
                        vector2.addElement(new ByteArrayInputStream((byte[])vector.elementAt(n)));
                        ++n;
                    }
                    SequenceInputStream sequenceInputStream = new SequenceInputStream(vector2.elements());
                    HttpServer.this.owner;
                    HttpTransport.cm.saveBytes(string, string2, sequenceInputStream);
                }
                catch (Exception exception) {
                    if (LOG.isEnabledFor(Priority.WARN)) {
                        LOG.warn((Object)"sendToClient failed spooling a message", (Throwable)exception);
                    }
                }
            } else {
                if (LOG.isEnabledFor(Priority.DEBUG)) {
                    LOG.debug((Object)("Sending response on waiting socket to " + this.inputSocket.getInetAddress().getHostAddress() + ":" + this.inputSocket.getPort()));
                }
                HttpTransport.sendResponse(this.outputStream, vector, l);
                this.close();
            }
            if (LOG.isEnabledFor(Priority.DEBUG)) {
                LOG.debug((Object)"sendToClient finished");
            }
        }

        public void close() {
            HttpTransport.closeSocket(this.inputSocket, this.inputStream, this.outputStream);
            this.clientId = null;
            this.inputSocket = null;
            this.inputStream = null;
            this.outputStream = null;
        }

        protected void finalize() {
            this.close();
        }
    }

    class IncomingUnicastThread
    extends Thread {
        HttpTransport tp = null;
        Socket socket = null;

        private IncomingUnicastThread(String string) {
            super(HttpServer.this.getThreadGroup(), null, "incoming unicast " + string);
        }

        void setSocket(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            block8: {
                try {
                    IncomingUnicastThread incomingUnicastThread = this;
                    synchronized (incomingUnicastThread) {
                        while (true) {
                            HttpServer.this.unicastPool.availableThread(this);
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.interrupted();
                            }
                            if (null == this.socket) break;
                            HttpServer.this.owner.runReceive(this.socket);
                            this.socket = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!LOG.isEnabledFor(Priority.FATAL)) break block8;
                    LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), throwable);
                }
            }
            HttpServer.this.unicastPool.threadDied(this);
        }
    }

    class UnicastThreadPool {
        public static final int DefaultNbOfUnicastThreads = 5;
        public static final int MaxNbOfUnicastThreads = 25;
        private volatile int unicastThreads = 0;
        private volatile int unicastThreadNumber = 0;
        private Vector threadPool = new Vector(25);

        public void createThreads() {
            this.createThreads(5);
        }

        public void createThreads(int n) {
            n = Math.min(n, 25);
            int n2 = 1;
            while (n2 <= n) {
                this.newIncomingThread();
                ++n2;
            }
        }

        private void newIncomingThread() {
            Vector vector = this.threadPool;
            synchronized (vector) {
                ++this.unicastThreads;
                new IncomingUnicastThread(Integer.toString(++this.unicastThreadNumber)).start();
            }
        }

        IncomingUnicastThread getIncomingThread(long l) throws InterruptedException {
            IncomingUnicastThread incomingUnicastThread = null;
            long l2 = System.currentTimeMillis() + l;
            while (true) {
                Vector vector = this.threadPool;
                synchronized (vector) {
                    if (this.threadPool.size() > 0) {
                        incomingUnicastThread = (IncomingUnicastThread)this.threadPool.lastElement();
                        this.threadPool.removeElementAt(this.threadPool.size() - 1);
                        break;
                    }
                    if (this.unicastThreads < 25) {
                        this.newIncomingThread();
                        if (LOG.isEnabledFor(Priority.DEBUG)) {
                            LOG.debug((Object)("Made a new unicast thread (#" + this.unicastThreadNumber + " of " + this.unicastThreads + " total)"));
                        }
                    }
                    this.threadPool.wait(l);
                    if (this.threadPool.size() > 0) {
                        incomingUnicastThread = (IncomingUnicastThread)this.threadPool.lastElement();
                        this.threadPool.removeElementAt(this.threadPool.size() - 1);
                        break;
                    }
                    if (0L != l && (l = l2 - System.currentTimeMillis()) <= 0L) {
                        break;
                    }
                }
            }
            return incomingUnicastThread;
        }

        public void availableThread(IncomingUnicastThread incomingUnicastThread) {
            Vector vector = this.threadPool;
            synchronized (vector) {
                this.threadPool.addElement(incomingUnicastThread);
                this.threadPool.notify();
            }
        }

        public void threadDied(IncomingUnicastThread incomingUnicastThread) {
            Vector vector = this.threadPool;
            synchronized (vector) {
                --this.unicastThreads;
                this.threadPool.removeElement(incomingUnicastThread);
            }
        }
    }
}

