/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.impl.config.CodeDescriptor;
import net.jxta.impl.config.ConfigUtil;
import net.jxta.impl.config.ConfigurationException;
import net.jxta.impl.config.HttpConfig;
import net.jxta.impl.config.TcpConfig;
import net.jxta.impl.endpoint.Address;

public class Config {
    private Hashtable mServiceCodeDescriptors = new Hashtable();
    private CodeDescriptor mInitialPlatform;
    private CodeDescriptor mInitialApp;
    private TcpConfig mTcpConfig = null;
    private HttpConfig mHttpConfig = null;
    private Vector mRendezvousPeers = new Vector();
    private boolean mIsRouter;
    private boolean mIsRendezvous;
    private boolean mShouldPropagate;
    public static final String SERVICE_DISCOVERY = "DiscoveryService";
    public static final String SERVICE_MEMBERSHIP = "MembershipService";
    public static final String SERVICE_PIPE = "PipeService";
    public static final String SERVICE_PEERINFO = "PeerInfoService";
    public static final String SERVICE_RESOLVER = "ResolverService";
    private static final String[] SERVICE_KEYS = new String[]{"DiscoveryService", "MembershipService", "PipeService", "PeerInfoService", "ResolverService"};
    private static final String JXTA_CODEBASE = "http://www.jxta.org/download/jxta.jar";

    public static Config createDefaultConfig() {
        try {
            Config config = new Config();
            config.setServiceImplDescriptor(SERVICE_DISCOVERY, new CodeDescriptor("net.jxta.impl.discovery.DiscoveryService", JXTA_CODEBASE));
            config.setServiceImplDescriptor(SERVICE_PIPE, new CodeDescriptor("net.jxta.impl.pipe.PipeService", JXTA_CODEBASE));
            config.setServiceImplDescriptor(SERVICE_PEERINFO, new CodeDescriptor("net.jxta.impl.peer.PeerInfoService", JXTA_CODEBASE));
            config.setServiceImplDescriptor(SERVICE_RESOLVER, new CodeDescriptor("net.jxta.impl.resolver.ResolverService", JXTA_CODEBASE));
            config.setServiceImplDescriptor(SERVICE_MEMBERSHIP, new CodeDescriptor("net.jxta.impl.membership.NullMembershipService", JXTA_CODEBASE));
            config.setRendezvous(false);
            config.addRendezvousPeer(new Address("tcp://129.144.36.190:6001"));
            config.addRendezvousPeer(new Address("tcp://jxta.dioxine.net:6001"));
            config.addRendezvousPeer(new Address("http://jxta.dioxine.net:6002"));
            config.setShouldPropagate(false);
            config.setTcpConfig(TcpConfig.createDefaultConfig());
            config.setHttpConfig(HttpConfig.createDefaultConfig());
            config.setInitialPlatform(new CodeDescriptor("net.jxta.impl.peergroup.StartNetPeerGroup", JXTA_CODEBASE));
            config.setInitialApp(new CodeDescriptor("net.jxta.impl.shell.bin.Shell.Shell", JXTA_CODEBASE));
            return config;
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException("Fatal error with default config");
        }
    }

    public CodeDescriptor getServiceImplDescriptor(String string) {
        return (CodeDescriptor)this.mServiceCodeDescriptors.get(string);
    }

    public void setServiceImplDescriptor(String string, CodeDescriptor codeDescriptor) throws ConfigurationException {
        try {
            this.mServiceCodeDescriptors.put(string, codeDescriptor);
        }
        catch (NullPointerException nullPointerException) {
            throw new ConfigurationException("Null service key provided", nullPointerException);
        }
    }

    public boolean isRendezvous() {
        return this.mIsRendezvous;
    }

    public void setRendezvous(boolean bl) {
        this.mIsRendezvous = bl;
    }

    public boolean isRouter() {
        return this.mIsRouter;
    }

    public void setRouter(boolean bl) {
        this.mIsRouter = bl;
    }

    public TcpConfig getTcpConfig() {
        return this.mTcpConfig;
    }

    public void setTcpConfig(TcpConfig tcpConfig) {
        this.mTcpConfig = tcpConfig;
    }

    public HttpConfig getHttpConfig() {
        return this.mHttpConfig;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.mHttpConfig = httpConfig;
    }

    public CodeDescriptor getInitialPlatform() {
        return this.mInitialPlatform;
    }

    public void setInitialPlatform(CodeDescriptor codeDescriptor) {
        this.mInitialPlatform = codeDescriptor;
    }

    public CodeDescriptor getInitialApp() {
        return this.mInitialApp;
    }

    public void setInitialApp(CodeDescriptor codeDescriptor) {
        this.mInitialApp = codeDescriptor;
    }

    public void addRendezvousPeer(EndpointAddress endpointAddress) {
        this.mRendezvousPeers.addElement(endpointAddress);
    }

    public Enumeration getRendezvousPeers() {
        return this.mRendezvousPeers.elements();
    }

    public void clearRendezvousPeers() {
        this.mRendezvousPeers = new Vector();
    }

    public boolean getShouldPropagate() {
        return this.mShouldPropagate;
    }

    public void setShouldPropagate(boolean bl) {
        this.mShouldPropagate = bl;
    }

    public static Config read(InputStream inputStream) throws ConfigurationException {
        try {
            Config config = new Config();
            StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), inputStream);
            config.readConfig(structuredTextDocument);
            return config;
        }
        catch (ConfigurationException configurationException) {
            throw configurationException;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Fatal error reading configuration file", exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readConfig(StructuredTextDocument var1_1) throws ConfigurationException {
        var2_2 = var1_1.getChildren();
        if (var2_2 != null && var2_2.hasMoreElements()) ** GOTO lbl6
        throw new ConfigurationException("Configuration file is empty or corrupted");
lbl-1000:
        // 1 sources

        {
            var3_3 = (TextElement)var2_2.nextElement();
            this.readElement(var3_3);
lbl6:
            // 2 sources

            ** while (var2_2.hasMoreElements())
        }
lbl7:
        // 1 sources

    }

    private void readElement(TextElement textElement) throws ConfigurationException {
        String string = textElement.getName();
        if (string.equals("IsRouter")) {
            this.mIsRouter = new Boolean(textElement.getTextValue());
        } else if (string.equals("IsRendezvous")) {
            this.mIsRendezvous = Boolean.valueOf(textElement.getTextValue());
        } else if (string.equals("RendezvousPeers")) {
            this.readRendezvousPeers(textElement);
        } else if (string.equals("Services")) {
            this.readServices(textElement);
        } else if (string.equals("InitialPlatform")) {
            this.readInitPlatform(textElement);
        } else if (string.equals("InitialApp")) {
            this.readInitApp(textElement);
        } else if (string.equals("TCP")) {
            this.readTcp(textElement);
        } else if (string.equals("HTTP")) {
            this.readHttp(textElement);
        } else if (string.equals("ShouldPropagate")) {
            this.mShouldPropagate = Boolean.valueOf(textElement.getTextValue());
        } else {
            System.err.println("Unknown element seen during config read: " + string);
        }
    }

    private void readServices(TextElement textElement) throws ConfigurationException {
        Enumeration enumeration = textElement.getChildren();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TextElement textElement2 = (TextElement)enumeration.nextElement();
                if (textElement2 == null) continue;
                String string = textElement2.getName();
                CodeDescriptor codeDescriptor = CodeDescriptor.newFromXML(textElement2);
                if (codeDescriptor == null) continue;
                this.setServiceImplDescriptor(string, codeDescriptor);
            }
        }
    }

    private void readRendezvousPeers(TextElement textElement) throws ConfigurationException {
        Enumeration enumeration = textElement.getChildren();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TextElement textElement2 = (TextElement)enumeration.nextElement();
                this.addRendezvousPeer(new Address(textElement2.getTextValue()));
            }
        }
    }

    private void readInitPlatform(TextElement textElement) {
        this.mInitialPlatform = CodeDescriptor.newFromXML(textElement);
    }

    private void readInitApp(TextElement textElement) {
        this.mInitialApp = CodeDescriptor.newFromXML(textElement);
    }

    private void readHttp(TextElement textElement) {
        this.mHttpConfig = HttpConfig.newFromXML(textElement);
    }

    private void readTcp(TextElement textElement) {
        this.mTcpConfig = TcpConfig.newFromXML(textElement);
    }

    public void write(Writer writer) throws ConfigurationException {
        try {
            StructuredTextDocument structuredTextDocument = null;
            structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(new MimeMediaType("text/xml"), "jxta:config");
            this.writeConfig(structuredTextDocument);
            structuredTextDocument.sendToWriter(writer);
        }
        catch (ConfigurationException configurationException) {
            throw configurationException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ConfigurationException("Fatal error during configuration write.", exception);
        }
    }

    private void writeConfig(StructuredTextDocument structuredTextDocument) throws ConfigurationException {
        if (this.mHttpConfig != null) {
            this.mHttpConfig.writeToXML(structuredTextDocument);
        }
        if (this.mTcpConfig != null) {
            this.mTcpConfig.writeToXML(structuredTextDocument);
        }
        TextElement textElement = null;
        textElement = structuredTextDocument.createElement("IsRouter", new Boolean(this.mIsRouter).toString());
        structuredTextDocument.appendChild((Element)textElement);
        this.writeRendezvousServer(structuredTextDocument);
        structuredTextDocument.appendChild(structuredTextDocument.createElement("ShouldPropagate", String.valueOf(this.mShouldPropagate)));
        this.writeServices(structuredTextDocument, this.mServiceCodeDescriptors);
        textElement = structuredTextDocument.createElement("InitialApp");
        structuredTextDocument.appendChild((Element)textElement);
        this.getInitialApp().writeToXML(structuredTextDocument, textElement);
        textElement = structuredTextDocument.createElement("InitialPlatform");
        structuredTextDocument.appendChild((Element)textElement);
        this.getInitialPlatform().writeToXML(structuredTextDocument, textElement);
        structuredTextDocument.appendChild((Element)textElement);
    }

    private void writeRendezvousServer(StructuredTextDocument structuredTextDocument) {
        this.writeRendezvousPeers(structuredTextDocument, this.getRendezvousPeers());
        structuredTextDocument.appendChild(structuredTextDocument.createElement("IsRendezvous", new Boolean(this.isRendezvous()).toString()));
    }

    private void writeRendezvousPeers(StructuredTextDocument structuredTextDocument, Enumeration enumeration) {
        TextElement textElement = structuredTextDocument.createElement("RendezvousPeers");
        structuredTextDocument.appendChild((Element)textElement);
        while (enumeration.hasMoreElements()) {
            EndpointAddress endpointAddress = (EndpointAddress)enumeration.nextElement();
            ConfigUtil.writeAddress(structuredTextDocument, textElement, endpointAddress, "RendezvousPeer");
        }
    }

    private void writeServices(StructuredTextDocument structuredTextDocument, Hashtable hashtable) throws ConfigurationException {
        TextElement textElement = structuredTextDocument.createElement("Services");
        structuredTextDocument.appendChild((Element)textElement);
        int n = 0;
        while (n < SERVICE_KEYS.length) {
            CodeDescriptor codeDescriptor = (CodeDescriptor)hashtable.get(SERVICE_KEYS[n]);
            if (codeDescriptor == null) {
                throw new ConfigurationException("Service " + SERVICE_KEYS[n] + " not configured");
            }
            TextElement textElement2 = structuredTextDocument.createElement(SERVICE_KEYS[n]);
            textElement.appendChild((Element)textElement2);
            codeDescriptor.writeToXML(structuredTextDocument, textElement2);
            ++n;
        }
    }

    private static void main(String[] stringArray) throws Exception {
        Config config = Config.createDefaultConfig();
        File file = new File("first.xml");
        File file2 = new File("second.xml");
        FileWriter fileWriter = new FileWriter(file);
        FileWriter fileWriter2 = new FileWriter(file2);
        try {
            config.write(fileWriter);
            fileWriter.close();
            Config config2 = Config.read(new FileInputStream(file));
            config2.write(fileWriter2);
            fileWriter2.close();
        }
        catch (ConfigurationException configurationException) {
            System.err.println(configurationException);
            configurationException.getNestedException().printStackTrace();
            configurationException.printStackTrace();
        }
    }
}

