/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.credential;

import net.jxta.credential.Credential;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.id.ID;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;

public final class AuthenticationCredential
implements Credential {
    private String authenticationMethod = null;
    private Element identityInfo = null;
    private PeerGroup peergroup = null;

    public AuthenticationCredential(PeerGroup peerGroup, String string, Element element) {
        this.peergroup = peerGroup;
        this.authenticationMethod = string;
        if (null != element) {
            this.identityInfo = element;
        }
    }

    public MembershipService getSourceService() {
        return null;
    }

    public ID getPeerGroupID() {
        return this.peergroup.getPeerGroupID();
    }

    public ID getPeerID() {
        return this.peergroup.getPeerID();
    }

    public String getMethod() {
        return this.authenticationMethod;
    }

    public Element getIdentityInfo() {
        return this.identityInfo;
    }

    public StructuredDocument getDocument(MimeMediaType mimeMediaType) throws Exception {
        StructuredDocument structuredDocument = StructuredDocumentFactory.newStructuredDocument(mimeMediaType, "AuthenticationCredential");
        Element element = structuredDocument.createElement("Method", this.getMethod());
        structuredDocument.appendChild(element);
        element = structuredDocument.createElement("PeerGroupID", this.getPeerGroupID().toString());
        structuredDocument.appendChild(element);
        element = structuredDocument.createElement("PeerID", this.getPeerID().toString());
        structuredDocument.appendChild(element);
        if (null != this.identityInfo) {
            element = structuredDocument.createElement("IdentityInfo");
            structuredDocument.appendChild(element);
            StructuredDocumentUtils.copyElements(structuredDocument, element, this.identityInfo);
        }
        return structuredDocument;
    }
}

