/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.tomcat4.config;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.ajp.tomcat4.config.BaseJkConfig;
import org.apache.catalina.Context;

public class NSConfig
extends BaseJkConfig {
    public static final String WORKERS_CONFIG = "/conf/jk/workers.properties";
    public static final String NS_CONFIG = "/conf/auto/obj.conf";
    public static final String NSAPI_LOG_LOCATION = "/logs/nsapi_redirect.log";
    public static final String NSAPI_REDIRECTOR;
    private File objConfig = null;
    private File nsapiJk = null;
    private String objectName = "servlet";

    static {
        String os = System.getProperty("os.name").toLowerCase();
        NSAPI_REDIRECTOR = os.indexOf("windows") >= 0 ? "bin/nsapi_redirect.dll" : (os.indexOf("netware") >= 0 ? "bin/nsapi_rd.nlm" : "bin/nsapi_redirector.so");
    }

    protected boolean addMapping(String fullPath, PrintWriter objfile) {
        if (this.debug > 0) {
            this.log("Adding map for " + fullPath);
        }
        objfile.println("NameTrans fn=\"assign-name\" from=\"" + fullPath + "\" name=\"" + this.objectName + "\"");
        return true;
    }

    protected boolean addMapping(String ctxPath, String ext, PrintWriter objfile) {
        if (this.debug > 0) {
            this.log("Adding extension map for " + ctxPath + "/*." + ext);
        }
        if (!ext.startsWith("/")) {
            ext = "/" + ext;
        }
        if (ext.length() > 1) {
            objfile.println("NameTrans fn=\"assign-name\" from=\"" + ctxPath + ext + "\" name=\"" + this.objectName + "\"");
        }
        return true;
    }

    protected void generateContextMappings(Context context, PrintWriter objfile) {
        String loginPage;
        String nPath;
        String ctxPath = context.getPath();
        String string = nPath = "".equals(ctxPath) ? "/" : ctxPath;
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in non-forward-all mode  ");
            return;
        }
        objfile.println("<Object name=" + context.getName() + ">");
        objfile.println("#########################################################");
        objfile.println("# Auto configuration for the " + nPath + " context starts.");
        objfile.println("#########################################################");
        objfile.println();
        if (context.getLoginConfig() != null && (loginPage = context.getLoginConfig().getLoginPage()) != null) {
            int lpos = loginPage.lastIndexOf("/");
            String jscurl = String.valueOf(loginPage.substring(0, lpos + 1)) + "j_security_check";
            this.addMapping(ctxPath, jscurl, objfile);
        }
        String[] servletMaps = context.findServletMappings();
        int ii = 0;
        while (ii < servletMaps.length) {
            this.addMapping(ctxPath, servletMaps[ii], objfile);
            ++ii;
        }
        objfile.println("</Object>");
    }

    protected boolean generateJkHead(PrintWriter mod_jk) {
        this.log("Generating netscape web server config = " + this.objConfig);
        this.generateNsapiHead(mod_jk);
        mod_jk.println("<Object name=default>");
        return true;
    }

    protected void generateJkTail(PrintWriter objfile) {
        objfile.println();
        objfile.println("#######################################################");
        objfile.println("# Protecting the WEB-INF and META-INF directories.");
        objfile.println("#######################################################");
        objfile.println("PathCheck fn=\"deny-existence\" path=\"*/WEB-INF/*\"");
        objfile.println("PathCheck fn=\"deny-existence\" path=\"*/META-INF/*\"");
        objfile.println();
        objfile.println("</Object>");
        objfile.println();
        objfile.println("#######################################################");
        objfile.println("# New object to execute your servlet requests.");
        objfile.println("#######################################################");
        objfile.println("<Object name=" + this.objectName + ">");
        objfile.println("ObjectType fn=force-type type=text/html");
        objfile.println("Service fn=\"jk_service\" worker=\"" + this.jkWorker + "\" path=\"/*\"");
        objfile.println("</Object>");
        objfile.println();
    }

    private void generateNsapiHead(PrintWriter objfile) {
        objfile.println("###################################################################");
        objfile.println("# Auto generated configuration. Dated: " + new Date());
        objfile.println("###################################################################");
        objfile.println();
        objfile.println("#");
        objfile.println("# You will need to merge the content of this file with your ");
        objfile.println("# regular obj.conf and then restart (=stop + start) your Netscape server. ");
        objfile.println("#");
        objfile.println();
        objfile.println("#");
        objfile.println("# Loading the redirector into your server");
        objfile.println("#");
        objfile.println();
        objfile.println("Init fn=\"load-modules\" funcs=\"jk_init,jk_service\" shlib=\"<put full path to the redirector here>\"");
        objfile.println("Init fn=\"jk_init\" worker_file=\"" + this.workersConfig.toString().replace('\\', '/') + "\" log_level=\"" + this.jkDebug + "\" log_file=\"" + this.jkLog.toString().replace('\\', '/') + "\"");
        objfile.println();
    }

    protected void generateStupidMappings(Context context, PrintWriter objfile) {
        String nPath;
        String ctxPath = context.getPath();
        String string = nPath = "".equals(ctxPath) ? "/" : ctxPath;
        if (this.noRoot && "".equals(ctxPath)) {
            this.log("Ignoring root context in forward-all mode  ");
            return;
        }
        objfile.println("<Object name=" + context.getName() + ">");
        objfile.println("NameTrans fn=\"assign-name\" from=\"" + ctxPath + "\" name=\"" + this.objectName + "\"");
        objfile.println("NameTrans fn=\"assign-name\" from=\"" + ctxPath + "/*\" name=\"" + this.objectName + "\"");
        objfile.println("</Object>");
    }

    protected PrintWriter getWriter() throws IOException {
        String abObjConfig = this.objConfig.getAbsolutePath();
        return new PrintWriter(new FileWriter(abObjConfig, this.append));
    }

    protected void initProperties() {
        super.initProperties();
        this.objConfig = BaseJkConfig.getConfigFile(this.objConfig, this.configHome, NS_CONFIG);
        this.workersConfig = BaseJkConfig.getConfigFile(this.workersConfig, this.configHome, WORKERS_CONFIG);
        this.nsapiJk = this.nsapiJk == null ? new File(NSAPI_REDIRECTOR) : BaseJkConfig.getConfigFile(this.nsapiJk, this.configHome, NSAPI_REDIRECTOR);
        this.jkLog = BaseJkConfig.getConfigFile(this.jkLog, this.configHome, NSAPI_LOG_LOCATION);
    }

    public void setNsapiJk(String path) {
        this.nsapiJk = path == null ? null : new File(path);
    }

    public void setObjConfig(String path) {
        this.objConfig = path == null ? null : new File(path);
    }

    public void setObjectName(String name) {
        this.objectName = name;
    }
}

