/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.signature;

import jxta.security.exceptions.CryptoException;
import jxta.security.hash.Hash;
import jxta.security.impl.publickey.RSAKey;
import jxta.security.publickey.PublicKeyAlgorithm;
import jxta.security.signature.Signature;
import jxta.security.util.Util;

public class RSASignature
implements Signature {
    private static String myname = "Signature";
    private static byte type = 0;
    private static Hash digest = null;
    private static PublicKeyAlgorithm rsa;
    private static RSAKey rKey;
    private static byte mode;
    private boolean debug = false;

    public RSASignature() {
    }

    public String getAlgorithmName() {
        return myname;
    }

    public RSASignature(PublicKeyAlgorithm publicKeyAlgorithm, RSAKey rSAKey, byte by, Hash hash) {
        rsa = publicKeyAlgorithm;
        rKey = rSAKey;
        digest = hash;
        type = by;
    }

    public byte getAlgorithm() {
        return type;
    }

    public void setDebug() {
        this.debug = true;
    }

    public void clearDebug() {
        this.debug = false;
    }

    public void init(byte by) throws CryptoException {
        if (by != 1 && by != 2) {
            throw new CryptoException(3);
        }
        mode = by;
    }

    public void update(byte[] byArray, int n, int n2) throws CryptoException {
        if (byArray.length < n + n2) {
            throw new CryptoException(2);
        }
        digest.update(byArray, n, n2);
    }

    public byte[] sign(byte[] byArray, int n, int n2) throws CryptoException {
        if (mode != 1) {
            throw new CryptoException(3);
        }
        byte[] byArray2 = new byte[digest.getDigestLength()];
        digest.doFinal(byArray, n, n2, byArray2, 0);
        byte[] byArray3 = rsa.Algorithm(byArray2, 0, byArray2.length, (byte)2, true);
        return byArray3;
    }

    public boolean verify(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws CryptoException {
        if (mode != 2) {
            throw new CryptoException(3);
        }
        byte[] byArray3 = new byte[digest.getDigestLength()];
        digest.doFinal(byArray, n, n2, byArray3, 0);
        byte[] byArray4 = rsa.Algorithm(byArray2, n3, n4, (byte)1, false);
        if (this.debug) {
            System.out.println("Digest [" + byArray3.length + "] =\n" + Util.hexEncode(byArray3) + "\nDecrypted Signature [" + byArray4.length + "] =\n" + Util.hexEncode(byArray4));
        }
        if (byArray4.length == byArray3.length) {
            int n5 = 0;
            while (n5 < byArray3.length) {
                if (byArray4[n5] != byArray3[n5]) {
                    return false;
                }
                ++n5;
            }
        } else {
            return false;
        }
        return true;
    }

    static {
        rKey = null;
    }
}

