/*
 * Decompiled with CFR 0.152.
 */
package jxta.security.impl.publickey;

import java.math.BigInteger;
import jxta.security.exceptions.CryptoException;
import jxta.security.impl.publickey.RSAKey;
import jxta.security.impl.random.JRandom;
import jxta.security.publickey.PublicKeyAlgorithm;
import jxta.security.publickey.RSAPrivatekeyData;
import jxta.security.publickey.RSAPublickeyData;
import jxta.security.util.Util;

public class RSA
implements PublicKeyAlgorithm {
    static final int CERTAINTY = 80;
    static final BigInteger ONE = BigInteger.valueOf(1L);
    static final BigInteger F4 = BigInteger.valueOf(65537L);
    private static short keySize = (short)512;
    private static short keyLength = 0;
    private static RSAKey rsaKey = null;
    private static JRandom random = null;
    private static boolean publicSet = false;
    private static BigInteger p;
    private static BigInteger q;
    private static BigInteger n;
    private static BigInteger e;
    private static BigInteger d;
    private static BigInteger pExpP;
    private static BigInteger pExpQ;
    private static BigInteger crtCoef;
    private static int maxDataLength;
    private static boolean canUsePublic;
    private static boolean publicCalculated;
    private static boolean canUsePrivate;
    private boolean debug = false;
    private static String myname;
    private static byte PRBT;
    private static byte PUBT;

    public RSA(RSAKey rSAKey) throws CryptoException {
        keySize = rSAKey.getSize();
        keyLength = (short)(keySize >>> 3);
        rsaKey = rSAKey;
        random = new JRandom();
        this.reset();
        maxDataLength = keyLength - 11;
    }

    public void setDebug() {
        this.debug = true;
    }

    public void clearDebug() {
        this.debug = false;
    }

    public void reset() {
        p = BigInteger.valueOf(0L);
        q = BigInteger.valueOf(0L);
        n = BigInteger.valueOf(0L);
        e = BigInteger.valueOf(0L);
        d = BigInteger.valueOf(0L);
        pExpP = BigInteger.valueOf(0L);
        pExpQ = BigInteger.valueOf(0L);
        crtCoef = BigInteger.valueOf(0L);
        canUsePublic = false;
        publicCalculated = false;
        canUsePrivate = false;
    }

    public String getAlgorithmName() {
        return myname;
    }

    private BigInteger rsa(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger.modPow(bigInteger2, bigInteger3);
        return bigInteger4;
    }

    private BigInteger crt(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.mod(p).modPow(pExpP, p);
        BigInteger bigInteger3 = bigInteger.mod(q).modPow(pExpQ, q);
        if (this.debug) {
            System.out.println("crt(X):\np2.length = " + bigInteger2.bitLength() + "\np2 = " + bigInteger2 + "\nq2.length = " + bigInteger3.bitLength() + "\nq2 = " + bigInteger3);
        }
        if (bigInteger2.equals(bigInteger3)) {
            return bigInteger3;
        }
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3).mod(p);
        BigInteger bigInteger5 = bigInteger4.multiply(crtCoef).mod(p);
        if (this.debug) {
            System.out.println("crt(X):\ncoef.length = " + crtCoef.bitLength() + "\ncoef = " + crtCoef + "\nk.length = " + bigInteger4.bitLength() + "\nk = " + bigInteger4 + "\nl.length = " + bigInteger5.bitLength() + "\nl = " + bigInteger5 + "\nq.length = " + q.bitLength() + "\nq = " + q);
        }
        return q.multiply(bigInteger5).add(bigInteger3);
    }

    public int getMaxInputDataBlockLength() {
        return maxDataLength;
    }

    public int getEncryptionBlockLength() {
        return keyLength;
    }

    public byte[] Algorithm(byte[] byArray, int n, int n2, byte by, boolean bl) throws CryptoException {
        BigInteger bigInteger;
        if (byArray.length < n + n2) {
            throw new CryptoException(2);
        }
        if (!(canUsePublic && by == 1 || canUsePrivate && by == 2)) {
            throw new CryptoException(5);
        }
        byte[] byArray2 = null;
        if (!bl) {
            byArray2 = new byte[n2];
            int n3 = 0;
            int n4 = n;
            while (n3 < n2) {
                byArray2[n3] = byArray[n4++];
                ++n3;
            }
        } else {
            if (n2 > maxDataLength) {
                throw new CryptoException(9);
            }
            byArray2 = this.addRSApadding(byArray, n, n2, by);
        }
        BigInteger bigInteger2 = new BigInteger(byArray2);
        String string = null;
        if (canUsePrivate && by == 2) {
            string = "Private";
            bigInteger = this.crt(bigInteger2);
        } else {
            string = "Public";
            bigInteger = this.rsa(bigInteger2, e, RSA.n);
        }
        if (this.debug) {
            System.out.println("RSAAlgorithm, " + string + ": encrypt = " + bl + ", Y has " + bigInteger.bitLength() + " bits");
        }
        byte[] byArray3 = bigInteger.toByteArray();
        if (this.debug) {
            System.out.println("Result: byte[] Y =\n" + Util.hexEncode(byArray3));
        }
        if (!bl) {
            byArray3 = this.removePadding(byArray3);
        }
        return byArray3;
    }

    private byte[] addRSApadding(byte[] byArray, int n, int n2, byte by) {
        int n3 = 0;
        int n4 = n + 2;
        int n5 = keyLength - 3 - n2;
        byte[] byArray2 = new byte[keyLength];
        byArray2[0] = 0;
        if (by == 2) {
            byArray2[1] = PRBT;
            n3 = 0;
            while (n3 < n5) {
                byArray2[n4++] = -1;
                ++n3;
            }
        } else {
            byArray2[1] = PUBT;
            byte[] byArray3 = new byte[n5];
            random.nextBytes(byArray3);
            n3 = 0;
            while (n3 < n5) {
                if (byArray3[n3] == 0) {
                    byArray3[n3] = -1;
                }
                byArray2[n4++] = byArray3[n3];
                ++n3;
            }
        }
        byArray2[n4++] = 0;
        n3 = n4;
        int n6 = 0;
        while (n6 < n2) {
            byArray2[n3++] = byArray[n6];
            ++n6;
        }
        if (this.debug) {
            System.out.println("Padded: RSA EB(" + byArray2.length + ":PS " + n5 + ":D " + n2 + ")=\n" + Util.hexEncode(byArray2));
        }
        return byArray2;
    }

    private byte[] removePadding(byte[] byArray) throws CryptoException {
        if (this.debug) {
            System.out.println("\nremovePadding, EB(" + byArray.length + ")=\n" + Util.hexEncode(byArray));
        }
        boolean bl = true;
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n - 2;
        if (byArray[0] == PRBT) {
            n3 = 1;
            n4 = 0;
            while (n4 < n6) {
                if (byArray[n3] != -1) break;
                ++n5;
                ++n3;
                ++n4;
            }
            if (byArray[n3] == 0) {
                bl = false;
            }
        } else if (byArray[0] == PUBT) {
            n3 = 1;
            n4 = 0;
            while (n4 < n6) {
                if (byArray[n3] == 0) break;
                ++n5;
                ++n3;
                ++n4;
            }
            if (n5 >= 8) {
                bl = false;
            }
        }
        if (!bl) {
            int n7 = n - n5 - 2;
            byte[] byArray2 = new byte[n7];
            n2 = 0;
            n4 = n3 + 1;
            while (n2 < n7) {
                byArray2[n2] = byArray[n4++];
                ++n2;
            }
            if (this.debug) {
                System.out.println("Without padding =\n" + Util.hexEncode(byArray2));
            }
            return byArray2;
        }
        throw new CryptoException(8);
    }

    public void setPrivateKey() throws CryptoException {
        if (!publicCalculated) {
            throw new CryptoException(7);
        }
        BigInteger bigInteger = p.subtract(ONE);
        BigInteger bigInteger2 = q.subtract(ONE);
        BigInteger bigInteger3 = bigInteger2.multiply(bigInteger);
        d = e.modInverse(bigInteger3);
        pExpP = d.mod(bigInteger);
        pExpQ = d.mod(bigInteger2);
        crtCoef = q.modInverse(p);
        byte[] byArray = d.toByteArray();
        byte[] byArray2 = pExpP.toByteArray();
        byte[] byArray3 = pExpQ.toByteArray();
        byte[] byArray4 = crtCoef.toByteArray();
        byte[] byArray5 = p.toByteArray();
        byte[] byArray6 = q.toByteArray();
        byte[] byArray7 = n.toByteArray();
        this.saveRSAPrivateKey(byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7);
        canUsePrivate = true;
    }

    public void setPrivateKey(Object object) throws CryptoException {
        RSAPrivatekeyData rSAPrivatekeyData = null;
        try {
            rSAPrivatekeyData = (RSAPrivatekeyData)object;
        }
        catch (ClassCastException classCastException) {
            throw new CryptoException(2);
        }
        p = new BigInteger(rSAPrivatekeyData.getPrimeP());
        q = new BigInteger(rSAPrivatekeyData.getPrimeQ());
        n = new BigInteger(rSAPrivatekeyData.getModulus());
        d = new BigInteger(rSAPrivatekeyData.getPrivateExponentD());
        e = F4;
        pExpP = new BigInteger(rSAPrivatekeyData.getPrimeExponentP());
        pExpQ = new BigInteger(rSAPrivatekeyData.getPrimeExponentQ());
        crtCoef = new BigInteger(rSAPrivatekeyData.getCrtCoefficient());
        this.saveRSAPrivateKey(rSAPrivatekeyData.getPrivateExponentD(), rSAPrivatekeyData.getPrimeExponentP(), rSAPrivatekeyData.getPrimeExponentQ(), rSAPrivatekeyData.getCrtCoefficient(), rSAPrivatekeyData.getPrimeP(), rSAPrivatekeyData.getPrimeQ(), rSAPrivatekeyData.getModulus());
        canUsePrivate = true;
    }

    private void saveRSAPrivateKey(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7) throws CryptoException {
        rsaKey.setPrivateExponent(byArray, 0, byArray.length);
        rsaKey.setPrimeExponentP(byArray2, 0, byArray2.length);
        rsaKey.setPrimeExponentQ(byArray3, 0, byArray3.length);
        rsaKey.setCrtCoefficient(byArray4, 0, byArray4.length);
        rsaKey.setPrimeP(byArray5, 0, byArray5.length);
        rsaKey.setPrimeQ(byArray6, 0, byArray6.length);
        rsaKey.setModulus(byArray7, 0, byArray7.length);
    }

    public void setPublicKey() throws CryptoException {
        int n = keySize / 2;
        int n2 = keySize - n;
        do {
            p = new BigInteger(n, 80, random);
            q = new BigInteger(n2, 80, random);
            RSA.n = p.multiply(q);
        } while (p.compareTo(q) == 0 || RSA.n.bitLength() != keySize);
        if (this.debug) {
            System.out.println("plen = " + p.bitLength() + "\np = " + p + "\nqlen = " + q.bitLength() + "\nq = " + q + "\nnlen = " + RSA.n.bitLength() + "\nn = " + RSA.n);
        }
        e = F4;
        byte[] byArray = p.toByteArray();
        byte[] byArray2 = q.toByteArray();
        byte[] byArray3 = RSA.n.toByteArray();
        byte[] byArray4 = e.toByteArray();
        rsaKey.setPublicExponent(byArray4, 0, byArray4.length);
        rsaKey.setModulus(byArray3, 0, byArray3.length);
        rsaKey.setPrimeP(byArray, 0, byArray.length);
        rsaKey.setPrimeQ(byArray2, 0, byArray2.length);
        publicCalculated = true;
        canUsePublic = true;
    }

    public void setPublicKey(byte[] byArray) throws CryptoException {
        n = new BigInteger(byArray);
        e = F4;
        byte[] byArray2 = e.toByteArray();
        rsaKey.setPublicExponent(byArray2, 0, (short)byArray2.length);
        rsaKey.setModulus(byArray, 0, (short)byArray.length);
        canUsePublic = true;
    }

    public void setPublicKey(Object object) throws CryptoException {
        RSAPublickeyData rSAPublickeyData = null;
        try {
            rSAPublickeyData = (RSAPublickeyData)object;
        }
        catch (ClassCastException classCastException) {
            throw new CryptoException(2);
        }
        n = new BigInteger(rSAPublickeyData.getModulus());
        e = F4;
        byte[] byArray = e.toByteArray();
        rsaKey.setPublicExponent(byArray, 0, (short)byArray.length);
        rsaKey.setModulus(rSAPublickeyData.getModulus(), 0, (short)rSAPublickeyData.getModulusLength());
        canUsePublic = true;
    }

    public Object getPublickey() throws CryptoException {
        if (!canUsePublic) {
            throw new CryptoException(7);
        }
        RSAPublickeyData rSAPublickeyData = new RSAPublickeyData(rsaKey);
        return rSAPublickeyData;
    }

    public Object getPrivatekey() throws CryptoException {
        if (!canUsePrivate) {
            throw new CryptoException(7);
        }
        RSAPrivatekeyData rSAPrivatekeyData = new RSAPrivatekeyData(rsaKey);
        return rSAPrivatekeyData;
    }

    static {
        canUsePublic = false;
        publicCalculated = false;
        canUsePrivate = false;
        myname = "RSA Algorithm";
        PRBT = 1;
        PUBT = (byte)2;
    }
}

