/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.Column;
import com.workingdogs.village.DataSetException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Schema {
    private String tableName = "";
    private String columnsAttribute = null;
    private int numberOfColumns = 0;
    private Column[] columns;
    private static Hashtable schemaCache = new Hashtable();
    private Hashtable tableHash;
    private boolean singleTable = true;

    void appendTableName(String string) {
        this.tableName = String.valueOf(this.tableName) + " " + string;
    }

    public String attributes() {
        return this.columnsAttribute;
    }

    public Column column(int n) throws DataSetException {
        if (n == 0) {
            throw new DataSetException("Columns are 1 based");
        }
        if (n > this.numberOfColumns) {
            throw new DataSetException("There are only " + this.numberOfColumns() + " available!");
        }
        try {
            return this.columns[n];
        }
        catch (Exception exception) {
            throw new DataSetException("Column number: " + this.numberOfColumns() + " does not exist!");
        }
    }

    public Column column(String string) throws DataSetException {
        return this.column(this.index(string));
    }

    public String[] getAllTableNames() {
        Enumeration enumeration = this.tableHash.keys();
        String[] stringArray = new String[this.tableHash.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public Column getColumn(String string) throws DataSetException {
        int n = string.indexOf(46);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return this.getColumn(string2, string3);
        }
        return this.column(this.index(string));
    }

    public Column getColumn(String string, String string2) throws DataSetException {
        return (Column)((Hashtable)this.tableHash.get(string)).get(string2);
    }

    Column[] getColumns() {
        return this.columns;
    }

    public String getTableName() throws DataSetException {
        if (this.singleTable) {
            return this.tableName;
        }
        throw new DataSetException("This schema represents several tables.");
    }

    public int index(String string) throws DataSetException {
        int n = string.indexOf(46);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return this.index(string2, string3);
        }
        int n2 = 1;
        while (n2 <= this.numberOfColumns()) {
            if (this.columns[n2].name().equalsIgnoreCase(string)) {
                return n2;
            }
            ++n2;
        }
        throw new DataSetException("Column name: " + string + " does not exist!");
    }

    public int index(String string, String string2) throws DataSetException {
        int n = 1;
        while (n <= this.numberOfColumns()) {
            if (this.columns[n].name().equalsIgnoreCase(string2) && this.columns[n].getTableName().equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        throw new DataSetException("Column name: " + string2 + " does not exist!");
    }

    public boolean isSingleTable() {
        return this.singleTable;
    }

    public int numberOfColumns() {
        return this.numberOfColumns;
    }

    void populate(ResultSetMetaData resultSetMetaData, String string) throws SQLException, DataSetException {
        this.numberOfColumns = resultSetMetaData.getColumnCount();
        this.columns = new Column[this.numberOfColumns() + 1];
        int n = 1;
        while (n <= this.numberOfColumns()) {
            Column column = new Column();
            column.populate(resultSetMetaData, n, string);
            this.columns[n] = column;
            if (n > 1 && !column.getTableName().equalsIgnoreCase(this.columns[n - 1].getTableName())) {
                this.singleTable = false;
            }
            ++n;
        }
        if (this.singleTable) {
            if (string != null && string.length() > 0) {
                this.setTableName(string);
            } else {
                try {
                    this.setTableName(resultSetMetaData.getTableName(1));
                }
                catch (Exception exception) {
                    this.setTableName("");
                }
            }
        } else {
            this.tableHash = new Hashtable((int)(1.25 * (double)this.numberOfColumns + 1.0));
            int n2 = 1;
            while (n2 <= this.numberOfColumns()) {
                if (this.tableHash.containsKey(this.columns[n2].getTableName())) {
                    ((Hashtable)this.tableHash.get(this.columns[n2].getTableName())).put(this.columns[n2].name(), this.columns[n2]);
                } else {
                    Hashtable<String, Column> hashtable = new Hashtable<String, Column>((int)(1.25 * (double)this.numberOfColumns + 1.0));
                    hashtable.put(this.columns[n2].name(), this.columns[n2]);
                    this.tableHash.put(this.columns[n2].getTableName(), hashtable);
                }
                ++n2;
            }
        }
    }

    public Schema schema(Connection connection, String string) throws SQLException, DataSetException {
        return this.schema(connection, string, "*");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Schema schema(Connection connection, String string, String string2) throws SQLException, DataSetException {
        Schema schema;
        if (string2 == null) {
            string2 = "*";
        }
        Statement statement = null;
        try {
            String string3 = String.valueOf(connection.getMetaData().getURL()) + string;
            Schema schema2 = (Schema)schemaCache.get(string3);
            if (schema2 == null) {
                Hashtable hashtable = schemaCache;
                synchronized (hashtable) {
                    schema2 = (Schema)schemaCache.get(string3);
                    if (schema2 == null) {
                        String string4 = "SELECT " + string2 + " FROM " + string + " WHERE 1 = -1";
                        statement = connection.createStatement();
                        ResultSet resultSet = statement.executeQuery(string4);
                        if (resultSet == null) throw new DataSetException("Couldn't retrieve schema for " + string);
                        schema2 = new Schema();
                        schema2.setTableName(string);
                        schema2.setAttributes(string2);
                        schema2.populate(resultSet.getMetaData(), string);
                        schemaCache.put(string3, schema2);
                    }
                }
            }
            schema = schema2;
            Object var7_11 = null;
            if (statement == null) return schema;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
        return schema;
    }

    void setAttributes(String string) {
        this.columnsAttribute = string;
    }

    void setTableName(String string) {
        this.tableName = string;
    }

    public String tableName() throws DataSetException {
        return this.getTableName();
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            printWriter.print('{');
            int n = 1;
            while (n <= this.numberOfColumns) {
                printWriter.print('\'');
                if (!this.singleTable) {
                    printWriter.print(String.valueOf(this.columns[n].getTableName()) + '.');
                }
                printWriter.print(String.valueOf(this.columns[n].name()) + '\'');
                if (n < this.numberOfColumns) {
                    printWriter.print(',');
                }
                ++n;
            }
            printWriter.print('}');
            printWriter.flush();
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

