/*
 * Decompiled with CFR 0.152.
 */
package org.openprivacy.sierra.util.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openprivacy.sierra.util.sql.BaseStatement;
import org.openprivacy.sierra.util.sql.SelectType;
import talon.ComponentFactory;

public class Select
extends BaseStatement {
    private ResultSet resultSet = null;

    public void commit() throws Exception {
        String select = this.buildSQLStatement();
        Connection connection = this.getDatabaseConnectionPool().getConnection();
        Statement statement = connection.createStatement();
        ComponentFactory.getLogger().debug((Object)select);
        this.resultSet = statement.executeQuery(select);
        connection.commit();
        this.getDatabaseConnectionPool().releaseConnection(connection);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    private String buildSQLStatement() {
        Vector v = new Vector();
        v = this.buildSQLStatementVector(this.getStrings(), v, 1);
        v = this.buildSQLStatementVector(this.getIntegers(), v, 2);
        return this.buildSQLStatement(v);
    }

    private Vector buildSQLStatementVector(Hashtable hash, Vector vector, int type) {
        Enumeration keys = hash.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            Object value = hash.get(name);
            vector.addElement(new SelectType(type, name, value));
        }
        return vector;
    }

    private String buildSQLStatement(Vector criteria) {
        StringBuffer buff = new StringBuffer();
        buff.append("SELECT * FROM ");
        buff.append(this.getTable());
        buff.append(" WHERE ");
        int i = 0;
        while (i < criteria.size()) {
            SelectType st = (SelectType)criteria.elementAt(i);
            buff.append(st.getName());
            buff.append(" = ");
            if (st.getType() == 1) {
                buff.append("'");
            }
            buff.append(st.getValue().toString());
            if (st.getType() == 1) {
                buff.append("'");
            }
            if (i < criteria.size() - 1) {
                buff.append(" AND  ");
            }
            ++i;
        }
        buff.append(";");
        return buff.toString();
    }
}

