/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.metamata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.metamata.AbstractMetamataTask;
import org.apache.tools.ant.taskdefs.optional.metamata.MMetricsStreamHandler;
import org.apache.tools.ant.types.Path;

public class MMetrics
extends AbstractMetamataTask {
    protected String granularity = null;
    protected File outFile = null;
    protected File tmpFile = AbstractMetamataTask.createTmpFile();
    protected Path path = null;

    public MMetrics() {
        super("com.metamata.sc.MMetrics");
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public void setTofile(File file) {
        this.outFile = file;
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(((ProjectComponent)this).project);
        }
        return this.path;
    }

    protected void checkOptions() throws BuildException {
        super.checkOptions();
        if (!("files".equals(this.granularity) || "methods".equals(this.granularity) || "types".equals(this.granularity))) {
            throw new BuildException("Metrics reporting granularity is invalid. Must be one of 'files', 'methods', 'types'");
        }
        if (this.outFile == null) {
            throw new BuildException("Output XML file must be set via 'tofile' attribute.");
        }
        if (this.path == null && this.fileSets.size() == 0) {
            throw new BuildException("Must set either paths (path element) or files (fileset element)");
        }
        if (this.path != null && this.fileSets.size() > 0) {
            throw new BuildException("Cannot set paths (path element) and files (fileset element) at the same time");
        }
    }

    protected void execute0(ExecuteStreamHandler handler) throws BuildException {
        super.execute0(handler);
        this.transformFile();
    }

    /*
     * Loose catch block
     */
    protected void transformFile() throws BuildException {
        block16: {
            IOException ignored22;
            FileOutputStream xmlStream;
            FileInputStream tmpStream;
            block15: {
                tmpStream = null;
                try {
                    tmpStream = new FileInputStream(this.tmpFile);
                }
                catch (IOException e) {
                    throw new BuildException("Error reading temporary file: " + this.tmpFile, (Throwable)e);
                }
                xmlStream = null;
                xmlStream = new FileOutputStream(this.outFile);
                MMetricsStreamHandler xmlHandler = new MMetricsStreamHandler(this, xmlStream);
                xmlHandler.setProcessOutputStream(tmpStream);
                xmlHandler.start();
                xmlHandler.stop();
                Object var5_6 = null;
                if (xmlStream == null) break block15;
                try {
                    xmlStream.close();
                }
                catch (IOException ignored22) {
                    // empty catch block
                }
            }
            if (tmpStream != null) {
                try {
                    tmpStream.close();
                }
                catch (IOException ignored22) {}
            }
            break block16;
            {
                catch (IOException e) {
                    throw new BuildException("Error creating output file: " + this.outFile, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOException ignored22;
                Object var5_7 = null;
                if (xmlStream != null) {
                    try {
                        xmlStream.close();
                    }
                    catch (IOException ignored22) {
                        // empty catch block
                    }
                }
                if (tmpStream != null) {
                    try {
                        tmpStream.close();
                    }
                    catch (IOException ignored22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    protected void cleanUp() throws BuildException {
        block3: {
            try {
                super.cleanUp();
                Object var2_1 = null;
                if (this.tmpFile == null) break block3;
                this.tmpFile.delete();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.tmpFile != null) {
                    this.tmpFile.delete();
                    this.tmpFile = null;
                }
                throw throwable;
            }
            this.tmpFile = null;
            {
            }
        }
    }

    protected ExecuteStreamHandler createStreamHandler() {
        return new LogStreamHandler((Task)this, 2, 2);
    }

    protected Vector getOptions() {
        Vector<String> options = new Vector<String>(512);
        if (this.sourcePath != null) {
            this.sourcePath.append(this.classPath);
            this.classPath = this.sourcePath;
            this.sourcePath = null;
        }
        if (this.classPath != null) {
            options.addElement("-classpath");
            options.addElement((String)this.classPath);
        }
        options.addElement("-output");
        options.addElement(this.tmpFile.toString());
        options.addElement("-" + this.granularity);
        options.addElement("-format");
        options.addElement("tab");
        options.addElement("-i");
        options.addElement("/");
        String[] dirs = this.path.list();
        int i = 0;
        while (i < dirs.length) {
            options.addElement(dirs[i]);
            ++i;
        }
        AbstractMetamataTask.addAllVector(options, this.includedFiles.keys());
        return options;
    }
}

