<?xml version="1.0"?> 

<!--

$Id: mozilla-manage.xsl,v 1.4 2002/02/25 08:16:07 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- Use <xsl:sort select="@name"/> to sort the channels like they are originally
displayed.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:cl="http://schemas.openprivacy.org/reptile/content-list"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                xmlns:escape="xalan://org.openprivacy.reptile.extensions.EscapeExtension"
                xmlns:channel-extension="xalan://org.openprivacy.reptile.extensions.om.ChannelExtension"
                extension-element-prefixes="escape channel-extension"
                version="1.0">

    <xsl:output indent="yes" omit-xml-declaration="yes"/>

    <xsl:template match="/layout:layout">

        <control:content help="manage-subscriptions">

            <dc:title>Manage Subscriptions</dc:title>

            <dc:description>
                This control allows you to view channels and jump between them.
            </dc:description>
    
            <control:body>

                <img src="/reptile/images/manage-subscriptions.png"
                     align="right"
                     hspace="10"
                     vspace="10"/>
                
                <xsl:for-each select="./layout:layer-index/layout:layer">

                    <xsl:sort select="@name"/>

                    <xsl:variable name="layer" select="@name"/>

                    <table>

                        <td>
                            <img src="/reptile/images/layer.png"/>

                        </td>

                        <td>
                            
                            <link-producer:view-subscription-category name="{$layer}"/>

                        </td>

                    </table>

                    <table cellpadding="1" cellspacing="2">
                        
                        <xsl:apply-templates select="/layout:layout/layout:content/layout:position[@layer = $layer]"/>
                        
                    </table>
                    
                </xsl:for-each>
                    
            </control:body>
        
        </control:content>

    </xsl:template>

    <xsl:template match="layout:layer">

        <xsl:variable name="layer" select="@name"/>

        <link-producer:view-layer name="{$layer}"/>

        <br/>
        
        <blockquote>

            <table cellpadding="5" cellspacing="5">
            
                <xsl:apply-templates select="/layout:layout/layout:content/layout:position[@layer = $layer]"/>

            </table>
                
        </blockquote>
            
    </xsl:template>
    
    <xsl:template match="layout:position">

        <xsl:if test="contains( ../@location, 'urn:' ) = false">

            <tr>

                <td width="15">

                </td>

                <td>
                
                    <!-- FIXME: can't use dc:title -->
                    <link-producer:favicon site="{../@location}" 
                                           contentType="{../@contentType}" 
                                           location="{../@location}"
                                           name="{ escape:attributes( ./dc:title ) }"/>
                </td>

                <td>
                
                    <link-producer:link link-name="urn:manage-subscription"
                                        location="{../@location}"
                                        contentType="{../@contentType}"
                                        title="{ channel-extension:getTitle( ../@location ) }"/>

                </td>
                
            </tr>
        
        </xsl:if>
            
    </xsl:template>
    
</xsl:stylesheet>

