<?xml version="1.0"?> 

<!--

$Id: enumerate.xsl,v 1.4 2001/09/24 08:52:29 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

TODO:

- This page is setup to process each channel into a content-list.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:transformer="xalan://org.openprivacy.reptile.extensions.ContentTransformer"
                extension-element-prefixes="transformer"
                exclude-result-prefixes="layout page"
                version="1.0">

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <xsl:param name="outputFormat" select="'http://schemas.openprivacy.org/reptile/content-list'"/>

    <xsl:param name="skip" select="'urn:quick-channel'"/>

    <xsl:template match="/layout:layout">

        <transformer:init/>

        <layout:layout>

        <xsl:apply-templates select="/layout:layout/layout:layer-index/layout:layer"/>

        </layout:layout>

    </xsl:template>

    <xsl:template match="layout:layer">
    
        <xsl:variable name="layer" select="@name"/>

        <layout:layer name="{@name}">

            <xsl:apply-templates select="/layout:layout/layout:content/layout:position[@layer = $layer]"/>

        </layout:layer>

    </xsl:template>

    <xsl:template match="layout:position">

        <xsl:variable name="contentType" select="../@contentType"/>

        <xsl:variable name="location" select="../@location"/>

        <!-- copy over the content link -->

        <xsl:if test="starts-with( $location, $skip ) = false">

            <layout:content location="{$location}" 
                            contentType="{$contentType}"
                            layer="{@layer}">
    
                <xsl:value-of select="transformer:transform( $location, $contentType, $outputFormat )"
                              disable-output-escaping="yes"/>
    
            </layout:content>

        </xsl:if>

    </xsl:template>
    
</xsl:stylesheet>

