<?xml version="1.0"?> 

<!--

     $Id: mozilla-add.xsl,v 1.8 2002/02/21 05:53:06 burton Exp $

     ==== BEGIN LICENSE ==============================================================

     Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
     Copyright (C) 2000-2003 OpenPrivacy.org

     This program is free software; you can redistribute it and/or modify it under
     the terms of the LICENSE which you should have obtaind with this package.

     This program is distributed in the hope that it will be useful, but WITHOUT ANY
     WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
     PARTICULAR PURPOSE.

     ==== END LICENSE ================================================================

     Overview:

     Responsible for rendering Mozilla layout controls.  

     See http://reptile.openprivacy.org for more information

     -->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:sub="http://schemas.openprivacy.org/reptile/subscriptions"
                xmlns:add="http://schemas.openprivacy.org/reptile/publish/add"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:article-extension="xalan://org.openprivacy.reptile.extensions.om.ArticleExtension"
                extension-element-prefixes="article-extension"
                exclude-result-prefixes="dc transformer sub control"
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>

    <xsl:param name="reptile.home.location" select="''"/>

    <xsl:param name="reptile.sequence.name" select="''"/>

    <xsl:param name="reptile.link" select="'http://'"/>

    <xsl:param name="reptile.syndication.publish.input.size" select="'65'"/>

    <xsl:param name="reptile.syndication.publish.textarea.rows" select="'6'"/>

    <xsl:param name="reptile.syndication.publish.textarea.cols" select="'60'"/>

    <xsl:template match="add:add">

        <control:content help="publish-new-content">
            
            <dc:title>Publish new content</dc:title>
            
            <control:body>
                
                <form action="{$reptile.home.location}" method="post">
                    
                    <div align="center">
                        
                        <table>

                            <tr>

                                <td>

                                    <table>
                                        <td>

                                            <td>            
                                                <img hspace="3" vspace="3" src="/reptile/images/publish.png"/>

                                            </td>

                                            <td class="reptile-spacing">

                                                <p>
                                                    This allows you to publish new content with your RSS channel.  
                                                </p>

                                                <p>
                                                    This new
                                                    content will then be available to other users who subscribe to your
                                                    publications.
                                                </p>

                                            </td>
                                        </td>
                                    </table>

                                </td>            

                            </tr>

                            <tr>
                                
                                <td>
                                    
                                    <b>URL: </b>
                                    
                                    <input type="text" 
                                           name="reptile.link" 
                                           size="{$reptile.syndication.publish.input.size}" 
                                           value="{$reptile.link}"/>
                                    
                                </td>        
                                
                            </tr>        
                            
                            <tr>
                                
                                <td>
                                    
                                    <b>Title: </b>
                                    
                                    <input type="text" 
                                           name="reptile.link.title" 
                                           size="{$reptile.syndication.publish.input.size}"
                                           value="{article-extension:getTitle( $reptile.link )}"/>
                                    
                                </td>        
                                
                            </tr>        
                            
                            

                            <tr>

                                <td>

                                    <fieldset>

                                        <legend>Quote:</legend>

                                        <textarea class="largemargin" 
                                                  rows="{$reptile.syndication.publish.textarea.rows}" 
                                                  cols="{$reptile.syndication.publish.textarea.cols}" 
                                                  name="reptile.link.description">
                                            
                                            <xsl:value-of select="article-extension:getDescription( $reptile.link )"/>
                                            
                                        </textarea>

                                    </fieldset>
                                    
                                </td>
                                
                            </tr>

                            <tr>
                                
                                <td>

                                    <fieldset>

                                        <legend>Your comments:</legend>
                                        
                                        <!-- support for user comments -->
                                        <textarea class="largemargin" 
                                                  rows="{$reptile.syndication.publish.textarea.rows}" 
                                                  cols="{$reptile.syndication.publish.textarea.cols}" 
                                                  name="reptile.publish.comments">
                                            
                                        </textarea>

                                    </fieldset>    

                                </td>
                                
                            </tr>

                            
                            <tr>
                                
                                <td align="right" class="reptile-spacing" >
                                    
                                    <input type="submit" value="Publish" name="Add"/>
                                    
                                </td>
                                
                            </tr>
                            
                        </table>        
                        
                    </div>
                    
                    <!-- Tell the correct action to execute -->
                    <input type="hidden" name="reptile.action" value="UpdatePublication"/>
                    
                    <input type="hidden" name="reptile.action.next.layer" value="Weblog"/>
                    
                    <input type="hidden" name="reptile.action.next.sequence" value="urn:syndication/publish"/>
                    
                </form>
                
                <br/>
                
            </control:body>

        </control:content>

    </xsl:template>

</xsl:stylesheet>


