<?xml version="1.0"?> 

<!--

$Id: manage-subscriptions.xsl,v 1.3 2002/02/27 21:00:25 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:page="http://schemas.openprivacy.org/reptile/mozilla/page"
                xmlns:functions="xalan://org.openprivacy.reptile.extensions.Functions"
                xmlns:bootstrap="http://schemas.openprivacy.org/reptile/bootstrap"
                extension-element-prefixes="functions"
                exclude-result-prefixes="page"
                version="1.0">

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:output indent="yes" 
                omit-xml-declaration="yes"/>                

    <!-- declare all parameters and provide default values -->
    <xsl:param name="reptile.home.location" select="''"/>

    <!-- the layer parameter defines what page layer we should use. -->

    <!-- FIXME: we need to determine the default here. -->
    <xsl:param name="reptile.manage-subscriptions.location"
               select="'http://www.apacheweek.com/issues/apacheweek-headlines.xml'"/>

    <xsl:param name="reptile.manage-subscriptions.contentType"
               select="'http://my.netscape.com/publish/formats/rss-0.91.dtd'"/>

    <xsl:template match="/bootstrap:bootstrap">

        <xsl:message><xsl:value-of select="$test"/></xsl:message>
        
        <layout:layout xmlns="http://schemas.openprivacy.org/reptile/layout">

            <layout:layer-index default="Manage Subscriptions">

                <layout:layer numColumns="2" name="Manage Subscriptions"/>

            </layout:layer-index>

            <layout:content location="{$reptile.manage-subscriptions.location}" 
                            contentType="{$reptile.manage-subscriptions.contentType}">
                
                <layout:position column="left" layer="Manage Subscriptions"/>
                
            </layout:content>
            
            <layout:content location="urn:manage-subscriptions/control" 
                            contentType="http://schemas.openprivacy.org/reptile/stylesheet-sequence">
                
                <layout:position column="right" layer="Manage Subscriptions"/>
                
            </layout:content>

            <layout:content location="urn:view-import" 
                            contentType="http://schemas.openprivacy.org/reptile/stylesheet-sequence">

                <layout:position column="left" layer="Manage Subscriptions"/>
                
            </layout:content>

        </layout:layout>

    </xsl:template>

</xsl:stylesheet>
