<?xml version="1.0"?> 

<!--

$Id: process.xsl,v 1.27 2002/02/27 07:41:51 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

This stylesheet will process a subscription URL and include control markup so
that we can render it as a Control.  Next a brower/platform specific XSLT will
render this control.  

See http://reptile.openprivacy.org for additional information.

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:layout="http://schemas.openprivacy.org/reptile/layout"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:transformer="xalan://org.openprivacy.reptile.extensions.ContentTransformer"
                xmlns:proxy="xalan://org.openprivacy.reptile.extensions.ProxyFunctions"
                xmlns:error="http://schemas.openprivacy.org/reptile/error"
                extension-element-prefixes="transformer proxy"
                exclude-result-prefixes="transformer layout"
                version="1.0">

    <!-- by default, copy all matching templates -->
    <xsl:include href="resource:/xsl/misc/copy.xsl"/>

    <xsl:output indent="yes" encoding="ISO-8859-1"/>                

    <xsl:param name="outputFormat" select="'http://schemas.openprivacy.org/reptile/control/subset'"/>

    <xsl:template match="layout:content">

        <transformer:init/>

        <control:control>    

            <!-- forward the content information.  We need to strip this from
            within the control -->
            <layout:content location="{@location}" 
                            contentType="{@contentType}">

                <layout:position column="{./layout:position/@column}" layer="{./layout:position/@layer}"/>

            </layout:content>

            <control:location><xsl:value-of select="./@location"/></control:location>

            <control:contentType><xsl:value-of select="./@contentType"/></control:contentType>

            <!-- We need to be specific here. If the content is in the proxy (
            and is supported) we can render it.  If not we should tell the user
            this and then try to update it.  -->


            <xsl:value-of select="transformer:transform( ./@location, @contentType, $outputFormat )"
                          disable-output-escaping="yes"/>

        </control:control>    

    </xsl:template>

</xsl:stylesheet>

