<?xml version="1.0"?> 

<!--

$Id: mozilla-about.xsl,v 1.4 2001/08/11 02:07:47 burton Exp $

==== BEGIN LICENSE ==============================================================

Copyright (C) 2000-2003 Kevin A. Burton (burton@openprivacy.org)
Copyright (C) 2000-2003 OpenPrivacy.org

This program is free software; you can redistribute it and/or modify it under
the terms of the LICENSE which you should have obtaind with this package.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.

==== END LICENSE ================================================================

Overview:

See http://reptile.openprivacy.org for more information

-->

<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" 
                xmlns:dc="http://purl.org/dc/elements/1.1/" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:cm="http://schemas.openprivacy.org/reptile/channel-management"
                xmlns:control="http://schemas.openprivacy.org/reptile/control"
                xmlns:about="http://schemas.openprivacy.org/reptile/about"
                xmlns:service="http://schemas.openprivacy.org/reptile/service"
                xmlns:link-producer="http://schemas.openprivacy.org/reptile/link-producer"
                xmlns:logo-producer="http://schemas.openprivacy.org/reptile/logo-producer"
                exclude-result-prefixes=""
                version="1.0">

    <xsl:output indent="yes"
                omit-xml-declaration="yes"/>                

    <xsl:template match="/about:about">

         <control:content>

             <dc:title>

             <xsl:value-of select="about:product/@name"/> Version <xsl:value-of select="about:product/@version"/>
             ( <xsl:value-of select="about:product/@label"/> ) 
             
             
             </dc:title>
    
             <control:body>
    
             <xsl:apply-templates/>
             
             </control:body>

         </control:content>

    </xsl:template>

    <xsl:template match="about:product"/>

    <xsl:template match="about:introduction">

        <xsl:apply-templates/>

    </xsl:template>    

    <xsl:template match="about:author-list">

        <p>
        <h4>Authors: </h4>
        </p>

        <xsl:apply-templates/>

    </xsl:template>    

    <xsl:template match="about:contributor-list">

        <p>
        <h4>Contributors: </h4>
        </p>


        <xsl:apply-templates/>

    </xsl:template>    

    <xsl:template match="about:thanks-list">

        <p>
        <h4>Special thanks go out to: </h4>
        </p>

        <xsl:apply-templates/>

    </xsl:template>    



    <xsl:template match="about:contributor">

        <table>

        <td>

        <logo-producer:bullet/>

        <a href="mailto:{@email}"><xsl:value-of select="@name"/></a>: 

        <xsl:value-of select="."/>

        </td>

        <td>
        <service:service name="micropayment" target="{@email}"/>
        </td>

        </table>

        <link-producer:get-reputation identifier="{@email}"/>

    </xsl:template>    


    <xsl:template match="about:author">

        <p>

        <table>

        <td>

        <logo-producer:bullet/>

        <a href="mailto:{@email}"><xsl:value-of select="@name"/></a>: 

        <xsl:value-of select="."/>

        </td>

        <td>
        <service:service name="micropayment" target="{@email}"/>
        </td>

        </table>

        <link-producer:get-reputation identifier="{@email}"/>

        </p>     

    </xsl:template>    

    <xsl:template match="about:thanks">

        <br/>
    
        <logo-producer:bullet/>

        <a href="mailto:{about:from/@email}"><xsl:value-of select="about:from/@name"/></a> would like
        to thank <a href="mailto:{about:to/@email}"><xsl:value-of
        select="about:to/@name"/></a>: 

        <br/>        

        <xsl:value-of select="."/>

        <link-producer:get-reputation identifier="{@email}"/>

    </xsl:template>    

    <xsl:template match="about:p">

        <p>

        <logo-producer:reptile/>        

        <xsl:value-of select="."/>

        </p>

    </xsl:template>    

</xsl:stylesheet>

