/*
 * Decompiled with CFR 0.152.
 */
package talon;

import talon.BaseAssertable;
import talon.Component;
import talon.ComponentFactory;
import talon.ComponentHandle;
import talon.TalonException;
import talon.components.Logger;
import talon.interfaces.Assertable;
import talon.references.ComponentReferenceFactory;
import talon.references.TypeReferenceFactory;
import talon.util.net.URI;

public abstract class BaseComponent
extends BaseAssertable
implements Component,
Assertable {
    private ComponentHandle handle = null;
    private URI componentReference = null;
    private URI typeReference = null;
    private Class[] componentInterfaces = null;

    public void init() throws TalonException {
    }

    public ComponentHandle getComponentHandle() {
        return this.handle;
    }

    public void setComponentHandle(ComponentHandle handle) {
        this.handle = handle;
    }

    public URI getComponentReference() {
        if (this.componentReference == null) {
            this.componentReference = ComponentReferenceFactory.getComponentReference(this);
        }
        return this.componentReference;
    }

    public URI getTypeReference() {
        if (this.typeReference == null) {
            this.typeReference = TypeReferenceFactory.getTypeReference(this);
        }
        return this.typeReference;
    }

    public Logger getLogger() {
        try {
            return (Logger)ComponentFactory.getInstance(ComponentFactory.TALON_DEFAULT_LOGGER);
        }
        catch (TalonException t) {
            t.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.getComponentHandle().toString();
    }
}

